/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.perms;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deployment.PermissionsDescriptor;
import com.sun.enterprise.deployment.io.PermissionsDeploymentDescriptorFile;
import com.sun.enterprise.security.perms.PermissionXMLParser;
import com.sun.enterprise.security.perms.SMGlobalPolicyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.PermissionCollection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.xml.sax.SAXParseException;

public class XMLPermissionsHandler {
    private static ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
    private DasConfig dasConfig;
    private PermissionCollection declaredPermXml = null;
    private PermissionCollection restrictedPC = null;
    private SMGlobalPolicyUtil.CommponentType compType;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");

    public XMLPermissionsHandler(File base, SMGlobalPolicyUtil.CommponentType type) throws XMLStreamException, FileNotFoundException {
        this.compType = type;
        this.configureAppDeclaredPermissions(base);
        this.checkServerRestrictedPermissions();
    }

    public XMLPermissionsHandler(InputStream restrictPermInput, InputStream allowedPermInput, SMGlobalPolicyUtil.CommponentType type) throws XMLStreamException, FileNotFoundException {
        this.compType = type;
        this.configureAppDeclaredPermissions(allowedPermInput);
        this.checkServerRestrictedPermissions();
    }

    public PermissionCollection getAppDeclaredPermissions() {
        return this.declaredPermXml;
    }

    public PermissionCollection getRestrictedPermissions() {
        return this.restrictedPC;
    }

    private void configureAppDeclaredPermissions(File base) throws XMLStreamException, FileNotFoundException {
        File permissionsXml = new File(base.getAbsolutePath(), "META-INF/permissions.xml");
        if (permissionsXml.exists()) {
            FileInputStream fi = null;
            try {
                PermissionsDeploymentDescriptorFile pddf = new PermissionsDeploymentDescriptorFile();
                if (serviceLocator != null) {
                    this.dasConfig = serviceLocator.getService(DasConfig.class, new Annotation[0]);
                    if (this.dasConfig != null) {
                        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
                        if (xmlValidationLevel.equals("none")) {
                            pddf.setXMLValidation(false);
                        } else {
                            pddf.setXMLValidation(true);
                        }
                        pddf.setXMLValidationLevel(xmlValidationLevel);
                    }
                }
                fi = new FileInputStream(permissionsXml);
                PermissionsDescriptor pd = (PermissionsDescriptor)pddf.read((InputStream)fi);
                this.declaredPermXml = pd.getDeclaredPermissions();
            }
            catch (SAXParseException e) {
                throw new SecurityException(e);
            }
            catch (IOException e) {
                throw new SecurityException(e);
            }
            finally {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("App declared permission = " + this.declaredPermXml);
            }
        }
    }

    private void configureAppDeclaredPermissions(InputStream permInput) throws XMLStreamException, FileNotFoundException {
        if (permInput != null) {
            PermissionXMLParser parser = new PermissionXMLParser(permInput, this.restrictedPC);
            this.declaredPermXml = parser.getPermissions();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("App declared permission = " + this.declaredPermXml);
            }
        }
    }

    private void checkServerRestrictedPermissions() {
        if (this.declaredPermXml == null) {
            return;
        }
        if (this.compType == null) {
            return;
        }
        SMGlobalPolicyUtil.checkRestrictionOfComponentType(this.declaredPermXml, this.compType);
    }
}

