/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActivatorTask;
import org.apache.felix.scr.impl.manager.DelayedComponentManager;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractComponentManager
implements Component {
    private long m_componentId;
    private volatile State m_state;
    private ComponentMetadata m_componentMetadata;
    private List m_dependencyManagers;
    private BundleComponentActivator m_activator;
    private volatile ServiceRegistration m_serviceRegistration;

    protected AbstractComponentManager(BundleComponentActivator activator, ComponentMetadata metadata) {
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
        this.m_componentId = activator != null ? activator.registerComponentId(this) : -1L;
        this.m_state = Disabled.getInstance();
        this.loadDependencyManagers(metadata);
        if (this.isLogEnabled(4)) {
            this.log(4, "Component {0} created: DS={1}, implementation={2}, immediate={3}, default-enabled={4}, factory={5}, configuration-policy={6}, activate={7}, deactivate={8}, modified={9}", new Object[]{metadata.getName(), new Integer(metadata.getNamespaceCode()), metadata.getImplementationClassName(), metadata.isImmediate(), metadata.isEnabled(), metadata.getFactoryIdentifier(), metadata.getConfigurationPolicy(), metadata.getActivate(), metadata.getDeactivate(), metadata.getModified()}, null);
            if (metadata.getServiceMetadata() != null) {
                this.log(4, "Component {0} Services: servicefactory={1}, services={2}", new Object[]{metadata.getName(), metadata.getServiceMetadata().isServiceFactory(), Arrays.asList(metadata.getServiceMetadata().getProvides())}, null);
            }
            if (metadata.getProperties() != null) {
                this.log(4, "Component {0} Properties: {1}", new Object[]{metadata.getName(), metadata.getProperties()}, null);
            }
        }
    }

    public final void enable() {
        this.enableInternal();
        this.getActivator().schedule(new ComponentActivatorTask("Enable", this){

            public void doRun() {
                AbstractComponentManager.this.activateInternal();
            }
        });
    }

    public final void disable() {
        this.getActivator().schedule(new ComponentActivatorTask("Disable", this){

            public void doRun() {
                AbstractComponentManager.this.deactivateInternal(1);
                AbstractComponentManager.this.disableInternal();
            }
        });
    }

    abstract Object getInstance();

    void dispose() {
        this.dispose(5);
    }

    public void dispose(int reason) {
        this.disposeInternal(reason);
    }

    public long getId() {
        return this.m_componentId;
    }

    public String getName() {
        return this.m_componentMetadata.getName();
    }

    public Bundle getBundle() {
        return this.getActivator().getBundleContext().getBundle();
    }

    public String getClassName() {
        return this.m_componentMetadata.getImplementationClassName();
    }

    public String getFactory() {
        return this.m_componentMetadata.getFactoryIdentifier();
    }

    public Reference[] getReferences() {
        if (this.m_dependencyManagers != null && this.m_dependencyManagers.size() > 0) {
            return this.m_dependencyManagers.toArray(new Reference[this.m_dependencyManagers.size()]);
        }
        return null;
    }

    public boolean isImmediate() {
        return this.m_componentMetadata.isImmediate();
    }

    public boolean isDefaultEnabled() {
        return this.m_componentMetadata.isEnabled();
    }

    public String getActivate() {
        return this.m_componentMetadata.getActivate();
    }

    public boolean isActivateDeclared() {
        return this.m_componentMetadata.isActivateDeclared();
    }

    public String getDeactivate() {
        return this.m_componentMetadata.getDeactivate();
    }

    public boolean isDeactivateDeclared() {
        return this.m_componentMetadata.isDeactivateDeclared();
    }

    public String getModified() {
        return this.m_componentMetadata.getModified();
    }

    public String getConfigurationPolicy() {
        return this.m_componentMetadata.getConfigurationPolicy();
    }

    public boolean isServiceFactory() {
        return this.m_componentMetadata.getServiceMetadata() != null && this.m_componentMetadata.getServiceMetadata().isServiceFactory();
    }

    public String[] getServices() {
        if (this.m_componentMetadata.getServiceMetadata() != null) {
            return this.m_componentMetadata.getServiceMetadata().getProvides();
        }
        return null;
    }

    final void enableInternal() {
        this.m_state.enable(this);
    }

    final void activateInternal() {
        this.m_state.activate(this);
    }

    final void deactivateInternal(int reason) {
        this.m_state.deactivate(this, reason);
    }

    final void disableInternal() {
        this.m_state.disable(this);
    }

    final void disposeInternal(int reason) {
        this.m_state.deactivate(this, reason);
        this.m_state.disable(this);
        this.m_state.dispose(this);
    }

    final ServiceReference getServiceReference() {
        State state = this.m_state;
        try {
            return state.getServiceReference(this);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    protected abstract boolean createComponent();

    protected abstract void deleteComponent(int var1);

    protected abstract Object getService();

    final State getSatisfiedState() {
        if (this.m_componentMetadata.isFactory()) {
            if (this.getInstance() != null) {
                return FactoryInstance.getInstance();
            }
            return Factory.getInstance();
        }
        if (this.m_componentMetadata.isImmediate()) {
            return Active.getInstance();
        }
        return Registered.getInstance();
    }

    protected ServiceRegistration registerService() {
        if (this.getComponentMetadata().getServiceMetadata() != null) {
            this.log(4, "registering services", null);
            Dictionary serviceProperties = this.getServiceProperties();
            return this.getActivator().getBundleContext().registerService(this.getComponentMetadata().getServiceMetadata().getProvides(), this.getService(), serviceProperties);
        }
        return null;
    }

    protected void registerComponentService() {
        this.m_serviceRegistration = this.registerService();
    }

    protected final void unregisterComponentService() {
        if (this.m_serviceRegistration != null) {
            this.log(4, "Unregistering the services", null);
            this.m_serviceRegistration.unregister();
            this.m_serviceRegistration = null;
        }
    }

    public BundleComponentActivator getActivator() {
        return this.m_activator;
    }

    final ServiceRegistration getServiceRegistration() {
        return this.m_serviceRegistration;
    }

    void clear() {
        if (this.m_activator != null) {
            this.m_activator.unregisterComponentId(this);
            this.m_activator = null;
        }
        this.m_dependencyManagers.clear();
    }

    public boolean isLogEnabled(int level) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.isLogEnabled(level);
        }
        return false;
    }

    public void log(int level, String message, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, this.getComponentMetadata(), ex);
        }
    }

    public void log(int level, String message, Object[] arguments, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, arguments, this.getComponentMetadata(), ex);
        }
    }

    public final void activate() {
        this.getActivator().schedule(new ComponentActivatorTask("Activate", this){

            public void doRun() {
                AbstractComponentManager.this.activateInternal();
            }
        });
    }

    public final void reactivate(final int reason) {
        this.getActivator().schedule(new ComponentActivatorTask("Reactivate", this){

            public void doRun() {
                AbstractComponentManager.this.deactivateInternal(reason);
                AbstractComponentManager.this.activateInternal();
            }
        });
    }

    public String toString() {
        return "Component: " + this.getName() + " (" + this.getId() + ")";
    }

    private boolean hasServiceRegistrationPermissions() {
        String[] services;
        ServiceMetadata serviceMetadata;
        boolean allowed = true;
        if (System.getSecurityManager() != null && (serviceMetadata = this.getComponentMetadata().getServiceMetadata()) != null && (services = serviceMetadata.getProvides()) != null && services.length > 0) {
            Bundle bundle = this.getBundle();
            for (int i = 0; i < services.length; ++i) {
                ServicePermission perm = new ServicePermission(services[i], "register");
                if (bundle.hasPermission((Object)perm)) continue;
                this.log(3, "Permission to register service {0} is denied", new Object[]{services[i]}, null);
                allowed = false;
            }
        }
        return allowed;
    }

    private void loadDependencyManagers(ComponentMetadata metadata) {
        ArrayList<DependencyManager> depMgrList = new ArrayList<DependencyManager>();
        if (metadata.getDependencies().size() != 0) {
            Iterator dependencyit = metadata.getDependencies().iterator();
            while (dependencyit.hasNext()) {
                ReferenceMetadata currentdependency = (ReferenceMetadata)dependencyit.next();
                DependencyManager depmanager = new DependencyManager(this, currentdependency);
                depMgrList.add(depmanager);
            }
        }
        this.m_dependencyManagers = depMgrList;
    }

    private void enableDependencyManagers() throws InvalidSyntaxException {
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.enable();
        }
    }

    protected boolean verifyDependencyManagers(Dictionary properties) {
        boolean satisfied = true;
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.setTargetFilter(properties);
            if (!dm.hasGetPermission()) {
                this.log(3, "No permission to get dependency: {0}", new Object[]{dm.getName()}, null);
                satisfied = false;
                continue;
            }
            if (dm.isSatisfied()) continue;
            this.log(3, "Dependency not satisfied: {0}", new Object[]{dm.getName()}, null);
            satisfied = false;
        }
        return satisfied;
    }

    Iterator getDependencyManagers() {
        return this.m_dependencyManagers.iterator();
    }

    DependencyManager getDependencyManager(String name) {
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            if (!name.equals(dm.getName())) continue;
            return dm;
        }
        return null;
    }

    private void disableDependencyManagers() {
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.disable();
        }
    }

    public abstract boolean hasConfiguration();

    public abstract Dictionary getProperties();

    public Dictionary getServiceProperties() {
        return AbstractComponentManager.copyTo(null, this.getProperties(), false);
    }

    protected static Dictionary copyTo(Dictionary target, Dictionary source) {
        return AbstractComponentManager.copyTo(target, source, true);
    }

    protected static Dictionary copyTo(Dictionary target, Dictionary source, boolean allProps) {
        if (target == null) {
            target = new Hashtable();
        }
        if (source != null && !source.isEmpty()) {
            Enumeration ce = source.keys();
            while (ce.hasMoreElements()) {
                String key = (String)ce.nextElement();
                if (!allProps && key.charAt(0) == '.') continue;
                ((Dictionary)target).put(key, source.get(key));
            }
        }
        return target;
    }

    public ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    public int getState() {
        return this.m_state.getState();
    }

    protected State state() {
        return this.m_state;
    }

    void changeState(State newState) {
        this.log(4, "State transition : {0} -> {1}", new Object[]{this.m_state, newState}, null);
        this.m_state = newState;
    }

    protected static final class Disposed
    extends State {
        private static final Disposed m_inst = new Disposed();

        private Disposed() {
            super("Disposed", 256);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class Disposing
    extends State {
        private static final Disposing m_inst = new Disposing();

        private Disposing() {
            super("Disposing", 2048);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class Disabling
    extends State {
        private static final Disabling m_inst = new Disabling();

        private Disabling() {
            super("Disabling", 1024);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class Deactivating
    extends State {
        private static final Deactivating m_inst = new Deactivating();

        private Deactivating() {
            super("Deactivating", 128);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class FactoryInstance
    extends Satisfied {
        private static final FactoryInstance m_inst = new FactoryInstance();

        private FactoryInstance() {
            super("Active", 16);
        }

        static State getInstance() {
            return m_inst;
        }

        void deactivate(AbstractComponentManager acm, int reason) {
            acm.changeState(Active.getInstance());
            acm.dispose(reason);
        }
    }

    protected static final class Factory
    extends Satisfied {
        private static final Factory m_inst = new Factory();

        private Factory() {
            super("Factory", 64);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class Registered
    extends Satisfied {
        private static final Registered m_inst = new Registered();

        private Registered() {
            super("Registered", 32);
        }

        static State getInstance() {
            return m_inst;
        }

        Object getService(DelayedComponentManager dcm) {
            if (dcm.createRealComponent()) {
                dcm.changeState(Active.getInstance());
                return dcm.getInstance();
            }
            try {
                dcm.deleteComponent(0);
            }
            catch (Throwable t) {
                dcm.log(4, "Cannot delete incomplete component instance. Ignoring.", t);
            }
            return null;
        }
    }

    protected static final class Active
    extends Satisfied {
        private static final Active m_inst = new Active();

        private Active() {
            super("Active", 16);
        }

        static State getInstance() {
            return m_inst;
        }

        Object getService(DelayedComponentManager dcm) {
            return dcm.getInstance();
        }

        void ungetService(DelayedComponentManager dcm) {
            dcm.deleteComponent(0);
            dcm.changeState(Registered.getInstance());
        }
    }

    protected static abstract class Satisfied
    extends State {
        protected Satisfied(String name, int state) {
            super(name, state);
        }

        ServiceReference getServiceReference(AbstractComponentManager acm) {
            ServiceRegistration sr = acm.getServiceRegistration();
            return sr == null ? null : sr.getReference();
        }

        void deactivate(AbstractComponentManager acm, int reason) {
            acm.changeState(Deactivating.getInstance());
            acm.log(4, "Deactivating component", null);
            try {
                acm.unregisterComponentService();
                acm.deleteComponent(reason);
            }
            catch (Throwable t) {
                acm.log(2, "Component deactivation threw an exception", t);
            }
            acm.changeState(Unsatisfied.getInstance());
            acm.log(4, "Component deactivated", null);
        }
    }

    protected static final class Activating
    extends State {
        private static final Activating m_inst = new Activating();

        private Activating() {
            super("Activating", 8);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class Unsatisfied
    extends State {
        private static final Unsatisfied m_inst = new Unsatisfied();

        private Unsatisfied() {
            super("Unsatisfied", 4);
        }

        static State getInstance() {
            return m_inst;
        }

        void activate(AbstractComponentManager acm) {
            acm.changeState(Activating.getInstance());
            acm.log(4, "Activating component", null);
            if (!acm.hasConfiguration() && acm.getComponentMetadata().isConfigurationRequired()) {
                acm.log(3, "Missing required configuration, cannot activate", null);
                acm.changeState(Unsatisfied.getInstance());
                return;
            }
            if (!acm.verifyDependencyManagers(acm.getProperties())) {
                acm.log(3, "Not all dependencies satisified, cannot activate", null);
                acm.changeState(Unsatisfied.getInstance());
                return;
            }
            if (!acm.hasServiceRegistrationPermissions()) {
                acm.log(3, "Component is not permitted to register all services, cannot activate", null);
                acm.changeState(Unsatisfied.getInstance());
                return;
            }
            if (!acm.createComponent()) {
                acm.log(1, "Component instance could not be created, activation failed", null);
                acm.changeState(Unsatisfied.getInstance());
                return;
            }
            acm.changeState(acm.getSatisfiedState());
            acm.registerComponentService();
        }

        void disable(AbstractComponentManager acm) {
            acm.changeState(Disabling.getInstance());
            acm.log(4, "Disabling component", null);
            acm.disableDependencyManagers();
            acm.changeState(Disabled.getInstance());
            acm.log(4, "Component disabled", null);
        }
    }

    protected static final class Enabling
    extends State {
        private static final Enabling m_inst = new Enabling();

        private Enabling() {
            super("Enabling", 512);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class Disabled
    extends State {
        private static final Disabled m_inst = new Disabled();

        private Disabled() {
            super("Disabled", 1);
        }

        static State getInstance() {
            return m_inst;
        }

        void enable(AbstractComponentManager acm) {
            acm.changeState(Enabling.getInstance());
            try {
                acm.enableDependencyManagers();
                acm.changeState(Unsatisfied.getInstance());
                acm.log(4, "Component enabled", null);
            }
            catch (InvalidSyntaxException ise) {
                acm.log(1, "Failed enabling Component", ise);
                acm.disableDependencyManagers();
                acm.changeState(Disabled.getInstance());
            }
        }

        void dispose(AbstractComponentManager acm) {
            acm.changeState(Disposing.getInstance());
            acm.log(4, "Disposing component", null);
            acm.clear();
            acm.changeState(Disposed.getInstance());
            acm.log(4, "Component disposed", null);
        }
    }

    protected static abstract class State {
        private final String m_name;
        private final int m_state;

        protected State(String name, int state) {
            this.m_name = name;
            this.m_state = state;
        }

        public String toString() {
            return this.m_name;
        }

        int getState() {
            return this.m_state;
        }

        ServiceReference getServiceReference(AbstractComponentManager acm) {
            return null;
        }

        Object getService(DelayedComponentManager dcm) {
            this.log(dcm, "getService");
            return null;
        }

        void ungetService(DelayedComponentManager dcm) {
            this.log(dcm, "ungetService");
        }

        void enable(AbstractComponentManager acm) {
            this.log(acm, "enable");
        }

        void activate(AbstractComponentManager acm) {
            this.log(acm, "activate");
        }

        void deactivate(AbstractComponentManager acm, int reason) {
            this.log(acm, "deactivate (reason: " + reason + ")");
        }

        void disable(AbstractComponentManager acm) {
            this.log(acm, "disable");
        }

        void dispose(AbstractComponentManager acm) {
            this.log(acm, "dispose");
        }

        private void log(AbstractComponentManager acm, String event) {
            acm.log(4, "Current state: {0}, Event: {1}", new Object[]{this.m_name, event}, null);
        }
    }
}

