/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ADBAwareHttpHandler;
import com.sun.enterprise.v3.services.impl.Endpoint;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.SnifferAdapter;
import java.io.CharConversionException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.grizzly.config.ContextRootInfo;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.internal.grizzly.ContextMapper;
import org.glassfish.kernel.KernelLoggerInfo;

public class ContainerMapper
extends ADBAwareHttpHandler {
    private static final Logger LOGGER = KernelLoggerInfo.getLogger();
    private static final String ROOT = "";
    private ContextMapper mapper;
    private final GrizzlyListener listener;
    private String defaultHostName = "server";
    private final GrizzlyService grizzlyService;
    protected static final Note<MappingData> MAPPING_DATA = Request.createNote((String)"MappingData");
    private static final Note<DataChunk> DATA_CHUNK = Request.createNote((String)"DataChunk");
    private final ReentrantReadWriteLock mapperLock;
    private static final AfterServiceListener afterServiceListener = new AfterServiceListenerImpl();
    private boolean mapMultipleAdapter;

    public ContainerMapper(GrizzlyService service, GrizzlyListener grizzlyListener) {
        this.listener = grizzlyListener;
        this.grizzlyService = service;
        this.mapperLock = service.obtainMapperLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultHost(String defaultHost) {
        this.mapperLock.writeLock().lock();
        try {
            this.defaultHostName = defaultHost;
        }
        finally {
            this.mapperLock.writeLock().unlock();
        }
    }

    protected void setMapper(ContextMapper mapper) {
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureMapper() {
        this.mapperLock.writeLock().lock();
        try {
            this.mapper.setDefaultHostName(this.defaultHostName);
            this.mapper.addHost(this.defaultHostName, new String[0], null);
            this.mapper.addContext(this.defaultHostName, ROOT, (Object)new ContextRootInfo((HttpHandler)this, null), new String[]{"index.html", "index.htm"}, null);
            Mapper.setAllowReplacement((boolean)true);
        }
        finally {
            this.mapperLock.writeLock().unlock();
        }
    }

    public void service(Request request, Response response) throws Exception {
        block5: {
            try {
                request.addAfterServiceListener(afterServiceListener);
                Callable handler = this.lookupHandler(request, response);
                handler.call();
            }
            catch (Exception ex) {
                try {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LogHelper.log(LOGGER, Level.WARNING, "NCLS-CORE-00090", ex, request.getRequest().getRequestURIRef().getDecodedRequestURIBC());
                    }
                    response.sendError(500);
                }
                catch (Exception ex2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                    LOGGER.log(Level.WARNING, "NCLS-CORE-00091", ex2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callable lookupHandler(Request request, Response response) throws CharConversionException, Exception {
        this.mapperLock.readLock().lock();
        try {
            Callable callable;
            HttpHandler httpHandler;
            if (!this.mapMultipleAdapter && (httpHandler = this.mapper.getHttpHandler()) != null) {
                request.setNote(MAPPING_DATA, null);
                HttpHandlerCallable httpHandlerCallable = new HttpHandlerCallable(httpHandler, request, response);
                return httpHandlerCallable;
            }
            DataChunk decodedURI = request.getRequest().getRequestURIRef().getDecodedRequestURIBC(this.isAllowEncodedSlash());
            MappingData mappingData = (MappingData)request.getNote(MAPPING_DATA);
            if (mappingData == null) {
                mappingData = new MappingData();
                request.setNote(MAPPING_DATA, (Object)mappingData);
            } else {
                mappingData.recycle();
            }
            CharChunk decodedURICC = decodedURI.getCharChunk();
            int semicolon = decodedURICC.indexOf(';', 0);
            HttpHandler httpHandler2 = this.mapUriWithSemicolon(request, decodedURI, semicolon, mappingData);
            if (httpHandler2 == null || httpHandler2 instanceof ContainerMapper) {
                String ext = decodedURI.toString();
                String type = ROOT;
                if (ext.lastIndexOf(".") > 0) {
                    ext = "*" + ext.substring(ext.lastIndexOf("."));
                    type = ext.substring(ext.lastIndexOf(".") + 1);
                }
                if (!MimeType.contains((String)type) && !"/".equals(ext)) {
                    this.initializeFileURLPattern(ext);
                    mappingData.recycle();
                    httpHandler2 = this.mapUriWithSemicolon(request, decodedURI, semicolon, mappingData);
                } else {
                    SuperCallable superCallable = new SuperCallable(request, response);
                    return superCallable;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request: {0} was mapped to Adapter: {1}", new Object[]{decodedURI.toString(), httpHandler2});
            }
            if (httpHandler2 == null || httpHandler2 instanceof ContainerMapper) {
                callable = new SuperCallable(request, response);
                return callable;
            }
            callable = new HttpHandlerCallable(httpHandler2, request, response);
            return callable;
        }
        finally {
            this.mapperLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFileURLPattern(String ext) {
        for (Sniffer sniffer : this.grizzlyService.getHabitat().getAllServices(Sniffer.class, new Annotation[0])) {
            boolean match = false;
            if (sniffer.getURLPatterns() == null) continue;
            for (String pattern : sniffer.getURLPatterns()) {
                if (!pattern.equalsIgnoreCase(ext)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            HttpHandler httpHandler = (HttpHandler)this.grizzlyService.getHabitat().getService(SnifferAdapter.class, new Annotation[0]);
            ((SnifferAdapter)httpHandler).initialize(sniffer, this);
            ContextRootInfo c = new ContextRootInfo(httpHandler, null);
            this.mapperLock.readLock().unlock();
            this.mapperLock.writeLock().lock();
            try {
                for (String pattern : sniffer.getURLPatterns()) {
                    for (String host : this.grizzlyService.hosts) {
                        this.mapper.addWrapper(host, ROOT, pattern, (Object)c, "*.jsp".equals(pattern) || "*.jspx".equals(pattern));
                    }
                }
            }
            finally {
                this.mapperLock.readLock().lock();
                this.mapperLock.writeLock().unlock();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HttpHandler mapUriWithSemicolon(Request req, DataChunk decodedURI, int semicolonPos, MappingData mappingData) throws Exception {
        this.mapperLock.readLock().lock();
        try {
            HttpHandler httpHandler;
            CharChunk charChunk = decodedURI.getCharChunk();
            int oldStart = charChunk.getStart();
            int oldEnd = charChunk.getEnd();
            if (semicolonPos == 0) {
                semicolonPos = decodedURI.indexOf(';', 0);
            }
            DataChunk localDecodedURI = decodedURI;
            if (semicolonPos >= 0) {
                charChunk.setEnd(semicolonPos);
                localDecodedURI = (DataChunk)req.getNote(DATA_CHUNK);
                if (localDecodedURI == null) {
                    localDecodedURI = DataChunk.newInstance();
                    req.setNote(DATA_CHUNK, (Object)localDecodedURI);
                }
                localDecodedURI.duplicate(decodedURI);
            }
            try {
                httpHandler = this.map(req, localDecodedURI, mappingData);
            }
            catch (Throwable throwable) {
                charChunk.setStart(oldStart);
                charChunk.setEnd(oldEnd);
                throw throwable;
            }
            charChunk.setStart(oldStart);
            charChunk.setEnd(oldEnd);
            return httpHandler;
        }
        finally {
            this.mapperLock.readLock().unlock();
        }
    }

    HttpHandler map(Request req, DataChunk decodedURI, MappingData mappingData) throws Exception {
        if (mappingData == null) {
            mappingData = (MappingData)req.getNote(MAPPING_DATA);
        }
        this.mapper.map(req.getRequest().serverName(), decodedURI, mappingData);
        ContainerMapper.updatePaths((Request)req, (MappingData)mappingData);
        if (mappingData.context != null && (mappingData.context instanceof ContextRootInfo || mappingData.wrapper instanceof ContextRootInfo)) {
            ContextRootInfo contextRootInfo = mappingData.wrapper != null ? (ContextRootInfo)mappingData.wrapper : (ContextRootInfo)mappingData.context;
            return contextRootInfo.getHttpHandler();
        }
        if (mappingData.context != null && "com.sun.enterprise.web.WebModule".equals(mappingData.context.getClass().getName())) {
            return this.mapper.getHttpHandler();
        }
        return null;
    }

    public void register(String contextRoot, Collection<String> vs, HttpHandler httpService, ApplicationContainer container) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER({0}) REGISTER contextRoot: {1} adapter: {2} container: {3} port: {4}", new Object[]{this, contextRoot, httpService, container, String.valueOf(this.listener.getPort())});
        }
        this.mapMultipleAdapter = true;
        ContextRootInfo c = new ContextRootInfo(httpService, (Object)container);
        for (String host : vs) {
            this.mapper.addContext(host, contextRoot, (Object)c, new String[0], null);
        }
    }

    public void unregister(String contextRoot) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER ({0}) UNREGISTER contextRoot: {1}", new Object[]{this, contextRoot});
        }
        for (String host : this.grizzlyService.hosts) {
            this.mapper.removeContext(host, contextRoot);
        }
    }

    public void register(final Endpoint endpoint) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "MAPPER({0}) REGISTER endpoint: {1}", endpoint);
        }
        this.mapMultipleAdapter = true;
        String contextRoot = endpoint.getContextRoot();
        Collection<String> vs = endpoint.getVirtualServers();
        ContextRootInfo c = new ContextRootInfo(new ContextRootInfo.Holder(){

            public HttpHandler getHttpHandler() {
                return endpoint.getEndpointHandler();
            }

            public Object getContainer() {
                return endpoint.getContainer();
            }
        });
        for (String host : vs) {
            this.mapper.addContext(host, contextRoot, (Object)c, new String[0], null);
        }
    }

    public void unregister(Endpoint endpoint) {
        this.unregister(endpoint.getContextRoot());
    }

    private static final class AfterServiceListenerImpl
    implements AfterServiceListener {
        private AfterServiceListenerImpl() {
        }

        public void onAfterService(Request request) {
            MappingData mappingData = (MappingData)request.getNote(MAPPING_DATA);
            if (mappingData != null) {
                mappingData.recycle();
            }
        }
    }

    private final class SuperCallable
    implements Callable {
        final Request req;
        final Response res;

        public SuperCallable(Request req, Response res) {
            this.req = req;
            this.res = res;
        }

        public Object call() throws Exception {
            ContainerMapper.super.service(this.req, this.res);
            return null;
        }
    }

    private static final class HttpHandlerCallable
    implements Callable {
        private final HttpHandler httpHandler;
        private final Request request;
        private final Response response;

        public HttpHandlerCallable(HttpHandler httpHandler, Request request, Response response) {
            this.httpHandler = httpHandler;
            this.request = request;
            this.response = response;
        }

        public Object call() throws Exception {
            this.httpHandler.service(this.request, this.response);
            return null;
        }
    }
}

