/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Path(value="/status/")
public class StatusGenerator
extends AbstractResource {
    protected StringBuilder status = new StringBuilder();
    private Set<String> commandsUsed = new TreeSet<String>();
    private Set<String> allCommands = new TreeSet<String>();
    private Set<String> restRedirectCommands = new TreeSet<String>();
    private Map<String, String> commandsToResources = new TreeMap<String, String>();
    private Map<String, String> resourcesToDeleteCommands = new TreeMap<String, String>();
    private Properties propsI18N = new SortedProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    public String getPlain() {
        try {
            Domain entity = (Domain)this.serviceLocator.getService(Domain.class, new Annotation[0]);
            Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            NOOPResourcesGenerator resourcesGenerator = new NOOPResourcesGenerator(this.serviceLocator);
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        this.status.append("\n------------------------");
        this.status.append("All Commands used in REST Admin:\n");
        for (String ss : this.commandsUsed) {
            this.status.append(ss + "\n");
        }
        this.listOfCommands();
        for (String ss : this.commandsUsed) {
            this.allCommands.remove(ss);
        }
        this.status.append("\n------------------------");
        this.status.append("Missing Commands not used in REST Admin:\n");
        for (String ss : this.allCommands) {
            if (this.hasTargetParam(ss).booleanValue()) {
                this.status.append(ss + "          has a target param " + "\n");
                continue;
            }
            this.status.append(ss + "\n");
        }
        this.status.append("\n------------------------");
        this.status.append("REST-REDIRECT Commands defined on ConfigBeans:\n");
        for (String ss : this.restRedirectCommands) {
            this.status.append(ss + "\n");
        }
        this.status.append("\n------------------------");
        this.status.append("Commands to Resources Mapping Usage in REST Admin:\n");
        for (String ss : this.commandsToResources.keySet()) {
            if (this.hasTargetParam(ss).booleanValue()) {
                this.status.append(ss + "   :::target:::   " + this.commandsToResources.get(ss) + "\n");
                continue;
            }
            this.status.append(ss + "      :::      " + this.commandsToResources.get(ss) + "\n");
        }
        this.status.append("\n------------------------");
        this.status.append("Resources with Delete Commands in REST Admin (not counting RESTREDIRECT:\n");
        for (String ss : this.resourcesToDeleteCommands.keySet()) {
            this.status.append(ss + "      :::      " + this.resourcesToDeleteCommands.get(ss) + "\n");
        }
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(System.getProperty("user.home") + "/GlassFishI18NData.properties");
            this.propsI18N.store(f, "");
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return this.status.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/html"})
    public String getHtml() {
        try {
            Domain entity = (Domain)this.serviceLocator.getService(Domain.class, new Annotation[0]);
            Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            NOOPResourcesGenerator resourcesGenerator = new NOOPResourcesGenerator(this.serviceLocator);
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        this.status.append("<h4>All Commands used in REST Admin</h4>\n<ul>\n");
        for (String ss : this.commandsUsed) {
            this.status.append("<li>").append(ss).append("</li>\n");
        }
        this.listOfCommands();
        for (String ss : this.commandsUsed) {
            this.allCommands.remove(ss);
        }
        this.status.append("</ul>\n<hr/>\n").append("<h4>Missing Commands not used in REST Admin</h4>\n<ul>\n");
        for (String ss : this.allCommands) {
            if (this.hasTargetParam(ss).booleanValue()) {
                this.status.append("<li>").append(ss).append("          has a target param.</li>\n");
                continue;
            }
            this.status.append("<li>").append(ss).append("</li>\n");
        }
        this.status.append("</ul>\n<hr/>\n").append("<h4>REST-REDIRECT Commands defined on ConfigBeans</h4>\n<ul>\n");
        for (String ss : this.restRedirectCommands) {
            this.status.append("<li>").append(ss).append("</li>\n");
        }
        this.status.append("</ul>\n<hr/>\n").append("<h4>Commands to Resources Mapping Usage in REST Admin</h4>\n").append("<table border=\"1\" style=\"border-collapse: collapse\">\n").append("<tr><th>Command</th><th>Target</th><th>Resource</th></tr>\n");
        for (String ss : this.commandsToResources.keySet()) {
            this.status.append("<tr><td>").append(ss).append("</td><td>").append(this.hasTargetParam(ss) != false ? "target" : "").append("</td><td>").append(this.commandsToResources.get(ss)).append("</td></tr>\n");
        }
        this.status.append("</table>\n<hr/>\n").append("<h4>Resources with Delete Commands in REST Admin (not counting RESTREDIRECT)</h4>\n").append("<table border=\"1\" style=\"border-collapse: collapse\">\n").append("<tr><th>Resource</th><th>Delete Command</th></tr>\n");
        for (String ss : this.resourcesToDeleteCommands.keySet()) {
            this.status.append("<tr><td>").append(ss).append("</td><td>").append(this.resourcesToDeleteCommands.get(ss)).append("</td></tr>\n");
        }
        this.status.append("</table>");
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(System.getProperty("user.home") + "/GlassFishI18NData.properties");
            this.propsI18N.store(f, "");
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    RestLogging.restLogger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return this.status.toString();
    }

    public void listOfCommands() {
        CommandRunner cr = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        RestActionReporter ar = new RestActionReporter();
        ParameterMap parameters = new ParameterMap();
        cr.getCommandInvocation("list-commands", (ActionReport)ar, this.getSubject()).parameters(parameters).execute();
        List children = ar.getTopMessagePart().getChildren();
        for (ActionReport.MessagePart part : children) {
            this.allCommands.add(part.getMessage());
        }
        ar = new RestActionReporter();
        parameters = new ParameterMap();
        parameters.add((Object)"DEFAULT", (Object)"_");
        cr.getCommandInvocation("list-commands", (ActionReport)ar, this.getSubject()).parameters(parameters).execute();
        children = ar.getTopMessagePart().getChildren();
        for (ActionReport.MessagePart part : children) {
            this.allCommands.add(part.getMessage());
        }
    }

    public Boolean hasTargetParam(String command) {
        try {
            if (command != null) {
                Collection<CommandModel.ParamModel> params = this.getParamMetaData(command);
                for (CommandModel.ParamModel paramModel : params) {
                    if (!paramModel.getName().equals("target")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            RestLogging.restLogger.log(Level.FINE, e.getMessage());
        }
        return false;
    }

    public Collection<CommandModel.ParamModel> getParamMetaData(String commandName) {
        CommandRunner cr = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        CommandModel cm = cr.getModel(commandName, RestLogging.restLogger);
        Collection params = cm.getParameters();
        return params;
    }

    class NOOPResourcesGenerator
    extends ResourcesGeneratorBase {
        public NOOPResourcesGenerator(ServiceLocator h) {
            super(h);
        }

        @Override
        public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
            return new NOOPClassWriter(className, baseClassName, resourcePath);
        }

        @Override
        public String endGeneration() {
            return "done";
        }

        @Override
        public void configModelVisited(ConfigModel model) {
            for (String a : model.getAttributeNames()) {
                String key = model.targetTypeName + "." + Util.eleminateHypen(a);
                StatusGenerator.this.propsI18N.setProperty(key + ".label", a);
                StatusGenerator.this.propsI18N.setProperty(key + ".help", a);
            }
            Class cbp = null;
            try {
                cbp = model.classLoaderHolder.loadClass(model.targetTypeName);
            }
            catch (MultiException e) {
                e.printStackTrace();
                return;
            }
            RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
            if (restRedirects != null) {
                RestRedirect[] values;
                for (RestRedirect r : values = restRedirects.value()) {
                    StatusGenerator.this.commandsUsed.add(r.commandName());
                    StatusGenerator.this.restRedirectCommands.add(r.commandName());
                }
            }
        }
    }

    class NOOPClassWriter
    implements ClassWriter {
        private String className;

        public NOOPClassWriter(String className, String baseClassName, String resourcePath) {
            this.className = className;
            if (baseClassName.equals("TemplateRestResource")) {
                StatusGenerator.this.resourcesToDeleteCommands.put(className, "");
            }
        }

        @Override
        public void createGetCommandResourcePaths(List<CommandResourceMetaData> commandMetaData) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                StatusGenerator.this.commandsUsed.add(metaData.command);
                if (StatusGenerator.this.commandsToResources.containsKey(metaData.command)) {
                    String val = (String)StatusGenerator.this.commandsToResources.get(metaData.command) + ", " + this.className;
                    StatusGenerator.this.commandsToResources.put(metaData.command, val);
                    continue;
                }
                StatusGenerator.this.commandsToResources.put(metaData.command, this.className);
            }
        }

        @Override
        public void createGetCommandResource(String commandResourceClassName, String resourcePath) {
        }

        @Override
        public void createCommandResourceConstructor(String commandResourceClassName, String commandName, String httpMethod, boolean linkedToParent, CommandResourceMetaData.ParameterMetaData[] commandParams, String commandDisplayName, String commandAction) {
        }

        @Override
        public void createCustomResourceMapping(String resourceClassName, String mappingPath) {
        }

        @Override
        public void done() {
        }

        @Override
        public void createGetDeleteCommand(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
            StatusGenerator.this.resourcesToDeleteCommands.put(this.className, commandName);
        }

        @Override
        public void createGetPostCommand(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetChildResource(String path, String childResourceClassName) {
        }

        @Override
        public void createGetChildResourceForListResources(String keyAttributeName, String childResourceClassName) {
        }

        @Override
        public void createGetPostCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetDeleteCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetDisplayNameForCollectionLeafResource(String displayName) {
        }
    }

    private static class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        @Override
        public Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<String> keyList = new Vector<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    }
}

