/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.producer.AbstractMemberProducer;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.reflection.Reflections;

public abstract class ProducerFieldProducer<X, T>
extends AbstractMemberProducer<X, T> {
    private final Field accessibleField;

    public ProducerFieldProducer(EnhancedAnnotatedField<T, ? super X> enhancedField, DisposalMethod<?, ?> disposalMethod) {
        super(enhancedField, disposalMethod);
        this.accessibleField = AccessController.doPrivileged(new GetAccessibleCopyOfMember<Field>(enhancedField.getJavaMember()));
        this.checkProducerField(enhancedField);
    }

    protected void checkProducerField(EnhancedAnnotatedField<T, ? super X> enhancedField) {
        if (this.getDeclaringBean() instanceof SessionBean && !enhancedField.isStatic()) {
            throw BeanLogger.LOG.producerFieldOnSessionBeanMustBeStatic(enhancedField, enhancedField.getDeclaringType());
        }
        if (enhancedField.isAnnotationPresent(Inject.class)) {
            if (this.getDeclaringBean() != null) {
                throw BeanLogger.LOG.injectedFieldCannotBeProducer(enhancedField, this.getDeclaringBean());
            }
            throw BeanLogger.LOG.injectedFieldCannotBeProducer(enhancedField, enhancedField.getDeclaringType());
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public abstract AnnotatedField<? super X> getAnnotated();

    @Override
    public T produce(Object receiver, CreationalContext<T> creationalContext) {
        if (receiver instanceof TargetInstanceProxy) {
            receiver = ((TargetInstanceProxy)Reflections.cast(receiver)).getTargetInstance();
        }
        try {
            return Reflections.cast(this.accessibleField.get(receiver));
        }
        catch (IllegalAccessException e) {
            throw UtilLogger.LOG.accessErrorOnField(this.accessibleField.getName(), this.accessibleField.getDeclaringClass(), e);
        }
    }

    @Override
    public String toString() {
        return this.getAnnotated().toString();
    }

    @Override
    protected DefinitionException producerCannotHaveWildcardBeanType(Object member) {
        return BeanLogger.LOG.producerFieldCannotHaveAWildcardBeanType(member);
    }

    @Override
    protected DefinitionException producerWithTypeVariableBeanTypeMustBeDependent(Object member) {
        return BeanLogger.LOG.producerFieldWithTypeVariableBeanTypeMustBeDependent(member);
    }
}

