/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.logging.annotation.LogMessageInfo;

public class SingleSignOn
extends ValveBase
implements SessionListener {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="Started", level="INFO")
    public static final String START_COMPONENT_INFO = "AS-WEB-CORE-00005";
    @LogMessageInfo(message="Stopped", level="INFO")
    public static final String STOP_COMPONENT_INFO = "AS-WEB-CORE-00006";
    @LogMessageInfo(message="Process session destroyed on {0}", level="INFO")
    public static final String PROCESS_SESSION_DESTROYED_INFO = "AS-WEB-CORE-00007";
    @LogMessageInfo(message="Process request for '{0}'", level="INFO")
    public static final String PROCESS_REQUEST_INFO = "AS-WEB-CORE-00008";
    @LogMessageInfo(message="Principal {0} has already been authenticated", level="INFO")
    public static final String PRINCIPAL_BEEN_AUTHENTICATED_INFO = "AS-WEB-CORE-00009";
    @LogMessageInfo(message="Checking for SSO cookie", level="INFO")
    public static final String CHECK_SSO_COOKIE_INFO = "AS-WEB-CORE-00010";
    @LogMessageInfo(message="SSO cookie is not present", level="INFO")
    public static final String SSO_COOKIE_NOT_PRESENT_INFO = "AS-WEB-CORE-00011";
    @LogMessageInfo(message="Checking for cached principal for {0}", level="INFO")
    public static final String CHECK_CACHED_PRINCIPAL_INFO = "AS-WEB-CORE-00012";
    @LogMessageInfo(message="Found cached principal {0} with auth type {1}", level="INFO")
    public static final String FOUND_CACHED_PRINCIPAL_AUTH_TYPE_INFO = "AS-WEB-CORE-00013";
    @LogMessageInfo(message="No cached principal found, erasing SSO cookie", level="INFO")
    public static final String NO_CACHED_PRINCIPAL_FOUND_INFO = "AS-WEB-CORE-00014";
    @LogMessageInfo(message="Associate sso id {0} with session {1}", level="INFO")
    public static final String ASSOCIATE_SSO_WITH_SESSION_INFO = "AS-WEB-CORE-00015";
    @LogMessageInfo(message="Registering sso id {0} for user {1} with auth type {2}", level="INFO")
    public static final String REGISTERING_SSO_INFO = "AS-WEB-CORE-00016";
    protected static final String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected Map<String, SingleSignOnEntry> cache = new HashMap<String, SingleSignOnEntry>();

    @Override
    public int getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        if (this.debug >= 1) {
            this.log(rb.getString(START_COMPONENT_INFO));
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log(rb.getString(STOP_COMPONENT_INFO));
        }
        super.stop();
    }

    @Override
    public void sessionEvent(SessionEvent event) {
        String ssoId;
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.debug >= 1) {
            String msg = MessageFormat.format(rb.getString(PROCESS_SESSION_DESTROYED_INFO), session);
            this.log(msg);
        }
        if ((ssoId = session.getSsoId()) == null) {
            return;
        }
        this.deregister(ssoId, session);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        String msg;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        request.removeNote("org.apache.catalina.request.SSOVersion");
        if (this.debug >= 1) {
            msg = MessageFormat.format(rb.getString(PROCESS_REQUEST_INFO), hreq.getRequestURI());
            this.log(msg);
        }
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                msg = MessageFormat.format(rb.getString(PRINCIPAL_BEEN_AUTHENTICATED_INFO), hreq.getUserPrincipal());
                this.log(msg);
            }
            return 2;
        }
        if (this.debug >= 1) {
            this.log(rb.getString(CHECK_SSO_COOKIE_INFO));
        }
        Cookie cookie = null;
        Cookie versionCookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if ("JSESSIONIDSSO".equals(cookies[i].getName())) {
                cookie = cookies[i];
            } else if ("JSESSIONIDSSOVERSION".equals(cookies[i].getName())) {
                versionCookie = cookies[i];
            }
            if (cookie != null && versionCookie != null) break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(rb.getString(SSO_COOKIE_NOT_PRESENT_INFO));
            }
            return 1;
        }
        if (this.debug >= 1) {
            String msg2 = MessageFormat.format(rb.getString(CHECK_CACHED_PRINCIPAL_INFO), cookie.getValue());
            this.log(msg2);
        }
        long version = 0L;
        if (this.isVersioningSupported() && versionCookie != null) {
            version = Long.parseLong(versionCookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue(), version)) != null) {
            if (this.debug >= 1) {
                String msg3 = MessageFormat.format(rb.getString(FOUND_CACHED_PRINCIPAL_AUTH_TYPE_INFO), entry.getPrincipal().getName(), entry.getAuthType());
                this.log(msg3);
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (this.isVersioningSupported()) {
                long ver = entry.incrementAndGetVersion();
                request.setNote("org.apache.catalina.request.SSOVersion", ver);
            }
            ((HttpRequest)request).setAuthType(entry.getAuthType());
            ((HttpRequest)request).setUserPrincipal(entry.getPrincipal());
        } else {
            if (this.debug >= 1) {
                this.log(rb.getString(NO_CACHED_PRINCIPAL_FOUND_INFO));
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
        }
        return 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void associate(String ssoId, long ssoVersion, Session session) {
        SingleSignOnEntry sso;
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log(rb.getString(ASSOCIATE_SSO_WITH_SESSION_INFO));
        }
        if ((sso = this.lookup(ssoId, ssoVersion)) != null) {
            session.setSsoId(ssoId);
            session.setSsoVersion(ssoVersion);
            sso.addSession(this, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso == null) {
            return;
        }
        session.setSsoId(null);
        session.setSsoVersion(0L);
        sso.removeSession(session);
        if (sso.isEmpty()) {
            Map<String, SingleSignOnEntry> map = this.cache;
            synchronized (map) {
                this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, char[] password, String realmName) {
        if (this.debug >= 1) {
            String msg = MessageFormat.format(rb.getString(REGISTERING_SSO_INFO), ssoId, principal.getName(), authType);
            this.log(msg);
        }
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(ssoId, 0L, principal, authType, username, realmName));
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.toString() + ": " + message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            return this.cache.get(ssoId);
        }
    }

    protected SingleSignOnEntry lookup(String ssoId, long ssoVersion) {
        return this.lookup(ssoId);
    }

    public boolean isVersioningSupported() {
        return false;
    }
}

