/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Service;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.CoyoteServerSocketFactory;
import org.apache.catalina.connector.ProtocolHandler;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.util.IntrospectionUtils;

public class Connector
implements org.apache.catalina.Connector,
Lifecycle {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="The connector has already been initialized", level="INFO")
    public static final String CONNECTOR_BEEN_INIT = "AS-WEB-CORE-00028";
    @LogMessageInfo(message="Error registering connector ", level="SEVERE", cause="Could not register connector", action="Verify domain name and type")
    public static final String ERROR_REGISTER_CONNECTOR_EXCEPTION = "AS-WEB-CORE-00029";
    @LogMessageInfo(message="Failed to instanciate HttpHandler ", level="WARNING")
    public static final String FAILED_INSTANCIATE_HTTP_HANDLER_EXCEPTION = "AS-WEB-CORE-00030";
    @LogMessageInfo(message="mod_jk invalid Adapter implementation: {0} ", level="WARNING")
    public static final String INVALID_ADAPTER_IMPLEMENTATION_EXCEPTION = "AS-WEB-CORE-00031";
    @LogMessageInfo(message="Protocol handler instantiation failed: {0}", level="WARNING")
    public static final String PROTOCOL_HANDLER_INIT_FAILED_EXCEPTION = "AS-WEB-CORE-00032";
    @LogMessageInfo(message="The connector has already been started", level="INFO")
    public static final String CONNECTOR_BEEN_STARTED = "AS-WEB-CORE-00033";
    @LogMessageInfo(message="Protocol handler start failed: {0}", level="WARNING")
    public static final String PROTOCOL_HANDLER_START_FAILED_EXCEPTION = "AS-WEB-CORE-00034";
    @LogMessageInfo(message="Coyote connector has not been started", level="SEVERE", cause="Could not stop processing requests via this Connector", action="Verify if the connector has not been started")
    public static final String CONNECTOR_NOT_BEEN_STARTED = "AS-WEB-CORE-00035";
    @LogMessageInfo(message="Protocol handler destroy failed: {0}", level="WARNING")
    public static final String PROTOCOL_HANDLER_DESTROY_FAILED_EXCEPTION = "AS-WEB-CORE-00036";
    private String defaultClassName = "org.apache.catalina.connector.CoyoteAdapter";
    private Map<String, String> properties = new HashMap<String, String>();
    private Service service = null;
    private int acceptCount = 10;
    private String address = null;
    private boolean allowTrace = true;
    private int bufferSize = 4096;
    protected Container container = null;
    private String compression = "off";
    private int debug = 0;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private int maxHttpHeaderSize = 4096;
    private boolean xpoweredBy;
    private static final String info = "org.apache.catalina.connector.Connector/2.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int connectionLinger = -1;
    private int connectionTimeout = 60000;
    private int connectionUploadTimeout = 300000;
    private int serverSocketTimeout = 0;
    private int port = 8080;
    private String proxyName = null;
    private int proxyPort = 0;
    private int redirectPort = 443;
    private String defaultHost;
    private String scheme = "http";
    private boolean secure = false;
    private boolean blocking = false;
    private boolean tomcatAuthentication = true;
    private boolean disableUploadTimeout = true;
    private int maxKeepAliveRequests = 100;
    private int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected boolean initialized = false;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private boolean tcpNoDelay = true;
    private String protocolHandlerClassName = "com.sun.enterprise.web.connector.grizzly.CoyoteConnectorLauncher";
    private ProtocolHandler protocolHandler = null;
    private String instanceName;
    private String name;
    private HttpHandler handler = null;
    protected Mapper mapper;
    private String uriEncoding = "UTF-8";
    private boolean enabled = true;
    protected boolean authPassthroughEnabled = false;
    protected ProxyHandler proxyHandler = null;
    private String selectorThreadImpl = null;
    private String jvmRoute;
    protected String domain;
    protected ObjectName oname;
    ObjectName controller;

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
        this.setProperty("compression", compression);
    }

    public int getConnectionLinger() {
        return this.connectionLinger;
    }

    public void setConnectionLinger(int connectionLinger) {
        this.connectionLinger = connectionLinger;
        this.setProperty("soLinger", String.valueOf(connectionLinger));
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.setProperty("soTimeout", String.valueOf(connectionTimeout));
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int connectionUploadTimeout) {
        this.connectionUploadTimeout = connectionUploadTimeout;
        this.setProperty("timeout", String.valueOf(connectionUploadTimeout));
    }

    public int getServerSocketTimeout() {
        return this.serverSocketTimeout;
    }

    public void setServerSocketTimeout(int serverSocketTimeout) {
        this.serverSocketTimeout = serverSocketTimeout;
        this.setProperty("serverSoTimeout", String.valueOf(serverSocketTimeout));
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
        this.setProperty("backlog", String.valueOf(count));
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.setProperty("address", address);
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
        this.setProperty("allowTrace", String.valueOf(allowTrace));
    }

    public boolean isAvailable() {
        return this.started;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.setProperty("bufferSize", String.valueOf(bufferSize));
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    @Override
    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
        this.setProperty("enableLookups", String.valueOf(enableLookups));
    }

    @Override
    public ServerSocketFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
        this.setProperty("minThreads", String.valueOf(minProcessors));
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
        this.setProperty("maxThreads", String.valueOf(maxProcessors));
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    @Override
    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
        this.setProperty("maxPostSize", String.valueOf(maxPostSize));
    }

    @Override
    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
        this.setProperty("maxSavePostSize", String.valueOf(maxSavePostSize));
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.setProperty("port", String.valueOf(port));
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getProtocol() {
        if ("org.glassfish.grizzly.tcp.http11.Http11Protocol".equals(this.getProtocolHandlerClassName())) {
            return "HTTP/1.1";
        }
        if ("org.apache.jk.server.JkCoyoteHandler".equals(this.getProtocolHandlerClassName())) {
            return "AJP/1.3";
        }
        return null;
    }

    public void setProtocol(String protocol) {
        if (protocol.equals("HTTP/1.1")) {
            this.setProtocolHandlerClassName("org.glassfish.grizzly.tcp.http11.Http11Protocol");
        } else if (protocol.equals("AJP/1.3")) {
            this.setProtocolHandlerClassName("org.apache.jk.server.JkCoyoteHandler");
        } else {
            this.setProtocolHandlerClassName(null);
        }
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        if (proxyName != null && proxyName.length() > 0) {
            this.proxyName = proxyName;
            this.setProperty("proxyName", proxyName);
        } else {
            this.proxyName = null;
            this.removeProperty("proxyName");
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setProperty("proxyPort", String.valueOf(proxyPort));
    }

    @Override
    public int getRedirectPort() {
        return this.redirectPort;
    }

    @Override
    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
        this.setProperty("redirectPort", String.valueOf(redirectPort));
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
        this.setProperty("disableUploadTimeout", String.valueOf(isDisabled));
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int size) {
        this.maxHttpHeaderSize = size;
        this.setProperty("maxHttpHeaderSize", String.valueOf(size));
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
        this.setProperty("maxKeepAliveRequests", String.valueOf(mkar));
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String scheme) {
        this.scheme = scheme;
        this.setProperty("scheme", scheme);
    }

    @Override
    public boolean getSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
        this.setProperty("secure", String.valueOf(secure));
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
        this.setProperty("blocking", String.valueOf(blocking));
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
        this.setProperty("tomcatAuthentication", String.valueOf(tomcatAuthentication));
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        this.setProperty("tcpNoDelay", String.valueOf(tcpNoDelay));
    }

    @Override
    public String getURIEncoding() {
        return this.uriEncoding;
    }

    @Override
    public void setURIEncoding(String uriEncoding) {
        if (Charset.isSupported(uriEncoding)) {
            this.uriEncoding = uriEncoding;
            this.setProperty("uRIEncoding", uriEncoding);
        } else if (log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, uriEncoding + "is not supported .Setting default URLEncoding as " + this.uriEncoding);
        }
    }

    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
        this.setProperty("xpoweredBy", String.valueOf(xpoweredBy));
    }

    @Override
    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public boolean getAuthPassthroughEnabled() {
        return this.authPassthroughEnabled;
    }

    @Override
    public void setAuthPassthroughEnabled(boolean authPassthroughEnabled) {
        this.authPassthroughEnabled = authPassthroughEnabled;
    }

    @Override
    public ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    @Override
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRoute;
    }

    @Override
    public Request createRequest() {
        org.apache.catalina.connector.Request request = new org.apache.catalina.connector.Request();
        request.setConnector(this);
        return request;
    }

    @Override
    public org.apache.catalina.Response createResponse() {
        Response response = new Response();
        response.setConnector(this);
        return response;
    }

    public void requestStartEvent(HttpServletRequest request, Host host, Context context) {
    }

    public void requestEndEvent(HttpServletRequest request, Host host, Context context, int statusCode) {
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected ObjectName createObjectName(String domain, String type) throws MalformedObjectNameException {
        String encodedAddr = null;
        if (this.getAddress() != null) {
            encodedAddr = URLEncoder.encode(this.getProperty("address"));
        }
        String addSuffix = this.getAddress() == null ? "" : ",address=" + encodedAddr;
        ObjectName _oname = new ObjectName(domain + ":type=" + type + ",port=" + this.getPort() + addSuffix);
        return _oname;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize() throws LifecycleException {
        Constructor<?> constructor;
        Class<?> clazz;
        if (this.initialized) {
            if (!log.isLoggable(Level.INFO)) return;
            log.log(Level.INFO, CONNECTOR_BEEN_INIT);
            return;
        }
        this.initialized = true;
        if (this.mapper == null) {
            this.mapper = new Mapper();
        }
        if (this.oname == null && this.container instanceof StandardEngine) {
            try {
                StandardEngine cb = (StandardEngine)this.container;
                this.controller = this.oname = this.createObjectName(this.domain, "Connector");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, ERROR_REGISTER_CONNECTOR_EXCEPTION, e);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Creating name for connector " + this.oname);
            }
        }
        if (this.handler == null) {
            try {
                clazz = Class.forName(this.defaultClassName);
                constructor = clazz.getConstructor(Connector.class);
                this.handler = (HttpHandler)constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new LifecycleException(rb.getString(FAILED_INSTANCIATE_HTTP_HANDLER_EXCEPTION), e);
            }
        }
        if (this.protocolHandler == null) {
            String msg;
            try {
                clazz = Class.forName(this.protocolHandlerClassName);
                if (this.protocolHandlerClassName.equals("org.apache.jk.server.JkCoyoteHandler")) {
                    this.protocolHandler = (ProtocolHandler)clazz.newInstance();
                    if (!(this.handler instanceof CoyoteAdapter)) {
                        msg = MessageFormat.format(rb.getString(INVALID_ADAPTER_IMPLEMENTATION_EXCEPTION), this.handler);
                        throw new IllegalStateException(msg);
                    }
                    ((CoyoteAdapter)this.handler).setCompatWithTomcat(true);
                } else {
                    constructor = clazz.getConstructor(Boolean.TYPE, Boolean.TYPE, String.class);
                    this.protocolHandler = (ProtocolHandler)constructor.newInstance(this.secure, this.blocking, this.selectorThreadImpl);
                }
            }
            catch (Exception e) {
                msg = MessageFormat.format(rb.getString(PROTOCOL_HANDLER_INIT_FAILED_EXCEPTION), e);
                throw new LifecycleException(msg);
            }
        }
        this.protocolHandler.setHandler(this.handler);
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"jkHome", (String)System.getProperty("catalina.base"));
        if (this.factory instanceof CoyoteServerSocketFactory) {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"secure", (String)"true");
            CoyoteServerSocketFactory ssf = (CoyoteServerSocketFactory)this.factory;
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"algorithm", (String)ssf.getAlgorithm());
            if (ssf.getClientAuth()) {
                IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"clientauth", (String)("" + ssf.getClientAuth()));
            }
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keystore", (String)ssf.getKeystoreFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"randomfile", (String)ssf.getRandomFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"rootfile", (String)ssf.getRootFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keypass", (String)ssf.getKeystorePass());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keytype", (String)ssf.getKeystoreType());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"protocol", (String)ssf.getProtocol());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"protocols", (String)ssf.getProtocols());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"sSLImplementation", (String)ssf.getSSLImplementation());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"ciphers", (String)ssf.getCiphers());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keyAlias", (String)ssf.getKeyAlias());
        } else {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"secure", (String)("" + this.secure));
        }
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name);
            String trnName = this.translateAttributeName(name);
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)trnName, (String)value);
        }
        try {
            this.protocolHandler.init();
            return;
        }
        catch (Exception e) {
            String msg = MessageFormat.format(rb.getString(PROTOCOL_HANDLER_INIT_FAILED_EXCEPTION), e);
            throw new LifecycleException(msg);
        }
    }

    private String translateAttributeName(String name) {
        if ("clientAuth".equals(name)) {
            return "clientauth";
        }
        if ("keystoreFile".equals(name)) {
            return "keystore";
        }
        if ("randomFile".equals(name)) {
            return "randomfile";
        }
        if ("rootFile".equals(name)) {
            return "rootfile";
        }
        if ("keystorePass".equals(name)) {
            return "keypass";
        }
        if ("keystoreType".equals(name)) {
            return "keytype";
        }
        if ("sslProtocol".equals(name)) {
            return "protocol";
        }
        if ("sslProtocols".equals(name)) {
            return "protocols";
        }
        return name;
    }

    @Override
    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, CONNECTOR_BEEN_STARTED);
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            String msg = MessageFormat.format(rb.getString(PROTOCOL_HANDLER_START_FAILED_EXCEPTION), e);
            throw new LifecycleException(msg);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            log.log(Level.SEVERE, CONNECTOR_NOT_BEEN_STARTED);
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            String msg = MessageFormat.format(rb.getString(PROTOCOL_HANDLER_DESTROY_FAILED_EXCEPTION), e);
            throw new LifecycleException(msg);
        }
    }

    public boolean getClientAuth() {
        boolean ret = false;
        String prop = this.getProperty("clientauth");
        if (prop != null) {
            ret = Boolean.valueOf(prop);
        } else {
            ServerSocketFactory factory = this.getFactory();
            if (factory instanceof CoyoteServerSocketFactory) {
                ret = ((CoyoteServerSocketFactory)factory).getClientAuth();
            }
        }
        return ret;
    }

    public void setClientAuth(boolean clientAuth) {
        this.setProperty("clientauth", String.valueOf(clientAuth));
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setClientAuth(clientAuth);
        }
    }

    public String getKeystoreFile() {
        ServerSocketFactory factory;
        String ret = this.getProperty("keystore");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getKeystoreFile();
        }
        return ret;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.setProperty("keystore", keystoreFile);
        if (this.factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)this.factory).setKeystoreFile(keystoreFile);
        }
    }

    public String getKeystorePass() {
        String ret = this.getProperty("keypass");
        if (ret == null && this.factory instanceof CoyoteServerSocketFactory) {
            return ((CoyoteServerSocketFactory)this.factory).getKeystorePass();
        }
        return ret;
    }

    public void setKeystorePass(String keystorePass) {
        this.setProperty("keypass", keystorePass);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setKeystorePass(keystorePass);
        }
    }

    public String getCiphers() {
        ServerSocketFactory factory;
        String ret = this.getProperty("ciphers");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getCiphers();
        }
        return ret;
    }

    public void setCiphers(String ciphers) {
        this.setProperty("ciphers", ciphers);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setCiphers(ciphers);
        }
    }

    public void setSslSessionTimeout(String timeout) {
        this.setProperty("sslSessionTimeout", timeout);
    }

    public String getSslSessionTimeout() {
        return this.getProperty("sslSessionTimeout");
    }

    public void setSsl3SessionTimeout(String timeout) {
        this.setProperty("ssl3SessionTimeout", timeout);
    }

    public String getSsl3SessionTimeout() {
        return this.getProperty("ssl3SessionTimeout");
    }

    public void setSslSessionCacheSize(String cacheSize) {
        this.setProperty("sslSessionCacheSize", cacheSize);
    }

    public String getSslSessionCacheSize() {
        return this.getProperty("sslSessionCacheSize");
    }

    public String getKeyAlias() {
        ServerSocketFactory factory;
        String ret = this.getProperty("keyAlias");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getKeyAlias();
        }
        return ret;
    }

    public void setKeyAlias(String alias) {
        this.setProperty("keyAlias", alias);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setKeyAlias(alias);
        }
    }

    public String getSslProtocol() {
        ServerSocketFactory factory;
        String ret = this.getProperty("sslProtocol");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getProtocol();
        }
        return ret;
    }

    public void setSslProtocol(String sslProtocol) {
        this.setProperty("sslProtocol", sslProtocol);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setProtocol(sslProtocol);
        }
    }

    public String getSslProtocols() {
        ServerSocketFactory factory;
        String ret = this.getProperty("sslProtocols");
        if (ret == null && (factory = this.getFactory()) instanceof CoyoteServerSocketFactory) {
            ret = ((CoyoteServerSocketFactory)factory).getProtocols();
        }
        return ret;
    }

    public void setSslProtocols(String sslProtocols) {
        this.setProperty("sslProtocols", sslProtocols);
        ServerSocketFactory factory = this.getFactory();
        if (factory instanceof CoyoteServerSocketFactory) {
            ((CoyoteServerSocketFactory)factory).setProtocols(sslProtocols);
        }
    }

    @Override
    public X509Certificate[] getCertificates(Request request) {
        org.apache.catalina.connector.Request cRequest = null;
        if (!(request instanceof org.apache.catalina.connector.Request)) {
            return null;
        }
        cRequest = (org.apache.catalina.connector.Request)request;
        X509Certificate[] certs = (X509Certificate[])cRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            certs = (X509Certificate[])cRequest.getAttribute("org.apache.coyote.request.X509Certificate");
        }
        return certs;
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void init() throws Exception {
        if (this.getService() != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Already configured");
            }
            return;
        }
    }

    public void destroy() throws Exception {
        if (this.oname != null && this.controller == this.oname && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Unregister itself " + this.oname);
        }
        if (this.getService() == null) {
            return;
        }
        this.getService().removeConnector(this);
    }

    @Override
    public void setHandler(HttpHandler handler) {
        this.handler = handler;
    }

    @Override
    public HttpHandler getHandler() {
        return this.handler;
    }

    public void setProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public String getSelectorThreadImpl() {
        return this.selectorThreadImpl;
    }

    public void setSelectorThreadImpl(String selectorThreadImpl) {
        this.selectorThreadImpl = selectorThreadImpl;
    }
}

