/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.CoyoteWriter;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.RequestUtil;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.CookieUtils;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.UEncoder;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.util.HtmlEntityEncoder;

public class Response
implements HttpResponse,
HttpServletResponse {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message="Error during finishResponse", level="WARNING")
    public static final String ERROR_DURING_FINISH_RESPONSE = "AS-WEB-CORE-00075";
    @LogMessageInfo(message="getWriter() has already been called for this response", level="WARNING")
    public static final String GET_WRITER_BEEN_CALLED_EXCEPTION = "AS-WEB-CORE-00076";
    @LogMessageInfo(message="getOutputStream() has already been called for this response", level="WARNING")
    public static final String GET_OUTPUT_STREAM_BEEN_CALLED_EXCEPTION = "AS-WEB-CORE-00077";
    @LogMessageInfo(message="Cannot reset buffer after response has been committed", level="WARNING")
    public static final String CANNOT_RESET_BUFFER_EXCEPTION = "AS-WEB-CORE-00078";
    @LogMessageInfo(message="Cannot change buffer size after data has been written", level="WARNING")
    public static final String CANNOT_CHANGE_BUFFER_SIZE_EXCEPTION = "AS-WEB-CORE-00079";
    @LogMessageInfo(message="Cannot call sendError() after the response has been committed", level="WARNING")
    public static final String CANNOT_CALL_SEND_ERROR_EXCEPTION = "AS-WEB-CORE-00080";
    @LogMessageInfo(message="Cannot call sendRedirect() after the response has been committed", level="WARNING")
    public static final String CANNOT_CALL_SEND_REDIRECT_EXCEPTION = "AS-WEB-CORE-00081";
    private static boolean enforceScope = false;
    public static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String info = "org.apache.catalina.connector.Response/1.0";
    private String detailErrorMsg;
    protected SimpleDateFormat format = null;
    protected Context context = null;
    protected boolean upgrade = false;
    protected Connector connector;
    protected org.glassfish.grizzly.http.server.Response coyoteResponse;
    protected OutputBuffer outputBuffer;
    protected CoyoteOutputStream outputStream;
    protected CoyoteWriter writer;
    protected boolean appCommitted = false;
    protected boolean included = false;
    private boolean isCharacterEncodingSet = false;
    private boolean isContentTypeSet = false;
    protected boolean error = false;
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected UEncoder urlEncoder = new UEncoder();
    protected CharChunk redirectURLCC = new CharChunk();
    protected Request request = null;
    protected ResponseFacade facade = null;

    public Response() {
        this.outputBuffer = new OutputBuffer();
        this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        this.writer = this.createWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
    }

    public Response(boolean chunkingDisabled) {
        this.outputBuffer = new OutputBuffer();
        this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        this.writer = this.createWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
    }

    public static void setEnforceScope(boolean enforce) {
        enforceScope = enforce;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setCoyoteResponse(org.glassfish.grizzly.http.server.Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
        this.outputBuffer.setCoyoteResponse(this);
    }

    public org.glassfish.grizzly.http.server.Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    @Override
    public Context getContext() {
        return this.request.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void recycle() {
        if (this.request != null && this.request.isAsyncStarted()) {
            return;
        }
        this.context = null;
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.error = false;
        this.isContentTypeSet = false;
        this.isCharacterEncodingSet = false;
        this.detailErrorMsg = null;
        if (enforceScope) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else {
            this.writer.recycle();
        }
    }

    @Override
    public int getContentCount() {
        return this.outputBuffer.getContentWritten();
    }

    @Override
    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    @Override
    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isSuspended() || this.getContentLength() > 0 && this.getContentCount() >= this.getContentLength();
    }

    @Override
    public boolean getIncluded() {
        return this.included;
    }

    @Override
    public void setIncluded(boolean included) {
        this.included = included;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public org.apache.catalina.Request getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(org.apache.catalina.Request request) {
        if (request instanceof Request) {
            this.request = (Request)request;
        }
    }

    @Override
    public HttpServletResponse getResponse() {
        if (this.facade == null) {
            this.facade = new ResponseFacade(this);
        }
        return this.facade;
    }

    @Override
    public OutputStream getStream() {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public void setStream(OutputStream stream) {
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    @Override
    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    @Override
    public void setError() {
        this.error = true;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setDetailMessage(String message) {
        this.detailErrorMsg = message;
    }

    @Override
    public String getDetailMessage() {
        return this.detailErrorMsg;
    }

    @Override
    public ServletOutputStream createOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public void finishResponse() throws IOException {
        try {
            this.outputBuffer.close();
        }
        catch (IOException iOException) {
        }
        catch (Throwable t) {
            this.log(rb.getString(ERROR_DURING_FINISH_RESPONSE), t);
        }
    }

    @Override
    public int getContentLength() {
        return this.coyoteResponse.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.coyoteResponse.getContentType();
    }

    @Override
    public PrintWriter getReporter() throws IOException {
        if (this.outputBuffer.isNew()) {
            this.outputBuffer.checkConverter();
            if (this.writer == null) {
                this.writer = this.createWriter(this.outputBuffer);
            }
            return this.writer;
        }
        return null;
    }

    @Override
    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    @Override
    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    @Override
    public String getCharacterEncoding() {
        return this.coyoteResponse.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.coyoteResponse.setCharacterEncoding(charset);
        this.isCharacterEncodingSet = true;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(rb.getString(GET_WRITER_BEEN_CALLED_EXCEPTION));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public Locale getLocale() {
        return this.coyoteResponse.getLocale();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(rb.getString(GET_OUTPUT_STREAM_BEEN_CALLED_EXCEPTION));
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = this.createWriter(this.outputBuffer);
        }
        return this.writer;
    }

    @Override
    public boolean isCommitted() {
        return this.coyoteResponse.isCommitted();
    }

    @Override
    public void reset() {
        if (this.included) {
            return;
        }
        this.coyoteResponse.reset();
        this.outputBuffer.reset();
        this.coyoteResponse.resetBuffer(true);
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.isCharacterEncodingSet = false;
    }

    @Override
    public void resetBuffer() {
        this.resetBuffer(false);
    }

    @Override
    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException(rb.getString(CANNOT_RESET_BUFFER_EXCEPTION));
        }
        this.outputBuffer.reset();
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
            this.isCharacterEncodingSet = false;
        }
    }

    @Override
    public void setBufferSize(int size) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(rb.getString(CANNOT_CHANGE_BUFFER_SIZE_EXCEPTION));
        }
        this.outputBuffer.setBufferSize(size);
    }

    @Override
    public void setContentLength(int length) {
        this.setContentLengthLong(length);
    }

    @Override
    public void setContentLengthLong(long length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.coyoteResponse.setContentLengthLong(length);
    }

    @Override
    public void setContentType(String type) {
        int index;
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.coyoteResponse.setContentType(type);
        if (type != null && (index = type.indexOf(";")) != -1) {
            int len = type.length();
            ++index;
            while (index < len && Character.isWhitespace(type.charAt(index))) {
                ++index;
            }
            if (index + 7 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                this.isCharacterEncodingSet = true;
            }
        }
        this.isContentTypeSet = true;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
        CharsetMapper cm = this.getContext().getCharsetMapper();
        String charset = cm.getCharset(locale);
        if (charset != null) {
            this.coyoteResponse.setCharacterEncoding(charset);
        }
    }

    @Override
    public String getHeader(String name) {
        return this.coyoteResponse.getHeader(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String headerName : this.coyoteResponse.getResponse().getHeaders().names()) {
            result.add(headerName);
        }
        return result;
    }

    @Override
    public Collection<String> getHeaders(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (String headerValue : this.coyoteResponse.getResponse().getHeaders().values(name)) {
            result.add(headerValue);
        }
        return result;
    }

    @Override
    public String getMessage() {
        return this.coyoteResponse.getMessage();
    }

    @Override
    public int getStatus() {
        return this.coyoteResponse.getStatus();
    }

    @Override
    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        String cookieValue = this.getCookieString(cookie);
        this.addHeader("Set-Cookie", cookieValue);
    }

    @Override
    public void addSessionCookieInternal(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        String name = cookie.getName();
        String headername = "Set-Cookie";
        String startsWith = name + "=";
        String cookieString = this.getCookieString(cookie);
        boolean set = false;
        MimeHeaders headers = this.coyoteResponse.getResponse().getHeaders();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            if (!headers.getName(i).toString().equals("Set-Cookie") || !headers.getValue(i).toString().startsWith(startsWith)) continue;
            headers.getValue(i).setString(cookieString);
            set = true;
        }
        if (!set) {
            this.addHeader("Set-Cookie", cookieString);
        }
    }

    @Override
    public void addDateHeader(String name, long value) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null || name.length() == 0 || value == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.addHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.coyoteResponse.containsHeader(name);
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            String sessionVersion = null;
            Map<String, String> sessionVersions = this.request.getSessionVersionsRequestAttribute();
            if (sessionVersions != null) {
                sessionVersion = RequestUtil.createSessionVersionString(sessionVersions);
            }
            return this.toEncoded(url, this.request.getSessionInternal().getIdInternal(), sessionVersion);
        }
        return url;
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    @Override
    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            } else if (url.equals(absolute) && !this.hasPath(url)) {
                url = url + '/';
            }
            String sessionVersion = null;
            Map<String, String> sessionVersions = this.request.getSessionVersionsRequestAttribute();
            if (sessionVersions != null) {
                sessionVersion = RequestUtil.createSessionVersionString(sessionVersions);
            }
            return this.toEncoded(url, this.request.getSessionInternal().getIdInternal(), sessionVersion);
        }
        return url;
    }

    @Override
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Override
    public String encode(String url) {
        return this.urlEncoder.encodeURL(url);
    }

    @Override
    public void sendAcknowledgement() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.sendAcknowledgement();
    }

    @Override
    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(rb.getString(CANNOT_CALL_SEND_ERROR_EXCEPTION));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.getResponse().setHtmlEncodingCustomReasonPhrase(false);
        this.coyoteResponse.setDetailMessage(HtmlEntityEncoder.encodeXSS((String)message));
        this.resetBuffer();
        this.setSuspended(true);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location, true);
    }

    public void sendRedirect(String location, boolean isTemporary) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(rb.getString(CANNOT_CALL_SEND_REDIRECT_EXCEPTION));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.getContext().getAllowRelativeRedirect() ? location : this.toAbsolute(location);
            if (isTemporary) {
                this.setStatus(302);
            } else {
                this.setStatus(301);
            }
            this.setHeader("Location", absolute);
            this.setContentType("text/html");
            this.setLocale(Locale.getDefault());
            String href = HtmlEntityEncoder.encodeXSS((String)absolute);
            StringBuilder sb = new StringBuilder(150 + href.length());
            sb.append("<html>\r\n");
            sb.append("<head><title>Document moved</title></head>\r\n");
            sb.append("<body><h1>Document moved</h1>\r\n");
            sb.append("This document has moved <a href=\"");
            sb.append(href);
            sb.append("\">here</a>.<p>\r\n");
            sb.append("</body>\r\n");
            sb.append("</html>\r\n");
            try {
                this.getWriter().write(sb.toString());
            }
            catch (IllegalStateException ise1) {
                try {
                    this.getOutputStream().print(sb.toString());
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    @Override
    public void setDateHeader(String name, long value) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    @Override
    public void setHeader(String name, String value) {
        if (name == null || name.length() == 0 || value == null) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    @Override
    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    @Override
    public void setStatus(int status, String message) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.getResponse().setHtmlEncodingCustomReasonPhrase(false);
        this.coyoteResponse.setDetailMessage(HtmlEntityEncoder.encodeXSS((String)message));
    }

    protected boolean isEncodeable(final String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        final Request hreq = this.request;
        final Session session = hreq.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie() || this.getContext() != null && !this.getContext().isEnableURLRewriting()) {
            return false;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Response.this.doIsEncodeable(hreq, session, location);
                }
            });
        }
        return this.doIsEncodeable(hreq, session, location);
    }

    private boolean doIsEncodeable(Request hreq, Session session, String location) {
        String contextPath;
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        Context ctx = this.getContext();
        if (ctx != null && (contextPath = ctx.getPath()) != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            String sessionParamName = ctx.getSessionParameterName();
            if (file.contains(";" + sessionParamName + "=" + session.getIdInternal())) {
                return false;
            }
        }
        return true;
    }

    protected String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (location.startsWith("//")) {
            this.redirectURLCC.recycle();
            String scheme = this.getRedirectScheme();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append(':');
                this.redirectURLCC.append(location, 0, location.length());
                return this.redirectURLCC.toString();
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(location);
                iae.initCause(e);
                throw iae;
            }
        }
        if (leadingSlash || location.indexOf("://") == -1) {
            this.redirectURLCC.recycle();
            String scheme = this.getRedirectScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append("://", 0, 3);
                this.redirectURLCC.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    this.redirectURLCC.append(':');
                    String portS = port + "";
                    this.redirectURLCC.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    String encodedURI = null;
                    final String frelativePath = relativePath;
                    if (SecurityUtil.isPackageProtectionEnabled()) {
                        try {
                            encodedURI = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                                @Override
                                public String run() throws IOException {
                                    return Response.this.urlEncoder.encodeURL(frelativePath);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            IllegalArgumentException iae = new IllegalArgumentException(location);
                            iae.initCause(pae.getCause());
                            throw iae;
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath);
                    }
                    this.redirectURLCC.append(encodedURI, 0, encodedURI.length());
                    this.redirectURLCC.append('/');
                }
                this.redirectURLCC.append(location, 0, location.length());
                this.normalize(this.redirectURLCC);
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(location);
                iae.initCause(e);
                throw iae;
            }
            return this.redirectURLCC.toString();
        }
        return location;
    }

    private String getRedirectScheme() {
        ProxyHandler proxyHandler;
        String scheme = this.request.getScheme();
        if (this.getConnector() != null && this.getConnector().getAuthPassthroughEnabled() && (proxyHandler = this.getConnector().getProxyHandler()) != null && proxyHandler.getSSLKeysize((HttpServletRequest)this.request) > 0) {
            scheme = "https";
        }
        return scheme;
    }

    protected String toEncoded(String url, String sessionId) {
        return this.toEncoded(url, sessionId, null);
    }

    private String toEncoded(String url, String sessionId, String sessionVersion) {
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            String replicaLocation;
            Session session;
            String jrouteId;
            StandardContext ctx = (StandardContext)this.getContext();
            String sessionParamName = ctx != null ? ctx.getSessionParameterName() : "jsessionid";
            sb.append(";" + sessionParamName + "=");
            sb.append(sessionId);
            if (ctx != null && ctx.getJvmRoute() != null) {
                sb.append('.').append(ctx.getJvmRoute());
            }
            if ((jrouteId = this.request.getHeader("proxy-jroute")) != null) {
                sb.append(":");
                sb.append(jrouteId);
            }
            if ((session = this.request.getSessionInternal(false)) != null && (replicaLocation = (String)session.getNote("com.sun.enterprise.http.jreplicaLocation")) != null) {
                sb.append(";jreplica=");
                sb.append(replicaLocation);
            }
            if (sessionVersion != null) {
                sb.append(";jsessionidversion=");
                sb.append(sessionVersion);
            }
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    protected CoyoteWriter createWriter(OutputBuffer outbuf) {
        return new CoyoteWriter(outbuf);
    }

    protected String getCookieString(final Cookie cookie) {
        String cookieValue = null;
        final StringBuilder sb = new StringBuilder();
        final boolean versionOneStrictCompliance = CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE;
        final boolean alwaysAddExpires = CookieUtils.ALWAYS_ADD_EXPIRES;
        final boolean rfc6265Support = CookieUtils.RFC_6265_SUPPORT_ENABLED;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            cookieValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    CookieSerializerUtils.serializeServerCookie((StringBuilder)sb, (boolean)versionOneStrictCompliance, (boolean)rfc6265Support, (boolean)alwaysAddExpires, (String)cookie.getName(), (String)cookie.getValue(), (int)cookie.getVersion(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure(), (boolean)cookie.isHttpOnly());
                    return sb.toString();
                }
            });
        } else {
            CookieSerializerUtils.serializeServerCookie((StringBuilder)sb, (boolean)versionOneStrictCompliance, (boolean)rfc6265Support, (boolean)alwaysAddExpires, (String)cookie.getName(), (String)cookie.getValue(), (int)cookie.getVersion(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure(), (boolean)cookie.isHttpOnly());
            cookieValue = sb.toString();
        }
        return cookieValue;
    }

    public void removeSessionCookies() {
        String matchExpression = "^" + this.getContext().getSessionCookieName() + "=.*";
        this.coyoteResponse.getResponse().getHeaders().removeHeaderMatches("Set-Cookie", matchExpression);
        matchExpression = "^JSESSIONIDSSO=.*";
        this.coyoteResponse.getResponse().getHeaders().removeHeaderMatches("Set-Cookie", matchExpression);
    }

    private void normalize(CharChunk cc) {
        int truncate = cc.indexOf('?');
        if (truncate == -1) {
            truncate = cc.indexOf('#');
        }
        char[] truncateCC = null;
        if (truncate > -1) {
            truncateCC = Arrays.copyOfRange(cc.getBuffer(), cc.getStart() + truncate, cc.getEnd());
            cc.setEnd(cc.getStart() + truncate);
        }
        if (cc.endsWith("/.") || cc.endsWith("/..")) {
            try {
                cc.append('/');
            }
            catch (IOException e) {
                throw new IllegalArgumentException(cc.toString(), e);
            }
        }
        char[] c = cc.getChars();
        int start = cc.getStart();
        int end = cc.getEnd();
        int index = 0;
        int startIndex = 0;
        for (int i = 0; i < 3; ++i) {
            startIndex = cc.indexOf('/', startIndex + 1);
        }
        index = startIndex;
        while ((index = cc.indexOf("/./", 0, 3, index)) >= 0) {
            this.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            cc.setEnd(end -= 2);
        }
        index = startIndex;
        while ((index = cc.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == startIndex) {
                throw new IllegalArgumentException();
            }
            int index2 = -1;
            for (int pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            this.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            cc.setEnd(end);
            index = index2;
        }
        if (truncateCC != null) {
            try {
                cc.append(truncateCC, 0, truncateCC.length);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    private void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    private boolean hasPath(String uri) {
        int pos = uri.indexOf("://");
        if (pos < 0) {
            return false;
        }
        return (pos = uri.indexOf(47, pos + 3)) >= 0;
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.connector != null && this.connector.getContainer() != null) {
            logger = this.connector.getContainer().getLogger();
        }
        String localName = "Response";
        if (logger != null) {
            logger.log(localName + " " + message, t, 2);
        } else {
            log.log(Level.WARNING, localName + " " + message, t);
        }
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    void disableWriteHandler() {
        this.outputBuffer.disableWriteHandler();
    }
}

