/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt;

import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.impl.base.GMSThreadFactory;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.ClusterManager;
import com.sun.enterprise.mgmt.ClusterViewEvent;
import com.sun.enterprise.mgmt.ClusterViewEvents;
import com.sun.enterprise.mgmt.HealthMessage;
import com.sun.enterprise.mgmt.LWRMulticast;
import com.sun.enterprise.mgmt.MasterNode;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.MessageListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HealthMonitor
implements MessageListener,
Runnable {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private long timeout = 10000L;
    private long verifyTimeout = 10000L;
    private int maxMissedBeats = 3;
    private final Object threadLock = new Object();
    private final Object indoubtthreadLock = new Object();
    private final ConcurrentHashMap<PeerID, HealthMessage.Entry> cache = new ConcurrentHashMap();
    private MasterNode masterNode = null;
    private ClusterManager manager = null;
    private final PeerID localPeerID;
    private volatile boolean started = false;
    private volatile boolean stop = false;
    private ConcurrentHashMap<String, MsgSendStats> msgSendStats = new ConcurrentHashMap();
    private Thread healthMonitorThread = null;
    private Thread failureDetectorThread = null;
    private static final String NODEADV = "NAD";
    private InDoubtPeerDetector inDoubtPeerDetector;
    static final String[] states = new String[]{"starting", "started", "alive", "clusterstopping", "peerstopping", "stopped", "dead", "indoubt", "unknown", "ready", "aliveandready"};
    private static final short STARTING = 0;
    private static final short ALIVE = 2;
    public static final short CLUSTERSTOPPING = 3;
    public static final short PEERSTOPPING = 4;
    public static final short STOPPED = 5;
    public static final short DEAD = 6;
    private static final short INDOUBT = 7;
    private static final short UNKNOWN = 8;
    private static final short READY = 9;
    private static final short ALIVEANDREADY = 10;
    public static final String HEALTHM = "HM";
    private final Object cacheLock = new Object();
    private final Object verifierLock = new Object();
    public volatile boolean outstandingFailureToVerify = false;
    private static final String MEMBER_STATE_QUERY = "MEMBERSTATEQUERY";
    private static final String MEMBER_STATE_RESPONSE = "MEMBERSTATERESPONSE";
    private static final String WATCHDOG_NOTIFICATION = "WATCHDOG_NOTIFICATION";
    private volatile boolean readyStateComplete = false;
    private volatile boolean JoinedAndReadyReceived = false;
    private List<String> joinedAndReadyMembers = new LinkedList<String>();
    private Message aliveMsg = null;
    private Message aliveAndReadyMsg = null;
    AtomicLong hmSeqID = new AtomicLong();
    LWRMulticast mcast = null;
    int lwrTimeout = 6000;
    public static final long DEFAULT_MEMBERSTATE_TIMEOUT = 0L;
    private final long defaultThreshold;
    private ReentrantLock sendStopLock = new ReentrantLock(true);
    private static final String CONNECTION_REFUSED = "Connection refused";
    private long failureDetectionTCPTimeout;
    private int failureDetectionTCPPort;
    private final ThreadPoolExecutor isConnectedPool;
    private ConcurrentHashMap<PeerID, MemberStateResult> memberStateResults = new ConcurrentHashMap();

    public HealthMonitor(ClusterManager manager, long timeout, int maxMissedBeats, long verifyTimeout, long failureDetectionTCPTimeout, int failureDetectionTCPPort) {
        this.timeout = timeout;
        this.defaultThreshold = timeout * (long)maxMissedBeats;
        this.maxMissedBeats = maxMissedBeats;
        this.verifyTimeout = verifyTimeout;
        this.manager = manager;
        this.masterNode = manager.getMasterNode();
        this.localPeerID = manager.getPeerID();
        this.failureDetectionTCPTimeout = failureDetectionTCPTimeout;
        this.failureDetectionTCPPort = failureDetectionTCPPort;
        GMSThreadFactory isConnectedThreadFactory = new GMSThreadFactory("GMS-isConnected-Group-" + manager.getGroupName() + "-thread");
        this.isConnectedPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(3, isConnectedThreadFactory);
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config("HealthMonitor: heartBeatTimeout(ms)=" + timeout + " maxMissedBeats=" + maxMissedBeats + " failureDetectionTCPTimeout(ms)=" + failureDetectionTCPTimeout + " failureDetectionTCPPort=" + failureDetectionTCPPort);
        }
        try {
            this.mcast = new LWRMulticast(manager, this);
            this.mcast.setSoTimeout(this.lwrTimeout);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "mgmt.healthmonitor.lwrmulticastioexception", e.getLocalizedMessage());
        }
    }

    public long getIndoubtDuration() {
        return this.timeout * (long)this.maxMissedBeats;
    }

    void fine(String msg, Object[] obj) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, msg, obj);
        }
    }

    void fine(String msg) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, msg);
        }
    }

    private Message createHealthMessage(short state) {
        return this.createMessage(state, HEALTHM, this.manager.getSystemAdvertisement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message createMessage(short state, String tag, SystemAdvertisement adv) {
        MessageImpl msg = new MessageImpl(2);
        HealthMessage hm = new HealthMessage();
        hm.setSrcID(this.localPeerID);
        HealthMessage.Entry entry = new HealthMessage.Entry(adv, states[state], this.hmSeqID.incrementAndGet());
        hm.add(entry);
        msg.addMessageElement(tag, hm);
        this.fine("createMessage() => putting into cache " + entry.adv.getName() + " state is " + entry.state);
        Object object = this.cacheLock;
        synchronized (object) {
            this.cache.put(entry.id, entry);
        }
        return msg;
    }

    private Message createHealthMessageForOtherPeer(HealthMessage.Entry entry) {
        MessageImpl msg = new MessageImpl(2);
        HealthMessage hm = new HealthMessage();
        hm.setSrcID(this.localPeerID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "create health message state: " + entry.state + " for member: " + entry.adv.getName() + " Master member reporting for peer is " + this.manager.getInstanceName() + " for group: " + this.manager.getGroupName());
        }
        hm.add(entry);
        msg.addMessageElement(HEALTHM, hm);
        return msg;
    }

    private Message getAliveMessage() {
        if (this.aliveMsg == null) {
            this.aliveMsg = this.createHealthMessage((short)2);
        }
        return this.aliveMsg;
    }

    private Message getAliveAndReadyMessage() {
        if (this.aliveAndReadyMsg == null) {
            this.aliveAndReadyMsg = this.createHealthMessage((short)10);
        }
        return this.aliveAndReadyMsg;
    }

    @Override
    public void receiveMessageEvent(MessageEvent event) throws MessageIOException {
        if (this.manager.isStopping()) {
            return;
        }
        if (this.started) {
            try {
                Message msg = event.getMessage();
                if (msg != null) {
                    for (Map.Entry<String, Serializable> entry : msg.getMessageElements()) {
                        if (entry.getKey().equals(HEALTHM)) {
                            Serializable value = entry.getValue();
                            if (value instanceof HealthMessage) {
                                HealthMessage hm = (HealthMessage)value;
                                this.updateHealthMessage(hm);
                                this.masterNode.processForLatestMasterViewId(msg, hm.getSrcID());
                                this.process(hm);
                                continue;
                            }
                            LOG.log(Level.WARNING, "mgmt.unknownMessage");
                            continue;
                        }
                        if (entry.getKey().equals(MEMBER_STATE_QUERY)) {
                            this.processMemberStateQuery(msg);
                            continue;
                        }
                        if (entry.getKey().equals(MEMBER_STATE_RESPONSE)) {
                            this.processMemberStateResponse(msg);
                            continue;
                        }
                        if (!entry.getKey().equals(WATCHDOG_NOTIFICATION)) continue;
                        this.processWatchDogNotification(msg);
                    }
                }
            }
            catch (Throwable e) {
                if (LOG.isLoggable(Level.FINE)) {
                    e.printStackTrace();
                }
                LOG.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    private SystemAdvertisement getNodeAdvertisement(Message msg) {
        SystemAdvertisement adv = null;
        Object value = msg.getMessageElement(NODEADV);
        if (value instanceof SystemAdvertisement && !(adv = (SystemAdvertisement)value).getID().equals(this.localPeerID) && LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Received a System advertisement Name :" + adv.getName());
        }
        return adv;
    }

    private void processMemberStateQuery(Message msg) {
        SystemAdvertisement adv = null;
        LOG.fine(" received a MemberStateQuery...");
        try {
            adv = this.getNodeAdvertisement(msg);
            if (adv != null) {
                boolean sent;
                PeerID sender = adv.getID();
                String state = this.getStateFromCache(this.localPeerID);
                Message response = this.createMemberStateResponse(state);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(" sending via LWR response to " + sender.toString() + " with state " + state + " for " + this.localPeerID);
                }
                if (!(sent = this.mcast.send(sender, response))) {
                    LOG.log(Level.WARNING, "mgmt.healthmonitor.processmemberstatequery", adv.getName());
                }
            } else {
                LOG.log(Level.WARNING, "mgmt.healthmonitor.invalidquery");
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "mgmt.healthmonitor.lwrmulticast.send.failed", e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMemberStateResponse(Message msg) {
        SystemAdvertisement adv;
        String memberState = null;
        Object value = msg.getMessageElement(MEMBER_STATE_RESPONSE);
        if (value != null) {
            memberState = value.toString();
        }
        if ((adv = this.getNodeAdvertisement(msg)) == null) {
            LOG.log(Level.WARNING, "mgmt.healthmonitor.nosenderadv");
            return;
        }
        MemberStateResult result = this.memberStateResults.get(adv.getID());
        if (result != null) {
            Object object = result.lock;
            synchronized (object) {
                result.memberState = memberState;
                this.memberStateResults.remove(adv.getID(), result);
                result.lock.notifyAll();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" member state in processMemberStateResponse() is " + memberState + " for member " + adv.getName());
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("memberStateResponse received too late. result already removed by timeout. response from " + adv.getName() + " state=" + memberState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWatchDogNotification(Message msg) {
        boolean masterFailed;
        SystemAdvertisement fromAdv = this.getNodeAdvertisement(msg);
        if (fromAdv == null) {
            LOG.fine("ignoring WATCHDOG_NOTIFICATION with a null sender advertisement");
            return;
        }
        GMSMember watchdogMember = Utility.getGMSMember(fromAdv);
        if (!watchdogMember.isWatchDog()) {
            LOG.fine("ignoring WATCHDOG_NOTIFICATION from member:" + watchdogMember.getMemberToken() + " of group " + watchdogMember.getGroupName() + " received one without a WATCHDOG member sender advertisement");
            return;
        }
        Object value = msg.getMessageElement(WATCHDOG_NOTIFICATION);
        if (!(value instanceof String)) {
            LOG.log(Level.WARNING, "mgmt.unknownMessage");
            return;
        }
        String failedTokenName = (String)value;
        PeerID failedMemberId = this.manager.getID(failedTokenName);
        boolean bl = masterFailed = failedMemberId == null ? false : failedMemberId.equals(this.masterNode.getMasterNodeID());
        if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned() || masterFailed) {
            LOG.log(Level.INFO, "mgmt.healthmonitor.watchdog", new Object[]{failedTokenName, failedMemberId, watchdogMember.getMemberToken(), masterFailed});
            ConcurrentHashMap<PeerID, HealthMessage.Entry> concurrentHashMap = this.cache;
            synchronized (concurrentHashMap) {
                HealthMessage.Entry failedEntry = this.cache.get(failedMemberId);
                if (failedEntry == null) {
                    LOG.info("ignoring WATCHDOG FAILURE NOTIFICATION: can not find member: " + failedTokenName + " of group: " + this.manager.getGroupName() + " with id:" + failedMemberId);
                    return;
                }
                if (failedEntry.isState(5) || failedEntry.isState(6) || failedEntry.isState(4) || failedEntry.isState(3) || failedEntry.isState(0)) {
                    String logMsg = MessageFormat.format("ignoring WATCHDOG FAILURE Notification for member: {0} of group: {1} with last heartbeat state of {2} at {3,time,full} on {3,date}.", failedTokenName, this.manager.getGroupName(), failedEntry.state, new Date(failedEntry.timestamp));
                    LOG.info(logMsg);
                    return;
                }
                if (failedEntry.isState(7)) {
                    LOG.info("received WATCHDOG failure notification for " + failedTokenName + " with local hm state=" + failedEntry.state);
                }
                LOG.info("validated FAILURE reported by WATCHDOG FAILURE notification for " + failedTokenName + " of group: " + this.manager.getGroupName() + " last heartbeat state:" + failedEntry.state + " received at " + MessageFormat.format(" {0,time,full} on {0,date}", new Date(failedEntry.timestamp)));
                this.assignAndReportFailure(failedEntry);
            }
        }
    }

    private Message createMemberStateQuery() {
        MessageImpl msg = new MessageImpl(2);
        msg.addMessageElement(NODEADV, this.manager.getSystemAdvertisement());
        msg.addMessageElement(MEMBER_STATE_QUERY, (Serializable)((Object)"member state query"));
        LOG.log(Level.FINE, "Created a Member State Query Message ");
        return msg;
    }

    private Message createMemberStateResponse(String myState) {
        MessageImpl msg = new MessageImpl(2);
        msg.addMessageElement(MEMBER_STATE_RESPONSE, (Serializable)((Object)myState));
        msg.addMessageElement(NODEADV, this.manager.getSystemAdvertisement());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Created a Member State Response Message with " + myState);
        }
        return msg;
    }

    private Message createWatchdogNotification(String failedServerToken) {
        MessageImpl msg = new MessageImpl(2);
        msg.addMessageElement(WATCHDOG_NOTIFICATION, (Serializable)((Object)failedServerToken));
        msg.addMessageElement(NODEADV, this.manager.getSystemAdvertisement());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Created a WATCHDOG Notification Message for member:" + failedServerToken + " of group:" + this.manager.getGroupName());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HealthMessage hm) {
        if (!hm.getSrcID().equals(this.localPeerID)) {
            for (HealthMessage.Entry entry : hm.getEntries()) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Processing Health Message " + entry.getSeqID() + " for entry " + entry.adv.getName() + " startTime=" + entry.getSrcStartTime() + " state=" + entry.state);
                }
                Object object = this.cacheLock;
                synchronized (object) {
                    HealthMessage.Entry cachedEntry = this.cache.get(entry.id);
                    if (cachedEntry != null) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINEST, "cached entry name=" + cachedEntry.adv.getName() + " startTime=" + cachedEntry.getSrcStartTime() + " seqId=" + cachedEntry.getSeqID() + " state=" + cachedEntry.state);
                        }
                        if (entry.isFromSameMember(cachedEntry) && entry.getSrcStartTime() < cachedEntry.getSrcStartTime()) {
                            LOG.fine("Discarding older health message from a previously failed run of member " + entry.adv.getName());
                            return;
                        }
                        if (cachedEntry.isFromSameMemberStartup(entry) && entry.getSeqID() < cachedEntry.getSeqID()) {
                            if (LOG.isLoggable(Level.FINER)) {
                                LOG.log(Level.FINER, MessageFormat.format("Received an older health message from source member {2} seqId={0}. Current cached health message seqId:{1}. ", entry.getSeqID(), cachedEntry.getSeqID(), entry.adv.getName()));
                            }
                            if (entry.state.equals(states[3]) || entry.state.equals(states[4])) {
                                LOG.log(Level.FINER, "Received an older health message with clusterstopping state. Calling handleStopEvent() to handle shutdown state.");
                                if (!cachedEntry.state.equals(states[5])) {
                                    this.cache.put(entry.id, entry);
                                }
                                this.handleStopEvent(entry);
                            } else if (entry.state.equals(states[9])) {
                                LOG.fine("Received an older health message with Joined and Ready state. Calling handleReadyEvent() for handling the peer's ready state");
                                this.handleReadyEvent(entry);
                            } else {
                                LOG.log(Level.FINER, "Discarding older health message");
                            }
                            return;
                        }
                    }
                    this.cache.put(entry.id, entry);
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINER, "Put into cache " + entry.adv.getName() + " state = " + entry.state + " peerid = " + entry.id + " seq id=" + entry.getSeqID());
                    }
                }
                if (!(this.manager.getClusterViewManager().containsKey(entry.id) || entry.state.equals(states[3]) || entry.state.equals(states[4]) || entry.state.equals(states[5]) || entry.state.equals(states[6]))) {
                    try {
                        this.masterNode.probeNode(entry);
                    }
                    catch (IOException e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            e.printStackTrace();
                        }
                        LOG.log(Level.FINE, "IOException occured while sending probeNode() Message in HealthMonitor:" + e.getLocalizedMessage());
                    }
                }
                if (entry.state.equals(states[9])) {
                    this.handleReadyEvent(entry);
                }
                if (entry.state.equals(states[4]) || entry.state.equals(states[3])) {
                    this.handleStopEvent(entry);
                }
                if (!entry.state.equals(states[7]) && !entry.state.equals(states[6])) continue;
                if (entry.id.equals(this.localPeerID)) {
                    if (this.readyStateComplete) {
                        this.reportMyState((short)10, hm.getSrcID());
                        continue;
                    }
                    this.reportMyState((short)2, hm.getSrcID());
                    continue;
                }
                if (entry.state.equals(states[7])) {
                    LOG.log(Level.FINE, "Peer " + entry.id.toString() + " is suspected failed. Its state is " + entry.state);
                    this.notifyLocalListeners(entry.state, entry.adv);
                }
                if (!entry.state.equals(states[6])) continue;
                LOG.log(Level.FINE, "Peer " + entry.id.toString() + " has failed. Its state is " + entry.state);
                this.cleanAllCaches(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReadyEvent(HealthMessage.Entry entry) {
        List<String> list = this.cacheLock;
        synchronized (list) {
            this.cache.put(entry.id, entry);
        }
        if (entry.id.equals(this.masterNode.getMasterNodeID())) {
            return;
        }
        if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned()) {
            list = this.joinedAndReadyMembers;
            synchronized (list) {
                if (!this.joinedAndReadyMembers.contains(entry.adv.getName())) {
                    this.joinedAndReadyMembers.add(entry.adv.getName());
                    LOG.log(Level.FINEST, MessageFormat.format("Handling Ready Event for peer :{0}", entry.adv.getName()));
                    ClusterViewEvent cvEvent = this.masterNode.sendReadyEventView(entry.adv);
                    this.manager.getClusterViewManager().notifyListeners(cvEvent);
                }
            }
        }
    }

    private void handleStopEvent(HealthMessage.Entry entry) {
        LOG.log(Level.FINEST, MessageFormat.format("Handling Stop Event for peer :{0}", entry.adv.getName()));
        short stateByte = 4;
        if (entry.state.equals(states[3])) {
            stateByte = 3;
        }
        if (entry.adv.getID().equals(this.masterNode.getMasterNodeID())) {
            LOG.log(Level.FINER, MessageFormat.format("Removing master node {0} from view as it has stopped.", entry.adv.getName()));
            this.removeMasterAdv(entry, stateByte);
            this.masterNode.resetMaster();
            this.masterNode.appointMasterNode();
        } else if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned()) {
            this.manager.getClusterViewManager().remove(entry.adv);
            LOG.log(Level.FINE, "Announcing Peer Stop Event of " + entry.adv.getName() + " to group ...");
            ClusterViewEvent cvEvent = stateByte == 3 ? new ClusterViewEvent(ClusterViewEvents.CLUSTER_STOP_EVENT, entry.adv) : new ClusterViewEvent(ClusterViewEvents.PEER_STOP_EVENT, entry.adv);
            this.masterNode.viewChanged(cvEvent);
        }
        this.cleanAllCaches(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAllCaches(HealthMessage.Entry entry) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("HealthMonitor.cleanAllCaches : removing pipes and route from cache..." + entry.id);
        }
        this.manager.getNetworkManager().removePeerID(entry.id);
        List<String> list = this.joinedAndReadyMembers;
        synchronized (list) {
            this.joinedAndReadyMembers.remove(entry.adv.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAllCaches(String memberToken) {
        HealthMessage.Entry entry = null;
        PeerID id = this.manager.getID(memberToken);
        Object object = this.cache;
        synchronized (object) {
            entry = this.cache.get(id);
        }
        if (entry != null) {
            this.cleanAllCaches(entry);
        } else {
            object = this.joinedAndReadyMembers;
            synchronized (object) {
                this.joinedAndReadyMembers.remove(memberToken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PeerID, HealthMessage.Entry> getCacheCopy() {
        ConcurrentHashMap<PeerID, HealthMessage.Entry> clone = new ConcurrentHashMap<PeerID, HealthMessage.Entry>();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<PeerID, HealthMessage.Entry> entry : this.cache.entrySet()) {
                try {
                    clone.put(entry.getKey(), (HealthMessage.Entry)entry.getValue().clone());
                }
                catch (CloneNotSupportedException e) {
                    LOG.fine("Exception occurred : " + e);
                }
            }
        }
        return clone;
    }

    private void print(ConcurrentHashMap<PeerID, HealthMessage.Entry> c) {
        for (HealthMessage.Entry e : c.values()) {
            this.fine("cache contents => " + e.adv.getName() + " state => " + e.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportMyState(short state, PeerID id) {
        block7: {
            String target;
            String reason;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, MessageFormat.format("Sending state {0} to {1}", states[state], id == null ? "group" : id));
            }
            boolean sent = true;
            IOException ioe = null;
            try {
                Message msg = null;
                msg = state == 2 ? this.getAliveMessage() : (state == 10 ? this.getAliveAndReadyMessage() : this.createHealthMessage(state));
                this.masterNode.addMasterViewSeqId(msg);
                sent = this.send(id, msg);
                if (sent) break block7;
                reason = "";
                MsgSendStats msgSendStats = this.getMsgSendStats(this.manager.getGroupName());
                if (!msgSendStats.reportSendFailed()) break block7;
                reason = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "sent returned false";
                target = id == null ? "group " + this.manager.getGroupName() : "member " + id;
            }
            catch (IOException e) {
                String target2;
                String reason2;
                try {
                    ioe = e;
                    sent = false;
                    if (sent) break block7;
                    reason2 = "";
                    MsgSendStats msgSendStats = this.getMsgSendStats(this.manager.getGroupName());
                    if (!msgSendStats.reportSendFailed()) break block7;
                    reason2 = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "sent returned false";
                    target2 = id == null ? "group " + this.manager.getGroupName() : "member " + id;
                }
                catch (Throwable throwable) {
                    if (!sent) {
                        String reason3 = "";
                        MsgSendStats msgSendStats = this.getMsgSendStats(this.manager.getGroupName());
                        if (msgSendStats.reportSendFailed()) {
                            reason3 = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "sent returned false";
                            String target3 = id == null ? "group " + this.manager.getGroupName() : "member " + id;
                            LOG.log(Level.WARNING, "mgmt.healthmonitor.reportstatefailed", new Object[]{states[state], target3, reason3});
                        }
                    }
                    throw throwable;
                }
                LOG.log(Level.WARNING, "mgmt.healthmonitor.reportstatefailed", new Object[]{states[state], target2, reason2});
            }
            LOG.log(Level.WARNING, "mgmt.healthmonitor.reportstatefailed", new Object[]{states[state], target, reason});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportOtherPeerState(HealthMessage.Entry entry) {
        block5: {
            String reason;
            Message msg = this.createHealthMessageForOtherPeer(entry);
            this.masterNode.addMasterViewSeqId(msg);
            LOG.log(Level.FINEST, MessageFormat.format("Reporting {0} health state as {1}", entry.adv.getName(), entry.state));
            boolean sent = false;
            IOException ioe = null;
            try {
                MsgSendStats msgSendStats;
                sent = this.send(null, msg);
                if (sent || !(msgSendStats = this.getMsgSendStats(this.manager.getGroupName())).reportSendFailed()) break block5;
                reason = "";
                reason = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "sent returned false";
            }
            catch (IOException e) {
                String reason2;
                try {
                    MsgSendStats msgSendStats;
                    ioe = e;
                    sent = false;
                    if (sent || !(msgSendStats = this.getMsgSendStats(this.manager.getGroupName())).reportSendFailed()) break block5;
                    reason2 = "";
                    reason2 = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "sent returned false";
                }
                catch (Throwable throwable) {
                    MsgSendStats msgSendStats;
                    if (!sent && (msgSendStats = this.getMsgSendStats(this.manager.getGroupName())).reportSendFailed()) {
                        String reason3 = "";
                        reason3 = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "sent returned false";
                        LOG.log(Level.WARNING, "mgmt.healthmonitor.reportotherstatefailed", new Object[]{entry.adv.getName(), entry.state, this.manager.getGroupName(), reason3});
                    }
                    throw throwable;
                }
                LOG.log(Level.WARNING, "mgmt.healthmonitor.reportotherstatefailed", new Object[]{entry.adv.getName(), entry.state, this.manager.getGroupName(), reason2});
            }
            LOG.log(Level.WARNING, "mgmt.healthmonitor.reportotherstatefailed", new Object[]{entry.adv.getName(), entry.state, this.manager.getGroupName(), reason});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object myAdv;
        this.reportMyState((short)0, null);
        if (LOG.isLoggable(Level.CONFIG)) {
            myAdv = this.manager.getSystemAdvertisement();
            GMSMember member = Utility.getGMSMember((SystemAdvertisement)myAdv);
            LOG.config("MySystemAdvertisement(summary): " + member.toString() + " ID:" + myAdv.getID().toString() + " TCP uri(s):" + myAdv.getURIs());
            LOG.config("MySystemAdvertisement(dump)=" + myAdv.toString());
        }
        while (!this.stop) {
            try {
                myAdv = this.threadLock;
                synchronized (myAdv) {
                    this.threadLock.wait(this.timeout);
                }
                if (this.stop) continue;
                if (this.readyStateComplete) {
                    short state = this.JoinedAndReadyReceived ? (short)10 : 9;
                    this.reportMyState(state, null);
                    continue;
                }
                this.reportMyState((short)2, null);
            }
            catch (InterruptedException e) {
                this.stop = true;
                break;
            }
            catch (Throwable all) {
                LOG.log(Level.WARNING, "mgmt.healthmonitor.threaduncaughtexception", new Object[]{Thread.currentThread().getName(), all});
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.log(Level.INFO, "stack trace", all);
            }
        }
    }

    private boolean send(PeerID peerid, Message msg) throws IOException {
        MsgSendStats msgSendStat = null;
        boolean sent = false;
        this.sendStopLock.lock();
        try {
            Object value = msg.getMessageElement(HEALTHM);
            if (value instanceof HealthMessage) {
                HealthMessage hm = (HealthMessage)value;
                for (HealthMessage.Entry healthEntry : hm.getEntries()) {
                    if (!this.stop || healthEntry.state.equals(states[3]) || healthEntry.state.equals(states[4]) || healthEntry.state.equals(states[5])) continue;
                    LOG.fine("HealthMonitor.send()=> not sending the message since HealthMonitor is trying to stop. state = " + healthEntry.state);
                    boolean bl = true;
                    return bl;
                }
            } else {
                LOG.log(Level.WARNING, "mgmt.unknownMessage");
            }
            if (peerid != null) {
                LOG.log(Level.FINER, "Unicasting Message to :" + peerid.toString());
                msgSendStat = this.getMsgSendStats(peerid.getInstanceName());
                sent = this.manager.getNetworkManager().send(peerid, msg);
                msgSendStat.sendSucceeded();
            } else {
                msgSendStat = this.getMsgSendStats(this.manager.getGroupName());
                sent = this.manager.getNetworkManager().broadcast(msg);
                msgSendStat.sendSucceeded();
            }
        }
        catch (IOException io) {
            msgSendStat.sendFailed();
            throw io;
        }
        finally {
            this.sendStopLock.unlock();
        }
        return sent;
    }

    void start() {
        if (!this.started) {
            LOG.log(Level.FINE, "Starting HealthMonitor");
            if (!this.isWatchDog()) {
                this.manager.getNetworkManager().addMessageListener(this);
                this.healthMonitorThread = new Thread((Runnable)this, "GMS HealthMonitor for Group-" + this.manager.getGroupName());
                this.healthMonitorThread.setDaemon(true);
                this.healthMonitorThread.start();
                this.inDoubtPeerDetector = new InDoubtPeerDetector();
                this.inDoubtPeerDetector.start();
            }
            this.started = true;
        }
    }

    void announceStop(boolean isClusterShutdown) {
        if (this.isWatchDog()) {
            return;
        }
        LOG.log(Level.FINE, MessageFormat.format("Announcing stop event to group with clusterShutdown set to {0}", isClusterShutdown));
        if (isClusterShutdown) {
            this.reportMyState((short)3, null);
        } else {
            this.reportMyState((short)4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean isClusterShutdown) {
        this.sendStopLock.lock();
        try {
            this.stop = true;
            this.started = false;
        }
        finally {
            this.sendStopLock.unlock();
        }
        this.announceStop(isClusterShutdown);
        this.reportMyState((short)5, null);
        if (this.isConnectedPool != null) {
            this.isConnectedPool.shutdownNow();
        }
        this.sendStopLock.lock();
        try {
            LOG.log(Level.FINE, "Stopping HealthMonitor");
            Thread tmpThread = this.healthMonitorThread;
            this.healthMonitorThread = null;
            if (tmpThread != null) {
                tmpThread.interrupt();
            }
            this.inDoubtPeerDetector.stop();
        }
        finally {
            this.sendStopLock.unlock();
        }
        this.manager.getNetworkManager().removeMessageListener(this);
    }

    private HealthMessage updateHealthMessage(HealthMessage hm) throws IOException {
        if (hm != null) {
            long currentTime = System.currentTimeMillis();
            for (HealthMessage.Entry entry : hm.getEntries()) {
                entry.timestamp = currentTime;
            }
        }
        return hm;
    }

    private void notifyLocalListeners(String state, SystemAdvertisement adv) {
        if (state.equals(states[7])) {
            this.manager.getClusterViewManager().setInDoubtPeerState(adv);
        } else if (state.equals(states[2])) {
            this.manager.getClusterViewManager().setPeerNoLongerInDoubtState(adv);
        } else if (state.equals(states[10])) {
            this.manager.getClusterViewManager().setPeerNoLongerInDoubtState(adv);
        } else if (state.equals(states[3])) {
            this.manager.getClusterViewManager().setClusterStoppingState(adv);
        } else if (state.equals(states[4])) {
            this.manager.getClusterViewManager().setPeerStoppingState(adv);
        } else if (state.equals(states[9])) {
            this.manager.getClusterViewManager().setPeerReadyState(adv);
        }
    }

    public String getMemberState(PeerID peerID, long threshold, long timeout) {
        String state;
        if (peerID == null) {
            throw new IllegalArgumentException("getMemberState parameter PeerID must be non-null");
        }
        if (peerID.equals(this.localPeerID)) {
            return this.getStateFromCache(peerID);
        }
        if (threshold > 0L && timeout <= 0L) {
            return this.getMemberStateFromHeartBeat(peerID, threshold);
        }
        if (threshold <= 0L && timeout > 0L) {
            return this.getMemberStateViaLWR(peerID, timeout);
        }
        if (timeout == 0L && threshold == 0L) {
            timeout = 0L;
            threshold = this.defaultThreshold;
        }
        if ((state = this.getMemberStateFromHeartBeat(peerID, threshold)).equals(states[8])) {
            return this.getMemberStateViaLWR(peerID, timeout);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMemberStateFromHeartBeat(PeerID peerID, long threshold) {
        HealthMessage.Entry entry;
        if (threshold <= 0L) {
            threshold = this.defaultThreshold;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            entry = this.cache.get(peerID);
        }
        if (entry != null) {
            if (System.currentTimeMillis() - entry.timestamp <= threshold) {
                return entry.state;
            }
            return states[8];
        }
        return states[8];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMemberStateViaLWR(PeerID peerID, long timeout) {
        Object prevResult;
        if (peerID.equals(this.localPeerID)) {
            return this.getStateFromCache(peerID);
        }
        if (timeout <= 0L) {
            return this.getStateFromCache(peerID);
        }
        if (!this.manager.getClusterViewManager().containsKey(peerID)) {
            return states[8];
        }
        Object result = this.memberStateResults.get(peerID);
        boolean sent = false;
        boolean ioe = false;
        if (result == null) {
            result = new MemberStateResult();
            prevResult = this.memberStateResults.putIfAbsent(peerID, (MemberStateResult)result);
            if (prevResult != null) {
                result = prevResult;
                sent = true;
            } else {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("getMemberStateViaLWR send query to " + peerID.toString());
                }
                Message msg = this.createMemberStateQuery();
                try {
                    sent = this.mcast.send(peerID, msg);
                }
                catch (IOException e) {
                    ioe = true;
                    LOG.log(Level.FINE, "Could not send the LWR Multicast message to get the member state of " + peerID.toString() + " IOException : " + e.getMessage());
                }
                if (!sent && !ioe) {
                    LOG.log(Level.FINE, "failed to send LWRMulticast message, send returned false");
                }
            }
        }
        prevResult = ((MemberStateResult)result).lock;
        synchronized (prevResult) {
            try {
                if (sent && ((MemberStateResult)result).memberState == null) {
                    ((MemberStateResult)result).lock.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, "wait() was interrupted : " + e.getMessage());
            }
        }
        if (((MemberStateResult)result).memberState != null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("getMemberStateViaLWR got state=" + ((MemberStateResult)result).memberState + " id=" + peerID);
            }
            return ((MemberStateResult)result).memberState;
        }
        this.memberStateResults.remove(peerID, result);
        String state = states[8];
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("getMemberStateViaLWR timeout id=" + peerID);
        }
        return state;
    }

    String getStateFromCache(PeerID peerID) {
        HealthMessage.Entry entry = this.cache.get(peerID);
        String state = entry != null ? entry.state : (peerID.equals(this.localPeerID) ? (!this.started ? states[0] : (this.readyStateComplete ? states[10] : states[2])) : ((entry = this.cache.get(peerID)) != null ? entry.state : (this.manager.getClusterViewManager().containsKey(peerID) ? states[0] : states[8])));
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHealthEntryIfMissing(SystemAdvertisement adv) {
        PeerID id = adv.getID();
        Object object = this.cacheLock;
        synchronized (object) {
            HealthMessage.Entry entry = this.cache.get(id);
            if (entry == null) {
                long BEFORE_FIRST_HEALTHMESSAGE_SEQ_ID = 0L;
                entry = new HealthMessage.Entry(adv, states[0], 0L);
                this.cache.put(id, entry);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportJoinedAndReadyState() {
        if (this.isWatchDog()) {
            return;
        }
        if (this.masterNode.isDiscoveryInProgress()) {
            Object object = this.masterNode.discoveryLock;
            synchronized (object) {
                try {
                    this.masterNode.discoveryLock.wait();
                    LOG.log(Level.FINEST, "reportJoinedAndReadyState() waiting for masternode discovery to finish...");
                }
                catch (InterruptedException e) {
                    LOG.log(Level.FINEST, "MasterNode's DiscoveryLock Thread is interrupted " + e);
                }
            }
        }
        this.readyStateComplete = true;
        if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned()) {
            this.setJoinedAndReadyReceived();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Sending Ready Event View for " + this.manager.getSystemAdvertisement().getName());
            }
            ClusterViewEvent cvEvent = this.masterNode.sendReadyEventView(this.manager.getSystemAdvertisement());
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, MessageFormat.format("Notifying Local listeners about Joined and Ready Event View for peer :{0}", this.manager.getSystemAdvertisement().getName()));
            }
            this.manager.getClusterViewManager().notifyListeners(cvEvent);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "mgmt.heatlhmonitor.ready");
        }
        this.reportMyState((short)9, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignAndReportFailure(HealthMessage.Entry entry) {
        HealthMessage.Entry deadEntry = null;
        if (entry != null) {
            ClusterViewEvent cvEvent;
            Object object = this.cacheLock;
            synchronized (object) {
                HealthMessage.Entry lastCheck = this.cache.get(entry.id);
                if (lastCheck == null || lastCheck.isState(6)) {
                    String deadTime = lastCheck == null ? "" : MessageFormat.format(" at {0,time,full} on {0,date}", new Date(lastCheck.timestamp));
                    LOG.log(Level.INFO, "mgmt.healthmonitor.alreadydead", new Object[]{entry.id, deadTime});
                    return;
                }
                deadEntry = new HealthMessage.Entry(lastCheck.adv, states[6], lastCheck.getSeqID());
                this.cache.put(lastCheck.id, deadEntry);
            }
            if (LOG.isLoggable(Level.FINE)) {
                this.fine(" assignAndReportFailure => going to put into cache " + entry.adv.getName() + " state is " + entry.state);
            }
            if (this.masterNode.isMaster()) {
                LOG.log(Level.FINE, MessageFormat.format("Reporting Failed Node {0}", entry.id.toString()));
                this.reportOtherPeerState(deadEntry);
            }
            boolean masterFailed = this.masterNode.getMasterNodeID().equals(entry.id);
            if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned()) {
                LOG.log(Level.FINE, MessageFormat.format("Removing System Advertisement :{0} for name {1}", entry.id.toString(), entry.adv.getName()));
                this.manager.getClusterViewManager().remove(entry.adv);
                LOG.log(Level.FINE, MessageFormat.format("Announcing Failure Event of {0} for name {1}...", entry.id, entry.adv.getName()));
                cvEvent = new ClusterViewEvent(ClusterViewEvents.FAILURE_EVENT, entry.adv);
                this.masterNode.viewChanged(cvEvent);
            } else if (masterFailed) {
                LOG.log(Level.FINE, MessageFormat.format("Master Failed. Removing System Advertisement :{0} for master named {1}", entry.id.toString(), entry.adv.getName()));
                this.manager.getClusterViewManager().remove(entry.adv);
                this.masterNode.resetMaster();
                this.masterNode.appointMasterNode();
                if (this.masterNode.isMaster() && this.masterNode.isMasterAssigned()) {
                    LOG.log(Level.FINE, MessageFormat.format("Announcing Failure Event of {0} for name {1}...", entry.id, entry.adv.getName()));
                    cvEvent = new ClusterViewEvent(ClusterViewEvents.FAILURE_EVENT, entry.adv);
                    this.masterNode.viewChanged(cvEvent);
                }
            }
            this.cleanAllCaches(entry);
        }
    }

    private void removeMasterAdv(HealthMessage.Entry entry, short state) {
        this.manager.getClusterViewManager().remove(entry.adv);
        if (entry.adv != null) {
            switch (state) {
                case 6: {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINER, "FV: Notifying local listeners of Failure of " + entry.adv.getName());
                    }
                    this.manager.getClusterViewManager().notifyListeners(new ClusterViewEvent(ClusterViewEvents.FAILURE_EVENT, entry.adv));
                    break;
                }
                case 4: {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINER, "FV: Notifying local listeners of Shutdown of " + entry.adv.getName());
                    }
                    this.manager.getClusterViewManager().notifyListeners(new ClusterViewEvent(ClusterViewEvents.PEER_STOP_EVENT, entry.adv));
                    break;
                }
                case 3: {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINER, "FV: Notifying local listeners of Cluster_Stopping of " + entry.adv.getName());
                    }
                    this.manager.getClusterViewManager().notifyListeners(new ClusterViewEvent(ClusterViewEvents.CLUSTER_STOP_EVENT, entry.adv));
                    break;
                }
                default: {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, MessageFormat.format("Invalid State for removing adv from view {0}", state));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            LOG.log(Level.WARNING, "mgmt.healthmonitor.removemasteradvfail", new Object[]{states[state], entry.id});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected(HealthMessage.Entry entry) {
        String machineStatus;
        boolean result = false;
        List<URI> list = entry.adv.getURIs();
        ArrayList<CheckConnectionToPeerMachine> connections = new ArrayList<CheckConnectionToPeerMachine>(list.size());
        AtomicInteger outstandingConnections = new AtomicInteger(list.size());
        PeerMachineConnectionResult checkConnectionsResult = new PeerMachineConnectionResult();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("HealthMonitor.isConnected() peerMachine=" + entry.adv.getName() + " number of network interfaces=" + outstandingConnections);
        }
        for (URI uri : list) {
            if (checkConnectionsResult.completed.get()) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Checking for machine status for network interface : " + uri.toString());
            }
            CheckConnectionToPeerMachine connectToPeer = new CheckConnectionToPeerMachine(entry, uri.getHost(), outstandingConnections, (int)this.failureDetectionTCPTimeout, checkConnectionsResult);
            connections.add(connectToPeer);
            connectToPeer.setFuture(this.isConnectedPool.submit(connectToPeer));
        }
        try {
            PeerMachineConnectionResult i$ = checkConnectionsResult;
            synchronized (i$) {
                if (!checkConnectionsResult.completed.get()) {
                    long startTime = 0L;
                    if (LOG.isLoggable(Level.FINE)) {
                        startTime = System.currentTimeMillis();
                    }
                    checkConnectionsResult.wait(this.failureDetectionTCPTimeout);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("waited " + (System.currentTimeMillis() - startTime) + " for CheckConnectionsToPeer to complete. failureDetectionTCPTimeout=" + this.failureDetectionTCPTimeout);
                    }
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("check connection completed with no waiting");
                }
            }
        }
        catch (InterruptedException e) {
            this.fine("InterruptedException occurred..." + e.getMessage(), new Object[]{e});
        }
        if (checkConnectionsResult.isConnectionUp()) {
            long startTime = 0L;
            if (LOG.isLoggable(Level.FINE)) {
                startTime = System.currentTimeMillis();
            }
            result = this.manager.getNetworkManager().isConnected(entry.id);
            if (LOG.isLoggable(Level.FINE)) {
                this.fine("routeControl.isConnected() for " + entry.adv.getName() + " is => " + result + " call elapsed time=" + (System.currentTimeMillis() - startTime) + "ms");
            }
        }
        boolean canceled = false;
        for (CheckConnectionToPeerMachine connection : connections) {
            try {
                Future future = connection.getFuture();
                if (future.isDone()) continue;
                future.cancel(true);
                canceled = true;
            }
            catch (Throwable t) {}
        }
        if (canceled) {
            this.isConnectedPool.purge();
        }
        String string = machineStatus = result ? "up!" : "down!";
        if (LOG.isLoggable(Level.FINE)) {
            this.fine("HealthMonitor.isConnected(): Peer Machine for " + entry.adv.getName() + " is " + machineStatus + " computeTime=" + (System.currentTimeMillis() - checkConnectionsResult.startTime) + "ms");
        }
        return result;
    }

    boolean isWatchDog() {
        return this.manager.isWatchdog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceWatchdogObservedFailure(String failedMemberToken) {
        block6: {
            String reason;
            IOException ioe = null;
            Message msg = this.createWatchdogNotification(failedMemberToken);
            boolean sent = false;
            try {
                sent = this.send(null, msg);
                if (sent) break block6;
                reason = "";
                MsgSendStats msgSendStats = this.getMsgSendStats(this.manager.getGroupName());
                if (!msgSendStats.reportSendFailed()) break block6;
                reason = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "send returned false";
            }
            catch (IOException io) {
                String reason2;
                try {
                    ioe = io;
                    if (sent) break block6;
                    reason2 = "";
                    MsgSendStats msgSendStats = this.getMsgSendStats(this.manager.getGroupName());
                    if (!msgSendStats.reportSendFailed()) break block6;
                    reason2 = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "send returned false";
                }
                catch (Throwable throwable) {
                    if (!sent) {
                        String reason3 = "";
                        MsgSendStats msgSendStats = this.getMsgSendStats(this.manager.getGroupName());
                        if (msgSendStats.reportSendFailed()) {
                            reason3 = ioe != null ? ioe.getClass().getSimpleName() + ":" + ioe.getLocalizedMessage() : "send returned false";
                            LOG.log(Level.WARNING, "mgmt.healthmonitor.failedwatchdognotify", new Object[]{failedMemberToken, this.manager.getGroupName(), reason3});
                        }
                    }
                    throw throwable;
                }
                LOG.log(Level.WARNING, "mgmt.healthmonitor.failedwatchdognotify", new Object[]{failedMemberToken, this.manager.getGroupName(), reason2});
            }
            LOG.log(Level.WARNING, "mgmt.healthmonitor.failedwatchdognotify", new Object[]{failedMemberToken, this.manager.getGroupName(), reason});
        }
    }

    public void setJoinedAndReadyReceived() {
        this.JoinedAndReadyReceived = true;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("JoinedAndReady notification received from master, set JoinedAndReadyReceived to true for member:" + this.manager.getInstanceName());
        }
    }

    public MsgSendStats getMsgSendStats(String memberName) {
        MsgSendStats putresult;
        MsgSendStats result = this.msgSendStats.get(memberName);
        if (result == null && (putresult = this.msgSendStats.putIfAbsent(memberName, result = new MsgSendStats(memberName))) != null) {
            result = putresult;
        }
        return result;
    }

    private static class MsgSendStats {
        final long MAX_DURATION_BETWEEN_FAILURE_REPORT_MS = 0x6DDD00L;
        String memberName;
        AtomicLong numSends;
        AtomicLong numFailSends;
        AtomicLong lastReportedFailSendTime;
        AtomicLong lastSendTime;

        MsgSendStats(String memberName) {
            this.memberName = memberName;
            this.numSends = new AtomicLong(0L);
            this.numFailSends = new AtomicLong(0L);
            this.lastReportedFailSendTime = new AtomicLong(-1L);
            this.lastSendTime = new AtomicLong(0L);
        }

        MsgSendStats sendSucceeded() {
            long value = this.numSends.incrementAndGet();
            if (value == Long.MAX_VALUE) {
                this.numSends.set(1L);
            }
            this.lastSendTime.set(System.currentTimeMillis());
            return this;
        }

        void sendFailed() {
            this.numSends.incrementAndGet();
            this.numFailSends.incrementAndGet();
        }

        boolean reportSendFailed() {
            if (this.lastSendTime.get() > this.lastReportedFailSendTime.get() || System.currentTimeMillis() - this.lastReportedFailSendTime.get() > 0x6DDD00L) {
                this.lastReportedFailSendTime.set(System.currentTimeMillis());
                return true;
            }
            return false;
        }

        String getFailureReport() {
            return this.memberName + " (failed to send " + this.numFailSends + " times)";
        }
    }

    private class CheckConnectionToPeerMachine
    implements Callable<Object> {
        HealthMessage.Entry entry;
        String address;
        Boolean connectionIsUp;
        boolean running;
        Future future;
        AtomicInteger outstandingConnectionChecks;
        PeerMachineConnectionResult result;
        final int socketConnectTimeout;

        CheckConnectionToPeerMachine(HealthMessage.Entry entry, String address, AtomicInteger outstanding, int socketConnectTimeout, PeerMachineConnectionResult result) {
            this.entry = entry;
            this.address = address;
            this.connectionIsUp = null;
            this.running = true;
            this.outstandingConnectionChecks = outstanding;
            this.result = result;
            this.socketConnectTimeout = socketConnectTimeout;
        }

        void setFuture(Future future) {
            this.future = future;
        }

        Future getFuture() {
            return this.future;
        }

        boolean isConnectionUp() {
            return this.connectionIsUp != null && this.connectionIsUp != false;
        }

        boolean completedComputation() {
            return !this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            InetSocketAddress siaddr = null;
            Socket socket = null;
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    HealthMonitor.this.fine("Attempting to connect to a socket at " + this.address + ":" + HealthMonitor.this.failureDetectionTCPPort + " timeout=" + this.socketConnectTimeout);
                }
                socket = new Socket();
                siaddr = new InetSocketAddress(this.address, HealthMonitor.this.failureDetectionTCPPort);
                socket.connect(siaddr, this.socketConnectTimeout);
                if (LOG.isLoggable(Level.FINE)) {
                    HealthMonitor.this.fine("Socket created at " + this.address + ":" + HealthMonitor.this.failureDetectionTCPPort);
                }
                this.connectionIsUp = Boolean.TRUE;
                return this.connectionIsUp;
            }
            catch (SocketTimeoutException toe) {
                this.connectionIsUp = Boolean.FALSE;
                LOG.fine("socket connection to " + siaddr + " timed out. " + toe.getLocalizedMessage());
            }
            catch (InterruptedIOException intioe) {
                this.connectionIsUp = null;
                return this.connectionIsUp;
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    HealthMonitor.this.fine("IOException occurred while trying to connect to peer " + this.entry.adv.getName() + "'s machine : " + e.getMessage(), new Object[]{e});
                }
                if (e.getMessage().trim().contains(HealthMonitor.CONNECTION_REFUSED)) {
                    this.connectionIsUp = Boolean.TRUE;
                }
                this.connectionIsUp = Boolean.FALSE;
                return this.connectionIsUp;
            }
            catch (Throwable t) {}
            finally {
                this.running = false;
                this.outstandingConnectionChecks.decrementAndGet();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        HealthMonitor.this.fine("Could not close the socket due to " + e.getMessage());
                    }
                    catch (Throwable t) {}
                }
                if (this.isConnectionUp() || this.outstandingConnectionChecks.get() <= 0) {
                    boolean completed = false;
                    PeerMachineConnectionResult peerMachineConnectionResult = this.result;
                    synchronized (peerMachineConnectionResult) {
                        if (!this.result.completed.get()) {
                            this.result.isConnectionUp = this.isConnectionUp();
                            if (this.result.isConnectionUp.booleanValue()) {
                                this.result.connectionUpSocketAddress = siaddr;
                            }
                            completed = true;
                            this.result.completed.set(true);
                            this.result.notifyAll();
                        }
                    }
                    if (completed && LOG.isLoggable(Level.FINE)) {
                        HealthMonitor.this.fine("completed computation that one of the network interfaces is up.  isConnectionUp=" + this.isConnectionUp() + " outstandingNetworkInterfaceChecks =" + this.outstandingConnectionChecks.get());
                    }
                }
                return this.connectionIsUp;
            }
        }
    }

    public static class PeerMachineConnectionResult {
        public Boolean isConnectionUp = null;
        public SocketAddress connectionUpSocketAddress = null;
        public AtomicBoolean completed = new AtomicBoolean(false);
        public long startTime = 0L;

        public boolean isConnectionUp() {
            return this.isConnectionUp != null && this.isConnectionUp != false;
        }

        PeerMachineConnectionResult() {
            if (LOG.isLoggable(Level.FINE)) {
                this.startTime = System.currentTimeMillis();
            }
        }
    }

    private class FailureVerifier
    implements Runnable {
        private final long buffer = 500L;

        private FailureVerifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!HealthMonitor.this.stop) {
                    LOG.log(Level.FINE, "FV: Entering verifierLock Wait....");
                    Object object = HealthMonitor.this.verifierLock;
                    synchronized (object) {
                        if (!HealthMonitor.this.outstandingFailureToVerify) {
                            HealthMonitor.this.verifierLock.wait();
                        }
                        HealthMonitor.this.outstandingFailureToVerify = false;
                    }
                    LOG.log(Level.FINE, "FV: Woken up from verifierLock Wait by a notify ....");
                    if (HealthMonitor.this.stop) continue;
                    LOG.log(Level.FINE, "FV: Calling verify() ....");
                    this.verify();
                    LOG.log(Level.FINE, "FV: Done verifying ....");
                }
            }
            catch (InterruptedException ex) {
                LOG.log(Level.FINE, MessageFormat.format("failure Verifier Thread stopping as it is now interrupted: {0}", ex.getLocalizedMessage()));
                HealthMonitor.this.print(HealthMonitor.this.cache);
            }
        }

        void verify() throws InterruptedException {
            Thread.sleep(HealthMonitor.this.verifyTimeout + 500L);
            Iterator i$ = HealthMonitor.this.getCacheCopy().values().iterator();
            while (i$.hasNext()) {
                HealthMessage.Entry entry1;
                HealthMessage.Entry entry = entry1 = (HealthMessage.Entry)i$.next();
                LOG.log(Level.FINE, "FV: Verifying state of " + entry.adv.getName() + " state = " + entry.state);
                if (!entry.state.equals(states[7]) || HealthMonitor.this.isConnected(entry)) continue;
                LOG.log(Level.FINE, "FV: Assigning and reporting failure ....");
                HealthMonitor.this.assignAndReportFailure(entry);
            }
        }
    }

    private class InDoubtPeerDetector
    implements Runnable {
        private Thread fvThread = null;

        private InDoubtPeerDetector() {
        }

        void start() {
            String GROUPNAME = HealthMonitor.this.manager.getGroupName();
            HealthMonitor.this.failureDetectorThread = new Thread((Runnable)this, "GMS InDoubtPeerDetector Thread for Group-" + GROUPNAME);
            HealthMonitor.this.failureDetectorThread.setDaemon(true);
            LOG.log(Level.FINE, "Starting InDoubtPeerDetector Thread");
            HealthMonitor.this.failureDetectorThread.start();
            FailureVerifier fverifier = new FailureVerifier();
            this.fvThread = new Thread((Runnable)fverifier, "GMS FailureVerifier Thread for Group-" + GROUPNAME);
            this.fvThread.setDaemon(true);
            LOG.log(Level.FINE, "Starting FailureVerifier Thread");
            this.fvThread.start();
        }

        void stop() {
            Thread tmpThread = HealthMonitor.this.failureDetectorThread;
            HealthMonitor.this.failureDetectorThread = null;
            if (tmpThread != null) {
                tmpThread.interrupt();
            }
            Thread tmpFVThread = this.fvThread;
            this.fvThread = null;
            if (tmpFVThread != null) {
                tmpFVThread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!HealthMonitor.this.stop) {
                try {
                    Object object = HealthMonitor.this.indoubtthreadLock;
                    synchronized (object) {
                        HealthMonitor.this.indoubtthreadLock.wait(HealthMonitor.this.timeout);
                    }
                    if (HealthMonitor.this.manager.isStopping()) continue;
                    this.processCacheUpdate();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINEST, "InDoubtPeerDetector Thread stopping as it is now interrupted :" + ex.getLocalizedMessage());
                    break;
                }
                catch (Throwable all) {
                    LOG.log(Level.FINE, "Uncaught Throwable in failureDetectorThread " + Thread.currentThread().getName() + ":" + all, all);
                }
            }
        }

        int computeMissedBeat(long cacheSnapShotTime, HealthMessage.Entry entry) {
            return (int)((cacheSnapShotTime - entry.timestamp) / HealthMonitor.this.timeout);
        }

        private void processCacheUpdate() {
            Map cacheCopy = HealthMonitor.this.getCacheCopy();
            long cacheSnapShotTime = System.currentTimeMillis();
            for (HealthMessage.Entry entry : cacheCopy.values()) {
                if (entry.id.equals(HealthMonitor.this.manager.getSystemAdvertisement().getID()) || !entry.state.equals(states[0]) && !entry.state.equals(states[2]) && !entry.state.equals(states[9]) && !entry.state.equals(states[10])) continue;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("processCacheUpdate : " + entry.adv.getName() + " 's state is " + entry.state);
                }
                try {
                    this.determineInDoubtPeers(entry, cacheSnapShotTime);
                }
                catch (NumberFormatException nfe) {
                    if (LOG.isLoggable(Level.FINER)) {
                        nfe.printStackTrace();
                    }
                    LOG.log(Level.WARNING, "mgmt.healthmonitor.timestampconversionexception", nfe.getLocalizedMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void determineInDoubtPeers(HealthMessage.Entry entry, long cacheSnapShotTime) {
            if (!HealthMonitor.this.stop) {
                boolean processInDoubt = this.canProcessInDoubt(entry);
                if (processInDoubt && LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, MessageFormat.format("For instance = {0}; last recorded heart-beat = {1}ms ago, heart-beat # {2} out of a max of {3}", entry.adv.getName(), cacheSnapShotTime - entry.timestamp, this.computeMissedBeat(cacheSnapShotTime, entry), HealthMonitor.this.maxMissedBeats));
                }
                if (processInDoubt && this.computeMissedBeat(cacheSnapShotTime, entry) >= HealthMonitor.this.maxMissedBeats && !HealthMonitor.this.isConnected(entry)) {
                    LOG.log(Level.FINER, "Designating InDoubtState for " + entry.adv.getName());
                    this.designateInDoubtState(entry);
                    LOG.log(Level.FINER, "Notifying FailureVerifier for " + entry.adv.getName());
                    Object object = HealthMonitor.this.verifierLock;
                    synchronized (object) {
                        HealthMonitor.this.outstandingFailureToVerify = true;
                        HealthMonitor.this.verifierLock.notify();
                    }
                    LOG.log(Level.FINER, "Done Notifying FailureVerifier for " + entry.adv.getName());
                }
            }
        }

        private boolean canProcessInDoubt(HealthMessage.Entry entry) {
            boolean canProcessIndoubt = false;
            if (!entry.id.equals(HealthMonitor.this.localPeerID)) {
                if (HealthMonitor.this.masterNode.getMasterNodeID().equals(entry.id)) {
                    canProcessIndoubt = true;
                } else if (HealthMonitor.this.masterNode.isMaster()) {
                    canProcessIndoubt = true;
                }
            }
            return canProcessIndoubt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void designateInDoubtState(HealthMessage.Entry entry) {
            HealthMessage.Entry reportEntry = null;
            HealthMonitor.this.fine(" in designateInDoubtState, going to set the state of " + entry.adv.getName() + " to indoubt");
            Object object = HealthMonitor.this.cacheLock;
            synchronized (object) {
                entry.state = states[7];
                reportEntry = new HealthMessage.Entry(entry);
                HealthMonitor.this.cache.put(entry.id, entry);
            }
            if (HealthMonitor.this.masterNode.isMaster()) {
                HealthMonitor.this.fine("Sending INDOUBT state message about member: " + entry.adv.getName() + " to the group: " + HealthMonitor.this.manager.getGroupName());
                HealthMonitor.this.reportOtherPeerState(reportEntry);
            }
            LOG.log(Level.FINEST, "Notifying Local Listeners of designated indoubt state for " + entry.adv.getName());
            HealthMonitor.this.notifyLocalListeners(reportEntry.state, reportEntry.adv);
        }
    }

    static class MemberStateResult {
        final Object lock = new Object();
        String memberState = null;

        MemberStateResult() {
        }
    }
}

