/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.Tokenizer;
import com.sun.enterprise.v3.server.APIClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.AppLibClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.ConnectorClassLoaderServiceImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ClassLoaderHierarchyImpl
implements ClassLoaderHierarchy {
    @Inject
    APIClassLoaderServiceImpl apiCLS;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    @Inject
    ConnectorClassLoaderServiceImpl connectorCLS;
    @Inject
    AppLibClassLoaderServiceImpl applibCLS;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;

    public ClassLoader getAPIClassLoader() {
        return this.apiCLS.getAPIClassLoader();
    }

    public ClassLoader getCommonClassLoader() {
        return this.commonCLS.getCommonClassLoader();
    }

    public String getCommonClassPath() {
        return this.commonCLS.getCommonClassPath();
    }

    public DelegatingClassLoader getConnectorClassLoader(String application) {
        return this.connectorCLS.getConnectorClassLoader(application);
    }

    public ClassLoader getAppLibClassLoader(String application, List<URI> libURIs) throws MalformedURLException {
        return this.applibCLS.getAppLibClassLoader(application, libURIs);
    }

    public ClassLoader createApplicationParentCL(ClassLoader parent, DeploymentContext context) throws ResolveError {
        String requestedWiring;
        String importedBundles;
        Manifest m;
        ArrayList<ModuleDefinition> defs;
        block8: {
            ReadableArchive source = context.getSource();
            defs = new ArrayList<ModuleDefinition>();
            m = null;
            try {
                m = source.getManifest();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Cannot load application's manifest file :", e.getMessage());
                if (!this.logger.isLoggable(Level.FINE)) break block8;
                this.logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (m != null && (importedBundles = m.getMainAttributes().getValue("HK2-Import-Bundles")) != null) {
            for (String token : new Tokenizer(importedBundles, ",")) {
                Module module = this.modulesRegistry.makeModuleFor(token, null);
                if (module == null) continue;
                defs.add(module.getModuleDefinition());
            }
        }
        if (m != null && (requestedWiring = m.getMainAttributes().getValue("GlassFish-require-services")) != null) {
            for (String token : new Tokenizer(requestedWiring, ",")) {
                for (Inhabitant impl : this.habitat.getInhabitantsByContract(token)) {
                    Module wiredBundle = this.modulesRegistry.find(impl.get().getClass());
                    if (wiredBundle == null) continue;
                    defs.add(wiredBundle.getModuleDefinition());
                }
            }
        }
        if (defs.isEmpty()) {
            return parent;
        }
        return this.modulesRegistry.getModulesClassLoader(parent, defs);
    }
}

