/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.APIClassLoaderServiceImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class CommonClassLoaderServiceImpl
implements PostConstruct {
    private ClassLoader commonClassLoader;
    @Inject
    APIClassLoaderServiceImpl acls;
    @Inject
    ServerEnvironment env;
    static final Logger logger = LogDomains.getLogger(CommonClassLoaderServiceImpl.class, (String)"javax.enterprise.system.core.classloading");
    private ClassLoader APIClassLoader;
    private String commonClassPath = "";

    public void postConstruct() {
        this.APIClassLoader = this.acls.getAPIClassLoader();
        assert (this.APIClassLoader != null);
        this.createCommonClassLoader();
    }

    private void createCommonClassLoader() {
        File domainLib;
        ArrayList<File> cpElements = new ArrayList<File>();
        File domainDir = this.env.getDomainRoot();
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        if (installRoot != null) {
            File installDir = new File(installRoot);
            File installLibPath = new File(installDir, "lib");
            if (installLibPath.isDirectory()) {
                Collections.addAll(cpElements, installLibPath.listFiles(new JarFileFilter()));
            }
        } else {
            logger.logp(Level.WARNING, "CommonClassLoaderServiceImpl", "createCommonClassLoader", "System property called {0} is null, is this intended?", new Object[]{"com.sun.aas.installRoot"});
        }
        File domainClassesDir = new File(domainDir, "lib/classes/");
        if (domainClassesDir.exists()) {
            cpElements.add(domainClassesDir);
        }
        if ((domainLib = new File(domainDir, "lib/")).isDirectory()) {
            Collections.addAll(cpElements, domainLib.listFiles(new JarFileFilter()));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        StringBuilder cp = new StringBuilder();
        for (File f : cpElements) {
            try {
                urls.add(f.toURI().toURL());
                if (cp.length() > 0) {
                    cp.append(File.pathSeparator);
                }
                cp.append(f.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                logger.logp(Level.WARNING, "ClassLoaderManager", "postConstruct", "e = {0}", new Object[]{e});
            }
        }
        this.commonClassPath = cp.toString();
        if (!urls.isEmpty()) {
            this.commonClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.APIClassLoader);
        } else {
            logger.logp(Level.INFO, "CommonClassLoaderManager", "Skipping creation of CommonClassLoader as there are no libraries available", "urls = {0}", new Object[]{urls});
        }
    }

    public ClassLoader getCommonClassLoader() {
        return this.commonClassLoader != null ? this.commonClassLoader : this.APIClassLoader;
    }

    public String getCommonClassPath() {
        return this.commonClassPath;
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private final String JAR_EXT = ".jar";

        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

