/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.SnifferAnnotationScanner;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SnifferManager {
    volatile Collection<Sniffer> sniffers;
    @Inject
    protected Habitat habitat;

    public Collection<Sniffer> getSniffers() {
        if (this.sniffers == null) {
            this.sniffers = this.habitat.getAllByContract(Sniffer.class);
        }
        return this.sniffers;
    }

    public final boolean hasNoSniffers() {
        return this.getSniffers().isEmpty();
    }

    public Sniffer getSniffer(String appType) {
        assert (appType != null);
        for (Sniffer sniffer : this.getSniffers()) {
            if (!appType.equalsIgnoreCase(sniffer.getModuleType())) continue;
            return sniffer;
        }
        return null;
    }

    public Collection<Sniffer> getSniffers(ReadableArchive archive, ClassLoader cloader) {
        ArrayList<Sniffer> appSniffers = new ArrayList<Sniffer>();
        SnifferAnnotationScanner snifferAnnotationScanner = new SnifferAnnotationScanner();
        for (Sniffer sniffer : this.getSniffers()) {
            snifferAnnotationScanner.register(sniffer, sniffer.getAnnotationTypes());
        }
        snifferAnnotationScanner.scanArchive(archive);
        appSniffers.addAll(snifferAnnotationScanner.getApplicableSniffers());
        for (Sniffer sniffer : this.getSniffers()) {
            if (appSniffers.contains(sniffer) || !sniffer.handles(archive, cloader)) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }
}

