/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.J2EESecurityManager;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.SecurityLifecycleException;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.RealmConfig;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Security;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.glassfish.api.Startup;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecurityLifecycle
implements PostConstruct,
PreDestroy {
    @Inject
    private ServerContext sc;
    @Inject
    private SecurityServicesUtil secServUtil;
    @Inject
    private Util util;
    @Inject
    private SecurityConfigListener configListener;
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(SecurityLifecycle.class);
    private static final Logger _logger = LogDomains.getLogger(SecurityLifecycle.class, (String)"javax.enterprise.system.core.security");

    public SecurityLifecycle() {
        try {
            SecurityManager secMgr = System.getSecurityManager();
            if (secMgr != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
                J2EESecurityManager mgr = new J2EESecurityManager();
                try {
                    System.setSecurityManager(mgr);
                }
                catch (SecurityException ex) {
                    _logger.log(Level.WARNING, "security.secmgr.could.not.override");
                }
            }
            if (_logger.isLoggable(Level.INFO)) {
                if (secMgr != null) {
                    _logger.info("security.secmgron");
                } else {
                    _logger.info("security.secmgroff");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization() {
        try {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Security startup service called");
            }
            LoginContextDriver.AUDIT_MANAGER = this.secServUtil.getAuditManager();
            this.secServUtil.initSecureSeed();
            this.initializeJMAC();
            this.createRealms();
            this.secServUtil.getAuditManager().loadAuditModules();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Security service(s) started successfully....");
            }
        }
        catch (Exception ex) {
            throw new SecurityLifecycleException(ex);
        }
    }

    private void initializeJMAC() throws IOException {
        String defaultFactory = Security.getProperty("authconfigprovider.factory");
        if (defaultFactory == null) {
            Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
        }
    }

    private boolean realmsAlreadyLoaded() {
        Enumeration en;
        RealmsManager mgr = (RealmsManager)this.sc.getDefaultHabitat().getComponent(RealmsManager.class);
        return mgr != null && (en = mgr.getRealmNames()).hasMoreElements();
    }

    private void registerPolicyHandlers() throws PolicyContextException {
        PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
        PolicyContext.registerHandler("javax.ejb.EnterpriseBean", pch, true);
        PolicyContext.registerHandler("javax.security.auth.Subject.container", pch, true);
        PolicyContext.registerHandler("javax.ejb.arguments", pch, true);
        PolicyContext.registerHandler("javax.servlet.http.HttpServletRequest", pch, true);
        PolicyContext.registerHandler("java.security.Policy.supportsReuse", pch, true);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.START;
    }

    public void postConstruct() {
        this.onInitialization();
    }

    public void preDestroy() {
    }

    public void createRealms() {
        if (this.realmsAlreadyLoaded()) {
            return;
        }
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Initializing configured realms from SecurityService in Domain.xml....");
            }
            SecurityService securityBean = (SecurityService)this.sc.getDefaultHabitat().getComponent(SecurityService.class);
            assert (securityBean != null);
            String defaultRealm = securityBean.getDefaultRealm();
            List realms = securityBean.getAuthRealm();
            assert (realms != null);
            RealmConfig.createRealms((String)defaultRealm, (List)realms);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "realmconfig.nogood", e);
        }
    }
}

