/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.provider.PolicyConfigurationImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileFilter;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractProvided(value=PolicyConfigurationFactory.class)
public class PolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PolicyConfigurationFactoryImpl.class);
    private Map polConfTable = new HashMap();
    private HashMap linkTable = new HashMap();
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private Lock rLock = this.rwLock.readLock();
    private Lock wLock = this.rwLock.writeLock();
    private String repository = this.initializeRepository();
    private static PolicyConfigurationFactoryImpl singleton = null;
    private static final String REPOSITORY_HOME_PROP = "com.sun.enterprise.jaccprovider.property.repository";
    private Permission setPolicyPermission = null;

    public PolicyConfigurationFactoryImpl() {
        singleton = this;
    }

    public PolicyConfiguration getPolicyConfiguration(String contextId, boolean remove) throws PolicyContextException {
        PolicyConfigurationImpl pci;
        this.checkSetPolicyPermission();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Getting PolicyConfiguration object with id = " + contextId);
        }
        if ((pci = this.getPolicyConfigImpl(contextId)) == null) {
            pci = this.getPolicyConfigurationImplFromDirectory(contextId, true, remove);
            if (pci == null) {
                pci = new PolicyConfigurationImpl(contextId, this);
                this.putPolicyConfigurationImpl(contextId, pci);
            }
        } else {
            pci.initialize(true, remove, false);
        }
        return pci;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        this.checkSetPolicyPermission();
        PolicyConfigurationImpl pc = this.getPolicyConfigImpl(contextID);
        if (pc == null) {
            pc = this.getPolicyConfigurationImplFromDirectory(contextID, false, false);
        }
        return pc == null ? false : pc.inService();
    }

    private PolicyConfigurationImpl getPolicyConfigurationImplFromDirectory(String contextId, boolean open, boolean remove) {
        PolicyConfigurationImpl pci = null;
        File f = new File(this.getContextDirectoryName(contextId));
        if (f.exists() && (pci = new PolicyConfigurationImpl(f, open, remove, this)) != null) {
            this.putPolicyConfigurationImpl(contextId, pci);
        }
        return pci;
    }

    String getContextDirectoryName(String contextId) {
        if (this.repository == null) {
            throw new RuntimeException("JACC Policy provider: repository not initialized");
        }
        return this.repository + File.separator + contextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PolicyConfigurationImpl[] getPolicyConfigurationImpls() {
        PolicyConfigurationImpl[] rvalue = null;
        this.rLock.lock();
        try {
            Collection c = this.polConfTable.values();
            if (c != null) {
                rvalue = c.toArray(new PolicyConfigurationImpl[c.size()]);
            }
        }
        finally {
            this.rLock.unlock();
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PolicyConfigurationImpl putPolicyConfigurationImpl(String contextID, PolicyConfigurationImpl pci) {
        this.wLock.lock();
        try {
            PolicyConfigurationImpl policyConfigurationImpl = this.polConfTable.put(contextID, pci);
            return policyConfigurationImpl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyConfigurationImpl getPolicyConfigImpl(String contextId) {
        this.rLock.lock();
        try {
            PolicyConfigurationImpl policyConfigurationImpl = (PolicyConfigurationImpl)this.polConfTable.get(contextId);
            return policyConfigurationImpl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PolicyConfigurationImpl removePolicyConfigurationImpl(String contextID) {
        this.wLock.lock();
        try {
            PolicyConfigurationImpl policyConfigurationImpl = (PolicyConfigurationImpl)this.polConfTable.remove(contextID);
            return policyConfigurationImpl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected PolicyConfigurationImpl getPolicyConfigurationImpl(String contextId) {
        PolicyConfigurationImpl pci = this.getPolicyConfigImpl(contextId);
        if (pci == null && (pci = this.getPolicyConfigurationImplFromDirectory(contextId, false, false)) == null) {
            logger.log(Level.WARNING, "pc.unknown_policy_context", new Object[]{contextId});
        }
        return pci;
    }

    protected void checkSetPolicyPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.setPolicyPermission == null) {
                this.setPolicyPermission = new SecurityPermission("setPolicy");
            }
            sm.checkPermission(this.setPolicyPermission);
        }
    }

    HashMap getLinkTable() {
        return this.linkTable;
    }

    String getRepository() {
        return this.repository;
    }

    private String initializeRepository() {
        try {
            this.repository = System.getProperty(REPOSITORY_HOME_PROP);
            if (this.repository == null) {
                String msg = localStrings.getLocalString("pc.no_repository", "no repository");
                logger.log(Level.SEVERE, msg);
            } else {
                File rf;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JACC policy provider: repository set to: " + this.repository);
                }
                if ((rf = new File(this.repository)).exists()) {
                    if (!rf.isDirectory()) {
                        String msg = localStrings.getLocalString("pc.unable_to_create_repository", "unable to create repository" + this.repository, new Object[]{this.repository});
                        logger.log(Level.SEVERE, msg);
                    } else {
                        File[] appsInService = rf.listFiles();
                        if (appsInService != null) {
                            for (int i = 0; i < appsInService.length; ++i) {
                                File[] contextsInService = appsInService[i].listFiles(new FileFilter(){

                                    public boolean accept(File pathname) {
                                        return pathname.isDirectory();
                                    }
                                });
                                if (contextsInService == null) continue;
                                for (int j = 0; j < contextsInService.length; ++j) {
                                    try {
                                        PolicyConfigurationImpl pc = new PolicyConfigurationImpl(contextsInService[j], false, false, this);
                                        this.putPolicyConfigurationImpl(pc.CONTEXT_ID, pc);
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        String msg = localStrings.getLocalString("pc.unable_to_read_repostory", "unable to read repository", new Object[]{contextsInService[i].toString()});
                                        logger.log(Level.WARNING, msg);
                                    }
                                }
                            }
                        }
                    }
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("JACC Policy Provider: creating new policy repository");
                    }
                    rf.mkdirs();
                }
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString("pc.unable_to_init_repository", "unable to init repository", new Object[]{e});
            logger.log(Level.SEVERE, msg);
            this.repository = null;
        }
        return this.repository;
    }

    static PolicyConfigurationFactoryImpl getInstance() {
        return singleton;
    }
}

