/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class WebSecurityManagerFactory
extends SecurityManagerFactory {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    final PolicyContextHandlerImpl pcHandlerImpl = (PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance();
    final Map ADMIN_PRINCIPAL = new HashMap();
    final Map ADMIN_GROUP = new HashMap();
    private Map<String, ArrayList<String>> CONTEXT_IDS = new HashMap<String, ArrayList<String>>();
    private Map<String, Map<String, WebSecurityManager>> SECURITY_MANAGERS = new HashMap<String, Map<String, WebSecurityManager>>();

    public WebSecurityManagerFactory() {
        WebSecurityManagerFactory.registerPolicyHandlers();
    }

    public Principal getAdminPrincipal(String username, String realmName) {
        return (Principal)this.ADMIN_PRINCIPAL.get(realmName + username);
    }

    public Principal getAdminGroup(String group, String realmName) {
        return (Principal)this.ADMIN_GROUP.get(realmName + group);
    }

    private static void registerPolicyHandlers() {
        try {
            PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
            PolicyContext.registerHandler("javax.ejb.EnterpriseBean", pch, true);
            PolicyContext.registerHandler("javax.security.auth.Subject.container", pch, true);
            PolicyContext.registerHandler("javax.ejb.arguments", pch, true);
            PolicyContext.registerHandler("javax.servlet.http.HttpServletRequest", pch, true);
            PolicyContext.registerHandler("java.security.Policy.supportsReuse", pch, true);
        }
        catch (PolicyContextException ex) {
            Logger.getLogger(WebSecurityManagerFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public WebSecurityManager getManager(String ctxId, String name, boolean remove) {
        return (WebSecurityManager)this.getManager(this.SECURITY_MANAGERS, ctxId, name, remove);
    }

    public <T> ArrayList<WebSecurityManager> getManagers(String ctxId, boolean remove) {
        return this.getManagers(this.SECURITY_MANAGERS, ctxId, remove);
    }

    public <T> ArrayList<WebSecurityManager> getManagersForApp(String appName, boolean remove) {
        return this.getManagersForApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, appName, remove);
    }

    public <T> String[] getContextsForApp(String appName, boolean remove) {
        return this.getContextsForApp(this.CONTEXT_IDS, appName, remove);
    }

    public <T> void addManagerToApp(String ctxId, String name, String appName, WebSecurityManager manager) {
        this.addManagerToApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, ctxId, name, appName, manager);
    }

    public WebSecurityManager createManager(WebBundleDescriptor wbd, boolean register, ServerContext context) {
        String ctxId = WebSecurityManager.getContextID(wbd);
        WebSecurityManager manager = null;
        if (register) {
            manager = this.getManager(ctxId, null, false);
        }
        if (manager == null || !register) {
            try {
                manager = new WebSecurityManager(wbd, context, this, register);
                if (register) {
                    String appName = wbd.getApplication().getRegistrationName();
                    this.addManagerToApp(ctxId, null, appName, manager);
                }
            }
            catch (PolicyContextException e) {
                logger.log(Level.FINE, "[Web-Security] FATAL Exception. Unable to create WebSecurityManager: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        return manager;
    }
}

