/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DatabaseReporter {
    private static final StringManager lsm = StringManager.getManager(DatabaseReporter.class);
    private static final CLILogger logger = CLILogger.getInstance();
    private static final String DERBY_CLIENT_DRIVER_CLASS_NAME = "org.apache.derby.jdbc.ClientDriver";
    private static final String URL = "jdbc:derby://localhost:";
    private static final String DB_NAME = "/testconnectivity;create=true";
    private static final String USER = "APP";
    private static final String PASS = "APP";
    private static final String DB_PORT = "1527";
    private static final String DB_HOME = System.getProperty("user.dir");
    private final String dcn;
    private final String url;
    private final String user;
    private final String password;
    private final String dbhome;
    private final String dbport;
    private final Connection conn;

    public DatabaseReporter(String dbhome, String dbport, String dcn, String url, String user, String password) throws Exception {
        this.dcn = dcn;
        this.user = user;
        this.password = password;
        this.dbhome = dbhome;
        this.dbport = dbport;
        this.url = url + dbport + DB_NAME;
        Class.forName(dcn);
        this.conn = DriverManager.getConnection(this.url, this.user, this.password);
    }

    private void display() throws Exception {
        logger.printMessage(this.getDatabaseInfoMsg());
        logger.printMessage(this.getDatabaseDriverNameMsg());
        logger.printMessage(this.getDatabaseDriverVersionMsg());
        logger.printMessage(this.getJDBCSpecificationMsg());
    }

    private String getDatabaseInfoMsg() {
        return lsm.getString("database.info.msg");
    }

    private String getDatabaseDriverNameMsg() throws SQLException {
        String sDriverName = this.conn.getMetaData().getDriverName();
        return lsm.getString("database.driver.name.msg", (Object)sDriverName);
    }

    private String getDatabaseDriverVersionMsg() throws SQLException {
        String sDriverVersion = this.conn.getMetaData().getDriverVersion();
        return lsm.getString("database.driver.version.msg", (Object)sDriverVersion);
    }

    private String getJDBCSpecificationMsg() throws SQLException {
        int iJDBCMajorVersion = this.conn.getMetaData().getJDBCMajorVersion();
        int iJDBCMinorVersion = this.conn.getMetaData().getJDBCMinorVersion();
        String sJDBCSpec = iJDBCMajorVersion + "." + iJDBCMinorVersion;
        return lsm.getString("jdbc.version.msg", (Object)sJDBCSpec);
    }

    private void removeDatabaseFile() {
        File f = new File(this.dbhome, "testconnectivity");
        FileUtils.whack((File)f);
    }

    public static void main(String[] args) throws Exception {
        DatabaseReporter dmt = null;
        dmt = args == null || args.length < 6 && args.length > 2 ? new DatabaseReporter(DB_HOME, DB_PORT, DERBY_CLIENT_DRIVER_CLASS_NAME, URL, "APP", "APP") : (args.length == 2 ? new DatabaseReporter(args[0], args[1], DERBY_CLIENT_DRIVER_CLASS_NAME, URL, "APP", "APP") : new DatabaseReporter(args[0], args[1], args[2], args[3], args[4], args[5]));
        try {
            dmt.display();
            dmt.removeDatabaseFile();
        }
        catch (Exception e) {
            logger.printMessage(lsm.getString("UnableToConnectToDatabase"));
            System.exit(1);
        }
    }
}

