/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.rails;

import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.scripting.rails.Messages;
import org.glassfish.scripting.rails.RailsDeployer;

public class RailsApplication
implements ApplicationContainer,
org.glassfish.api.container.Adapter {
    private final Logger logger;
    private Object jRubyRuntime;
    private Adapter adapter;
    private final String contextRoot;
    private final RailsDeployer.JRubyEnvironment jrubyEnv;

    RailsApplication(RailsDeployer.JRubyEnvironment env, String railsRoot, Logger logger, String ctxRoot) {
        this.logger = logger;
        this.jrubyEnv = env;
        this.contextRoot = ctxRoot;
        try {
            URL[] urls = this.findJRubyJars();
            URLClassLoader cl = new URLClassLoader(urls, RailsApplication.class.getClassLoader());
            Class<?> c = cl.loadClass("com.sun.grizzly.jruby.RubyRuntime");
            this.jRubyRuntime = c.getConstructor(String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE).newInstance(this.contextRoot, railsRoot, this.jrubyEnv.jrubyLib, this.jrubyEnv.numberOfRuntime, this.jrubyEnv.minRuntime, this.jrubyEnv.maxRuntime, true);
            this.adapter = (Adapter)c.getMethod("getAdapter", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, Messages.format("railsapplication.adaptor.creation.error", e.getMessage()), e);
            return;
        }
    }

    Adapter getAdapter() {
        return this.adapter;
    }

    public boolean stop(ApplicationContext startupContext) {
        try {
            this.jRubyRuntime.getClass().getMethod("stopRubyRuntimePool", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, Messages.format("railsapplication.error.stopping", this.contextRoot, e.getMessage()), e);
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) {
        return true;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void service(Request request, Response response) throws Exception {
        this.adapter.service(request, response);
    }

    public void afterService(Request request, Response response) throws Exception {
        this.adapter.afterService(request, response);
    }

    private URL[] findJRubyJars() throws MalformedURLException, ClassNotFoundException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File jrubyLibDir = new File(this.jrubyEnv.jrubyLib);
        File jrubyJar = new File(this.jrubyEnv.jrubyLib, "jruby.jar");
        if (!jrubyJar.exists()) {
            throw new IllegalArgumentException(Messages.format("railsapplication.jrubylib.notfound", this.jrubyEnv.jrubyLib));
        }
        for (File lib : jrubyLibDir.listFiles()) {
            if (!lib.isFile() || !lib.toString().endsWith(".jar")) continue;
            urls.add(lib.toURI().toURL());
        }
        File grizzlyjruby = this.jrubyEnv.rootDir;
        File[] grizzlyjrubyJars = grizzlyjruby.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith("grizzly-jruby-module") && name.startsWith("grizzly-jruby");
            }
        });
        if (grizzlyjrubyJars.length > 0) {
            urls.add(grizzlyjrubyJars[0].toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

