/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;

class HttpHeaderParser {
    private final GrizzlyResponse response;
    private int pos;

    public HttpHeaderParser(GrizzlyResponse response) {
        this.response = response;
    }

    public int parseHeaders(byte[] buf, int offset, int len) throws IOException {
        this.pos = offset;
        while (this.parseHeader(buf, len)) {
        }
        return this.pos;
    }

    private boolean parseHeader(byte[] buf, int len) throws IOException {
        String fieldName = null;
        if (this.pos >= len) {
            return false;
        }
        byte chr = 0;
        while (this.pos < len && ((chr = buf[this.pos]) == 13 || chr == 10)) {
            chr = buf[this.pos + 1];
            if (chr == 10) {
                this.pos += 2;
                return false;
            }
            ++this.pos;
        }
        int start = this.pos;
        boolean colon = false;
        while (!colon && this.pos < len) {
            if (buf[this.pos] == 58) {
                colon = true;
                fieldName = new String(buf, start, this.pos - start).trim();
            }
            chr = buf[this.pos];
            ++this.pos;
        }
        boolean eol = false;
        boolean validLine = true;
        boolean space = false;
        while (space && this.pos < len) {
            if (buf[this.pos] == 32 || buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        int realPos = this.pos;
        while (validLine) {
            int lastSignificantChar = realPos;
            while (!eol && this.pos < len) {
                if (buf[this.pos] != 13) {
                    if (buf[this.pos] == 10) {
                        eol = true;
                    } else {
                        realPos = buf[this.pos] == 32 ? ++realPos : ++realPos;
                    }
                }
                ++this.pos;
            }
            chr = buf[this.pos];
            if (chr != 32 && chr != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            ++realPos;
        }
        if (fieldName != null) {
            String fieldValue = new String(buf, start, realPos - start).trim();
            if (fieldName.equalsIgnoreCase("Content-Type")) {
                this.response.setContentType(fieldValue);
            } else if (fieldName.equalsIgnoreCase("status")) {
                int index;
                int value = 200;
                String msg = "OK";
                if (fieldValue != null && (index = fieldValue.indexOf(32)) != -1) {
                    try {
                        value = Integer.valueOf(fieldValue.substring(0, index));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    msg = fieldValue.substring(index, fieldValue.length()).trim();
                }
                this.response.setStatus(value, msg);
            } else if (fieldName.equalsIgnoreCase("Content-Length")) {
                try {
                    this.response.setContentLength(Integer.valueOf(fieldValue).intValue());
                }
                catch (NumberFormatException e) {}
            } else {
                this.response.addHeader(fieldName, fieldValue);
            }
        }
        return true;
    }
}

