/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.Messages;
import com.sun.grizzly.jruby.RailsOutputStream;
import com.sun.grizzly.jruby.RubyAdapter;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.pool.DynamicPool;
import com.sun.grizzly.pool.DynamicPoolConfig;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;

public class RailsAdapter
extends GrizzlyAdapter {
    private final DynamicPool<Ruby> pool;
    private RubyRuntimeAsyncFilter asyncFilter;
    private final String contextRoot;
    private final Map environment = new HashMap();
    private File webDir = null;
    private final ReentrantLock initializedLock = new ReentrantLock();
    private final int numThreads;
    private ConcurrentHashMap<String, File> cache = new ConcurrentHashMap();
    private final DispatchFilter debugDispatchFilter;
    private final Map<Ruby, WeakHashMap<Thread, RubyThread>> threadMaps = new HashMap<Ruby, WeakHashMap<Thread, RubyThread>>();

    public RailsAdapter(String railsRoot, String jrubyLib, int numRt, int minRt, int maxRt, boolean asyncExecution, RubyRuntimeAsyncFilter asyncFilter) {
        this("/", railsRoot, jrubyLib, numRt, minRt, maxRt, asyncExecution);
        this.asyncFilter = asyncFilter;
        asyncFilter.setRubyRuntimeQueue(this.pool.getObjectQueue());
    }

    public RailsAdapter(String contextRoot, String railsRoot, String jrubyLib, int numRt, int minRuntime, int maxRuntime, boolean asyncExecution) {
        super(railsRoot);
        this.setHandleStaticResources(true);
        this.setRootFolder(railsRoot + "/public");
        this.contextRoot = contextRoot;
        RubyAdapter myAdapter = new RubyAdapter(railsRoot, jrubyLib);
        DynamicPoolConfig myConfig = new DynamicPoolConfig(numRt, -1, maxRuntime, minRuntime, -1, -1, -1, -1, asyncExecution, false);
        this.pool = new DynamicPool<Ruby>(myAdapter, myConfig);
        JRubyVersion jrubyVersion = new JRubyVersion();
        this.logger.log(Level.INFO, Messages.format("jruby.version", jrubyVersion));
        this.debugDispatchFilter = RailsAdapter.isDebugMode() ? this.getDebugDispatchFilter(jrubyVersion) : null;
        this.numThreads = jrubyVersion.compare("1.1.5") < 0 ? 1 : Math.min(Runtime.getRuntime().availableProcessors(), numRt);
    }

    private static boolean isDebugMode() {
        String rdebug = System.getProperty("glassfish.rdebug");
        return rdebug != null && rdebug.length() > 0;
    }

    void startRubyRuntimePool() {
        try {
            SelectorThread.logger().log(Level.INFO, Messages.format("rails.starting", new Object[0]));
            this.pool.start(this.numThreads);
        }
        catch (RaiseException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            RubyException re = e.getException();
            String rubyMessage = re.message.asJavaString();
            String message = Messages.format("rails.failed.load", rubyMessage) + "\n";
            RubyArray backtrace = (RubyArray)re.backtrace();
            for (Object aBacktrace : backtrace) {
                String traceLine = (String)aBacktrace;
                message = message + "\t" + traceLine + "\n";
            }
            this.getLogger().log(Level.SEVERE, message, e);
            throw e;
        }
    }

    void stopRubyRuntimePool() {
        this.pool.stop();
    }

    private void loadRuntimeEnvironment(Ruby runtime) {
        String logger;
        String root;
        if (!(this.contextRoot == null || this.contextRoot.equals("/") || (root = runtime.getGlobalVariables().get("$root").asString().asJavaString()) != null && root.equals(this.contextRoot))) {
            runtime.defineReadonlyVariable("$root", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)this.contextRoot));
        }
        if ((logger = runtime.getGlobalVariables().get("$logger").asString().asJavaString()) == null || logger.length() == 0) {
            IRubyObject loggerObj = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)new Logger(this.getLogger()));
            runtime.defineReadonlyVariable("$logger", loggerObj);
        }
        RubyHash env = (RubyHash)runtime.getObject().getConstant("ENV");
        if (this.environment.size() == 0) {
            this.environment.putAll(env);
        } else {
            env.clear();
            env.putAll(this.environment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        Ruby runtime = null;
        try {
            runtime = this.pool.borrowObject();
            if (runtime == null) {
                throw new IllegalStateException(Messages.format("jruby.runtime.notavailable", new Object[0]));
            }
            if (this.debugDispatchFilter != null) {
                this.debugDispatchFilter.dispatchRailsRequest(runtime, req, res);
            } else {
                this.dispatchRailsRequest(runtime, req, res);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (runtime != null) {
                this.pool.returnObject(runtime);
                if (this.asyncFilter != null) {
                    this.asyncFilter.resume();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyThread getContextThread(Ruby runtime) {
        RubyThread contextThread = null;
        Map<Ruby, WeakHashMap<Thread, RubyThread>> map = this.threadMaps;
        synchronized (map) {
            WeakHashMap<Thread, Object> threadMap = this.threadMaps.get(runtime);
            if (threadMap != null) {
                contextThread = threadMap.get(Thread.currentThread());
            } else {
                threadMap = new WeakHashMap();
                this.threadMaps.put(runtime, threadMap);
            }
            if (contextThread == null) {
                contextThread = RubyThread.adopt((IRubyObject)runtime.getThread(), (Thread)Thread.currentThread());
                threadMap.put(Thread.currentThread(), contextThread);
            }
        }
        return contextThread;
    }

    private DispatchFilter getDebugDispatchFilter(JRubyVersion version) {
        DispatchFilter filter = null;
        if (version.compare("1.4.0") < 0) {
            if (version.compare("1.3.0") >= 0) {
                filter = new DebugJRuby130();
            } else if (version.compare("1.2.0") >= 0) {
                filter = new DebugJRuby120();
            }
        }
        return filter;
    }

    private void dispatchRailsRequest(Ruby runtime, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        try {
            RailsOutputStream os = new RailsOutputStream(res);
            RubyIO iObj = new RubyIO(runtime, (InputStream)req.getInputStream());
            runtime.defineReadonlyVariable("$stdin", (IRubyObject)iObj);
            RubyIO oObj = new RubyIO(runtime, (OutputStream)os);
            runtime.defineReadonlyVariable("$stdout", (IRubyObject)oObj);
            this.loadRuntimeEnvironment(runtime);
            Object[] args = new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)req), JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)res)};
            IRubyObject responder = runtime.getGlobalVariables().get("$responder");
            JavaEmbedUtils.invokeMethod((Ruby)runtime, (Object)responder, (String)"service", (Object[])args, IRubyObject.class);
        }
        catch (RaiseException e) {
            this.getLogger().log(Level.SEVERE, e.getLocalizedMessage(), e);
            RubyException exception = e.getException();
            exception.printBacktrace(System.err);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(String uri, Request req, Response res) throws Exception {
        if (this.contextRoot != null && uri.startsWith(this.contextRoot)) {
            uri = uri.substring(this.contextRoot.length());
        }
        FileInputStream fis = null;
        try {
            int rd;
            this.webDir = this.findWebDir();
            File resource = this.getStaticResource(uri);
            if (!resource.exists()) {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, Messages.format("static.file.notfound", resource));
                }
                res.setStatus(404);
                this.customizedErrorPage(req, res);
                return;
            }
            res.setStatus(200);
            int dot = uri.lastIndexOf(".");
            if (dot > 0) {
                String ext = uri.substring(dot + 1);
                String ct = MimeType.get((String)ext);
                if (ct != null) {
                    res.setContentType(ct);
                }
            } else {
                res.setContentType(MimeType.get((String)"html"));
            }
            res.setContentLength((int)resource.length());
            res.sendHeaders();
            fis = new FileInputStream(resource);
            byte[] b = new byte[8192];
            ByteChunk chunk = new ByteChunk();
            while ((rd = fis.read(b)) > 0) {
                chunk.setBytes(b, 0, rd);
                res.doWrite(chunk);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, "Error closeing static file stream! " + ex);
                }
            }
        }
        res.setCommitted(true);
    }

    private File getStaticResource(String uri) {
        File resource = this.cache.get(uri);
        if (resource == null) {
            resource = new File(this.webDir, uri);
            this.cache.put(uri, resource);
        }
        if (resource.isDirectory()) {
            resource = new File(resource, "index.html");
            this.cache.put(uri, resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findWebDir() {
        if (this.webDir == null) {
            this.initializedLock.lock();
            try {
                this.webDir = new File(this.getRootFolder());
                try {
                    this.setRootFolder(this.webDir.getCanonicalPath());
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "service()", e);
                }
            }
            finally {
                this.initializedLock.unlock();
            }
        }
        return this.webDir;
    }

    private class DebugJRuby120
    extends DispatchFilter {
        private Method tsAssociateThread;
        private Method tsUnregisterThread;

        private DebugJRuby120() {
            this.tsAssociateThread = null;
            this.tsUnregisterThread = null;
        }

        protected void init(Ruby runtime) {
            Class<?> tsClass = runtime.getThreadService().getClass();
            this.tsAssociateThread = this.getMethod(tsClass, "associateThread", Object.class, RubyThread.class);
            this.tsUnregisterThread = this.getMethod(tsClass, "unregisterThread", RubyThread.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchRailsRequestImpl(Ruby runtime, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
            RubyThread context = RailsAdapter.this.getContextThread(runtime);
            try {
                this.invoke(this.tsAssociateThread, runtime.getThreadService(), Thread.currentThread(), context);
                RailsAdapter.this.dispatchRailsRequest(runtime, req, res);
            }
            catch (Throwable throwable) {
                this.invoke(this.tsUnregisterThread, runtime.getThreadService(), context);
                throw throwable;
            }
            this.invoke(this.tsUnregisterThread, runtime.getThreadService(), context);
        }
    }

    private class DebugJRuby130
    extends DispatchFilter {
        private Method tsAssociateThread;
        private Method tsDissociateThread;

        private DebugJRuby130() {
            this.tsAssociateThread = null;
            this.tsDissociateThread = null;
        }

        protected void init(Ruby runtime) {
            Class<?> tsClass = runtime.getThreadService().getClass();
            this.tsAssociateThread = this.getMethod(tsClass, "associateThread", Object.class, RubyThread.class);
            this.tsDissociateThread = this.getMethod(tsClass, "dissociateThread", Object.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchRailsRequestImpl(Ruby runtime, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
            RubyThread context = RailsAdapter.this.getContextThread(runtime);
            try {
                this.invoke(this.tsAssociateThread, runtime.getThreadService(), Thread.currentThread(), context);
                RailsAdapter.this.dispatchRailsRequest(runtime, req, res);
            }
            catch (Throwable throwable) {
                this.invoke(this.tsDissociateThread, runtime.getThreadService(), Thread.currentThread());
                throw throwable;
            }
            this.invoke(this.tsDissociateThread, runtime.getThreadService(), Thread.currentThread());
        }
    }

    abstract class DispatchFilter {
        private volatile boolean initialized = false;

        DispatchFilter() {
        }

        protected abstract void init(Ruby var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchRailsRequest(Ruby runtime, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
            if (!this.initialized) {
                DispatchFilter dispatchFilter = this;
                synchronized (dispatchFilter) {
                    if (!this.initialized) {
                        this.init(runtime);
                        this.initialized = true;
                    }
                }
            }
            this.dispatchRailsRequestImpl(runtime, req, res);
        }

        protected abstract void dispatchRailsRequestImpl(Ruby var1, GrizzlyRequest var2, GrizzlyResponse var3) throws IOException;

        protected Method getMethod(Class clazz, String methodName, Class ... args) {
            Method result = null;
            try {
                result = clazz.getDeclaredMethod(methodName, args);
            }
            catch (Exception ex) {
                String message = clazz.getSimpleName() + ".getMethod( " + methodName + " )";
                RailsAdapter.this.getLogger().log(Level.WARNING, message, ex);
                throw new RuntimeException(message, ex);
            }
            return result;
        }

        protected Object invoke(Method method, Object instance, Object ... args) {
            Object result = null;
            try {
                result = method.invoke(instance, args);
            }
            catch (Exception ex) {
                RailsAdapter.this.getLogger().log(Level.WARNING, method.getName() + ".invoke( ... )", ex);
            }
            return result;
        }
    }

    private static class JRubyVersion {
        private int major;
        private int minor;
        private int suffix;
        private String qualifier = "";

        public JRubyVersion() {
            this(Constants.VERSION);
        }

        private JRubyVersion(String version) {
            int i = version.lastIndexOf(46);
            if (i != -1) {
                block7: {
                    String v = version.substring(i + 1, version.length());
                    try {
                        this.suffix = Integer.parseInt(v);
                    }
                    catch (NumberFormatException e) {
                        int index = 0;
                        for (char c : v.toCharArray()) {
                            if (!Character.isDigit(c)) break;
                            ++index;
                        }
                        this.suffix = Integer.parseInt(v.substring(0, index));
                        if (index <= 0) break block7;
                        this.qualifier = v.substring(index, v.length());
                    }
                }
                int j = version.substring(0, i).lastIndexOf(46);
                if (j != -1) {
                    this.minor = Integer.parseInt(version.substring(j + 1, i));
                    this.major = j != 0 ? Integer.parseInt(version.substring(0, j)) : 0;
                } else {
                    this.minor = 0;
                    this.major = 1;
                }
            } else {
                this.suffix = 0;
                this.minor = 0;
                this.major = 0;
            }
        }

        public int compare(JRubyVersion version) {
            int result = this.major - version.major;
            if (result == 0 && (result = this.minor - version.minor) == 0) {
                result = this.suffix - version.suffix;
            }
            return result;
        }

        public int compare(String version) {
            return this.compare(new JRubyVersion(version));
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.suffix + this.qualifier;
        }
    }

    private static class Logger {
        private final java.util.logging.Logger logger;

        public Logger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        public void log(String msg) {
            this.logger.info(msg);
        }
    }
}

