/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.shared;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ContractProvider;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ArchiveFactory
implements ContractProvider {
    @Inject
    Habitat habitat;
    static final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    public WritableArchive createArchive(File path) throws IOException {
        try {
            return this.createArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public ReadableArchive openArchive(File path) throws IOException {
        try {
            return this.openArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public WritableArchive createArchive(URI path) throws IOException {
        String protocol = path.getScheme();
        try {
            WritableArchive archive = (WritableArchive)this.habitat.getComponent(WritableArchive.class, protocol);
            if (archive == null) {
                logger.log(Level.SEVERE, "Cannot find an archive implementation for " + protocol);
                throw new MalformedURLException("Protocol not supported : " + protocol);
            }
            archive.create(path);
            return archive;
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot find an archive implementation for " + protocol, e);
            throw new MalformedURLException("Protocol not supported : " + protocol);
        }
    }

    public ReadableArchive openArchive(URI path) throws IOException {
        String protocol = path.getScheme();
        try {
            ReadableArchive archive = (ReadableArchive)this.habitat.getComponent(ReadableArchive.class, protocol);
            if (archive == null) {
                logger.log(Level.SEVERE, "Cannot find an archive implementation for " + protocol);
                throw new MalformedURLException("Protocol not supported : " + protocol);
            }
            archive.open(path);
            return archive;
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot find an archive implementation for " + protocol, e);
            throw new MalformedURLException("Protocol not supported : " + protocol);
        }
    }

    static URI prepareArchiveURI(File path) throws URISyntaxException, UnsupportedEncodingException, IOException {
        URI archiveURI = path.toURI();
        String scheme = path.isDirectory() ? "file" : "jar";
        URI answer = new URI(scheme, null, archiveURI.getPath(), null, null);
        return answer;
    }
}

