/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.servlet;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.cometd.BayeuxCometHandler;
import com.sun.grizzly.cometd.CometdNotificationHandler;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.EventRouter;
import com.sun.grizzly.cometd.EventRouterImpl;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CometdServlet
extends HttpServlet {
    private static final long DEFAULT_EXPIRATION_DELAY = -1L;
    private String contextPath;
    private BayeuxCometHandler bayeuxCometHandler;
    private EventRouter eventRouter;
    private boolean initialized = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.contextPath = config.getInitParameter("contextPath");
        if (this.contextPath == null) {
            this.contextPath = config.getServletContext().getContextPath() + "/cometd";
        }
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext cometContext = cometEngine.register(this.contextPath);
        String expire = config.getInitParameter("expirationDelay");
        if (expire == null) {
            cometContext.setExpirationDelay(-1L);
        } else {
            cometContext.setExpirationDelay(Long.parseLong(expire));
        }
        cometContext.setBlockingNotification(true);
        cometContext.setNotificationHandler(new CometdNotificationHandler());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest hreq, HttpServletResponse hres) throws ServletException, IOException {
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext cometContext = cometEngine.getCometContext(this.contextPath);
        CometdRequest<HttpServletRequest> cometdReq = new CometdRequest<HttpServletRequest>(hreq){

            @Override
            public String[] getParameterValues(String s) {
                return ((HttpServletRequest)this.request).getParameterValues(s);
            }
        };
        CometdResponse<HttpServletResponse> cometdRes = new CometdResponse<HttpServletResponse>(hres){

            @Override
            public void write(String s) throws IOException {
                ((HttpServletResponse)this.response).getWriter().write(s);
            }

            @Override
            public void flush() throws IOException {
                ((HttpServletResponse)this.response).getWriter().flush();
            }

            @Override
            public void setContentType(String s) {
                ((HttpServletResponse)this.response).setContentType(s);
            }
        };
        if (!this.initialized) {
            CometContext cometContext2 = cometContext;
            synchronized (cometContext2) {
                if (!this.initialized) {
                    this.bayeuxCometHandler = new BayeuxCometHandler();
                    this.eventRouter = new EventRouterImpl(cometContext);
                    int mainHandlerHash = cometContext.addCometHandler(this.bayeuxCometHandler, true);
                    cometContext.addAttribute("bayeuxCometHandler", mainHandlerHash);
                    this.initialized = true;
                }
            }
        }
        this.eventRouter.route(cometdReq, cometdRes);
    }
}

