/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Image;
import java.io.File;
import java.io.IOException;

class DirAction
extends Action {
    Image img;
    String path = "";
    String owner = "";
    String group = "";
    String mode = "";

    DirAction(Image image, String[] tokens) {
        super(5);
        this.img = image;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].startsWith("owner=")) {
                this.owner = tokens[i].substring(6);
                continue;
            }
            if (tokens[i].startsWith("path=")) {
                this.path = tokens[i].substring(5);
                continue;
            }
            if (tokens[i].startsWith("mode=")) {
                this.mode = tokens[i].substring(5);
                continue;
            }
            if (!tokens[i].startsWith("group=")) continue;
            this.group = tokens[i].substring(6);
        }
    }

    void install(Action orig) throws IOException {
        File f = new File(this.img.getRootDirectory(), this.path);
        f.mkdirs();
        this.setPermissions(f, this.mode);
    }

    void remove() throws IOException {
        File target = new File(this.img.getRootDirectory(), this.path);
        this.setPermissions(target, "0644");
        target.delete();
    }

    String keyValue() {
        return this.path;
    }

    public String toString() {
        return "dir: path=" + this.path;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof DirAction)) {
            return true;
        }
        DirAction da = (DirAction)a;
        return !this.equals(a) || !this.owner.equals(da.owner) || !this.group.equals(da.group) || !this.mode.equals(da.mode);
    }
}

