/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.arp;

import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.arp.AsyncTask;
import com.sun.grizzly.http.ProcessorTask;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultAsyncExecutor
implements AsyncExecutor {
    private AsyncTask asyncProcessorTask;
    private ProcessorTask processorTask;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private AsyncHandler asyncHandler;

    public boolean preExecute() throws Exception {
        this.processorTask.preProcess();
        if (this.processorTask.parseRequest()) {
            this.finishResponse();
            return false;
        }
        return true;
    }

    public boolean interrupt() throws Exception {
        if (this.asyncFilters == null || this.asyncFilters.size() == 0) {
            this.execute();
            return false;
        }
        return this.invokeFilters();
    }

    public boolean execute() throws Exception {
        this.processorTask.invokeAdapter();
        return true;
    }

    private boolean invokeFilters() {
        AsyncFilter asf;
        boolean continueExec = true;
        Iterator<AsyncFilter> i$ = this.asyncFilters.iterator();
        while (i$.hasNext() && (continueExec = (asf = i$.next()).doFilter(this))) {
        }
        return continueExec;
    }

    private void finishResponse() throws Exception {
        this.processorTask.postProcess();
        this.processorTask.terminateProcess();
        this.processorTask = null;
    }

    public boolean postExecute() throws Exception {
        if (this.processorTask == null) {
            return false;
        }
        this.processorTask.postResponse();
        this.finishResponse();
        return false;
    }

    public void setAsyncTask(AsyncTask asyncProcessorTask) {
        this.asyncProcessorTask = asyncProcessorTask;
    }

    public AsyncTask getAsyncTask() {
        return this.asyncProcessorTask;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public void setProcessorTask(ProcessorTask task) {
        this.processorTask = task;
    }

    public ProcessorTask getProcessorTask() {
        return this.processorTask;
    }
}

