/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ActiveRAFactory;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.loader.EJBClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.naming.NamingException;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;

public class ResourceAdapterAdminServiceImpl
extends ConnectorService {
    private void destroyActiveResourceAdapter(String moduleName, boolean cascade) throws ConnectorRuntimeException {
        ResourcesUtil resutil = ResourcesUtil.createInstance();
        if (resutil == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to get ResourcesUtil object");
            _logger.log(Level.SEVERE, "rardeployment.resourcesutil_get_failure", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        if (!this.stopAndRemoveActiveResourceAdapter(moduleName)) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to remove Active Resource Adapter");
            _logger.log(Level.SEVERE, "rardeployment.ra_removal_registry_failure", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        try {
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
            _logger.fine("ResourceAdapterAdminServiceImpl :: destroyActiveRA " + moduleName + " removing descriptor " + descriptorJNDIName);
            this._runtime.getNamingManager().getInitialContext().unbind(descriptorJNDIName);
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to remove connector descriptor from JNDI");
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_jndi_removal_failure", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public synchronized void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir) throws ConnectorRuntimeException {
        _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir);
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        if (activeResourceAdapter != null) {
            _logger.log(Level.FINE, "rardeployment.resourceadapter.already.started", moduleName);
            return;
        }
        ClassLoader loader = null;
        try {
            loader = connectorDescriptor.getClassLoader();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "No classloader available with connector descriptor");
            loader = null;
        }
        ModuleDescriptor moduleDescriptor = null;
        Application application = null;
        _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " loader :: " + loader);
        if (loader == null) {
            if (environment == 1 && (loader = this.createRARClassLoader(moduleName, moduleDir)) == null) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to obtain the class loader");
                _logger.log(Level.SEVERE, "rardeployment.failed_toget_classloader");
                _logger.log(Level.SEVERE, "", cre);
                throw cre;
            }
        } else {
            connectorDescriptor.setClassLoader(null);
            moduleDescriptor = connectorDescriptor.getModuleDescriptor();
            application = connectorDescriptor.getApplication();
            connectorDescriptor.setModuleDescriptor(null);
            connectorDescriptor.setApplication(null);
        }
        try {
            activeResourceAdapter = ActiveRAFactory.createActiveResourceAdapter(connectorDescriptor, moduleName, loader);
            _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " adding to registry " + activeResourceAdapter);
            _registry.addActiveResourceAdapter(moduleName, activeResourceAdapter);
            _logger.fine("ResourceAdapterAdminServiceImpl:: createActiveRA " + moduleName + " at " + moduleDir + " env =server ? " + (environment == 1));
            if (environment == 1) {
                activeResourceAdapter.setup();
                String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
                _logger.fine("ResourceAdapterAdminServiceImpl :: createActiveRA " + moduleName + " at " + moduleDir + " publishing descriptor " + descriptorJNDIName);
                this._runtime.getNamingManager().publishObject(descriptorJNDIName, (Object)connectorDescriptor, true);
            }
        }
        catch (NullPointerException npEx) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
            cre.initCause((Throwable)npEx);
            _logger.log(Level.SEVERE, "rardeployment.nullPointerException", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Error in creating active RAR");
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "rardeployment.jndi_publish_failure");
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        finally {
            if (moduleDescriptor != null) {
                connectorDescriptor.setModuleDescriptor(moduleDescriptor);
                connectorDescriptor.setApplication(application);
                connectorDescriptor.setClassLoader(loader);
            }
        }
    }

    private ClassLoader createRARClassLoader(String moduleName, String moduleDir) {
        ClassLoaderHierarchy cls = (ClassLoaderHierarchy)Globals.getDefaultHabitat().getByContract(ClassLoaderHierarchy.class);
        ClassLoader parentCL = cls.getCommonClassLoader();
        EJBClassLoader cl = new EJBClassLoader(parentCL);
        File file = new File(moduleDir);
        try {
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, cl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return cl;
    }

    private void appendJars(File moduleDir, EJBClassLoader cl) throws MalformedURLException {
        if (moduleDir.isDirectory()) {
            for (File file : moduleDir.listFiles()) {
                if (file.getName().toUpperCase().endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }

    public synchronized void createActiveResourceAdapter(String moduleDir, String moduleName) throws ConnectorRuntimeException {
        ConnectorDescriptor connectorDescriptor;
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        if (activeResourceAdapter != null) {
            _logger.log(Level.FINE, "rardeployment.resourceadapter.already.started", moduleName);
            return;
        }
        if (ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            moduleDir = ConnectorsUtil.getSystemModuleLocation((String)moduleName);
        }
        if ((connectorDescriptor = ConnectorDDTransformUtils.getConnectorDescriptor(moduleDir)) == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to obtain the connectorDescriptor");
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        this.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir);
    }

    private boolean stopAndRemoveActiveResourceAdapter(String moduleName) {
        ActiveResourceAdapter acr = null;
        if (moduleName != null) {
            acr = _registry.getActiveResourceAdapter(moduleName);
        }
        if (acr != null) {
            acr.destroy();
            boolean status = _registry.removeActiveResourceAdapter(moduleName);
            return status;
        }
        return false;
    }

    public boolean isRarDeployed(String moduleName) {
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(moduleName);
        return activeResourceAdapter != null;
    }

    public void stopAllActiveResourceAdapters() {
        ActiveResourceAdapter[] resourceAdapters = ConnectorRegistry.getInstance().getAllActiveResourceAdapters();
        for (int i = 0; i < resourceAdapters.length; ++i) {
            String raName = resourceAdapters[i].getModuleName();
            this.stopActiveResourceAdapter(raName, true);
        }
    }

    public void stopActiveResourceAdapter(String raName, boolean cascade) {
        _logger.log(Level.FINE, "Stopping RA : ", raName);
        try {
            this.destroyActiveResourceAdapter(raName, cascade);
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, "unable to stop resource adapter [ " + raName + " ]", cre.getMessage());
            _logger.log(Level.FINE, "unable to stop resource adapter [ " + raName + " ]", cre);
        }
    }
}

