/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.rails.sniffer;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Which;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.scripting.rails.sniffer.Messages;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="rails")
@Scoped(value=Singleton.class)
public class RailsSniffer
implements Sniffer {
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry registry;
    private final String containerName = "jruby";
    private final String APPLICATION = "app/controllers/application.rb";
    private final String BOOT = "config/boot.rb";
    private final String ENVIRONMENT = "config/environment.rb";
    private final String[] containers = new String[]{"org.glassfish.scripting.rails.RailsContainer"};

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        try {
            if (location.exists("app/controllers/application.rb") || location.exists("config/boot.rb") || location.exists("config/environment.rb")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String[] getURLPatterns() {
        return null;
    }

    public Class<? extends Annotation>[] getAnnotationTypes() {
        return new Class[0];
    }

    public String getModuleType() {
        return "jruby";
    }

    public Module[] setup(String containerHome, Logger logger) throws IOException {
        File rootLocation = new File(containerHome);
        if (!rootLocation.exists()) {
            throw new RuntimeException(Messages.format("sniffer.jruby.home.not.found", rootLocation.getPath(), System.getProperty("com.sun.aas.installRoot") + File.separator + "domains" + File.separator + "domain1" + File.separator + "config" + File.separator + "domain.xml"));
        }
        Module grizzlyRails = this.registry.makeModuleFor("org.glassfish.scripting.grizzly-jruby-module", null);
        if (grizzlyRails == null) {
            String msg = Messages.format("sniffer.jrubymodule.notfound", Which.jarFile(this.getClass()).toURI().toString());
            logger.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        return new Module[]{grizzlyRails};
    }

    public void tearDown() {
    }

    public String[] getContainersNames() {
        return this.containers;
    }

    public boolean isUserVisible() {
        return true;
    }

    public Map<String, String> getDeploymentConfigurations(ReadableArchive readableArchive) throws IOException {
        return Collections.EMPTY_MAP;
    }
}

