/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.OptionsMap;
import com.sun.enterprise.cli.framework.ValidCommand;
import java.util.Arrays;
import java.util.Vector;

public class CommandFactory {
    public static Command createCommand(ValidCommand commandMatched, OptionsMap options, Vector operands) throws CommandValidationException, InvalidCommandException {
        Command command = null;
        String commandName = commandMatched.getName();
        String className = commandMatched.getClassName();
        if (className == null) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new InvalidCommandException(commandName);
        }
        try {
            Class<?> theClass = CommandFactory.class.getClassLoader().loadClass(className);
            command = (Command)theClass.newInstance();
            command.setName(commandName);
            command.setOptionsMap(options);
            command.setOperands(CommandFactory.determineOperand(operands, commandMatched.getDefaultOperand()));
            command.setUsageText(commandMatched.getUsageText());
            command.setProperties(commandMatched.getProperties());
        }
        catch (Throwable e) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("UnableToCreateCommand", new Object[]{commandName}), e);
        }
        return command;
    }

    private static Vector determineOperand(Vector operands, String defaultOperand) {
        return operands.size() < 1 && defaultOperand != null ? new Vector<String>(Arrays.asList(defaultOperand)) : operands;
    }
}

