/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.util.DummyCallFlowAgentImpl;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.EntityManagerQueryMethod;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;

public class QueryWrapper
implements Query {
    private transient CallFlowAgent callFlowAgent;
    private Query queryDelegate;
    private EntityManager entityManagerDelegate;
    private EntityManagerFactory entityMgrFactory;
    private Map entityMgrProperties;
    private QueryType queryType;
    private String queryString;
    private Class queryResultClass;
    private String queryResultSetMapping;
    private List<SetterData> setterInvocations;

    public static Query createQueryWrapper(EntityManagerFactory emf, Map emProperties, EntityManager emDelegate, Query queryDelegate, String ejbqlString) {
        return new QueryWrapper(emf, emProperties, emDelegate, queryDelegate, QueryType.EJBQL, ejbqlString, null, null);
    }

    public static Query createNamedQueryWrapper(EntityManagerFactory emf, Map emProperties, EntityManager emDelegate, Query queryDelegate, String name) {
        return new QueryWrapper(emf, emProperties, emDelegate, queryDelegate, QueryType.NAMED, name, null, null);
    }

    public static Query createNativeQueryWrapper(EntityManagerFactory emf, Map emProperties, EntityManager emDelegate, Query queryDelegate, String sqlString) {
        return new QueryWrapper(emf, emProperties, emDelegate, queryDelegate, QueryType.NATIVE, sqlString, null, null);
    }

    public static Query createNativeQueryWrapper(EntityManagerFactory emf, Map emProperties, EntityManager emDelegate, Query queryDelegate, String sqlString, Class resultClass) {
        return new QueryWrapper(emf, emProperties, emDelegate, queryDelegate, QueryType.NATIVE, sqlString, resultClass, null);
    }

    public static Query createNativeQueryWrapper(EntityManagerFactory emf, Map emProperties, EntityManager emDelegate, Query queryDelegate, String sqlString, String resultSetMapping) {
        return new QueryWrapper(emf, emProperties, emDelegate, queryDelegate, QueryType.NATIVE, sqlString, null, resultSetMapping);
    }

    private QueryWrapper(EntityManagerFactory emf, Map emProperties, EntityManager emDelegate, Query qDelegate, QueryType type, String query, Class resultClass, String resultSetMapping) {
        this.entityMgrFactory = emf;
        this.entityMgrProperties = emProperties;
        this.entityManagerDelegate = emDelegate;
        this.queryDelegate = qDelegate;
        this.queryType = type;
        this.queryString = query;
        this.queryResultClass = resultClass;
        this.queryResultSetMapping = resultSetMapping;
        this.setterInvocations = new LinkedList<SetterData>();
        this.callFlowAgent = new DummyCallFlowAgentImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getResultList() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_RESULT_LIST);
            }
            Query delegate = this.getQueryDelegate();
            List list = delegate.getResultList();
            return list;
        }
        finally {
            this.clearDelegates();
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleResult() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_SINGLE_RESULT);
            }
            Query delegate = this.getQueryDelegate();
            Object object = delegate.getSingleResult();
            return object;
        }
        finally {
            this.clearDelegates();
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public int executeUpdate() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.EXECUTE_UPDATE);
            this.callFlowAgent.entityManagerQueryEnd();
        }
        throw new TransactionRequiredException("executeUpdate is not supported for a Query object obtained through non-transactional access of a container-managed transactional EntityManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setMaxResults(int maxResults) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_MAX_RESULTS);
            }
            if (maxResults < 0) {
                throw new IllegalArgumentException("maxResult cannot be negative");
            }
            Query delegate = this.getQueryDelegate();
            delegate.setMaxResults(maxResults);
            SetterData setterData = SetterData.createMaxResults(maxResults);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setFirstResult(int startPosition) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_FIRST_RESULT);
            }
            if (startPosition < 0) {
                throw new IllegalArgumentException("startPosition cannot be negative");
            }
            Query delegate = this.getQueryDelegate();
            delegate.setFirstResult(startPosition);
            SetterData setterData = SetterData.createFirstResult(startPosition);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setHint(String hintName, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_HINT);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setHint(hintName, value);
            SetterData setterData = SetterData.createHint(hintName, value);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(String name, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_STRING_OBJECT);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setParameter(name, value);
            SetterData setterData = SetterData.createParameter(name, value);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(String name, Date value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_STRING_DATE_TEMPORAL_TYPE);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setParameter(name, value, temporalType);
            SetterData setterData = SetterData.createParameter(name, value, temporalType);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_STRING_CALENDAR_TEMPORAL_TYPE);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setParameter(name, value, temporalType);
            SetterData setterData = SetterData.createParameter(name, value, temporalType);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(int position, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_INT_OBJECT);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setParameter(position, value);
            SetterData setterData = SetterData.createParameter(position, value);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(int position, Date value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_INT_DATE_TEMPORAL_TYPE);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setParameter(position, value, temporalType);
            SetterData setterData = SetterData.createParameter(position, value, temporalType);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_INT_CALENDAR_TEMPORAL_TYPE);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setParameter(position, value, temporalType);
            SetterData setterData = SetterData.createParameter(position, value, temporalType);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setFlushMode(FlushModeType flushMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_FLUSH_MODE);
            }
            Query delegate = this.getQueryDelegate();
            delegate.setFlushMode(flushMode);
            SetterData setterData = SetterData.createFlushMode(flushMode);
            this.setterInvocations.add(setterData);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    private void clearDelegates() {
        this.queryDelegate = null;
        if (this.entityManagerDelegate != null) {
            this.entityManagerDelegate.close();
            this.entityManagerDelegate = null;
        }
    }

    private Query getQueryDelegate() {
        if (this.queryDelegate == null) {
            this.entityManagerDelegate = this.entityMgrFactory.createEntityManager(this.entityMgrProperties);
            switch (this.queryType) {
                case EJBQL: {
                    this.queryDelegate = this.entityManagerDelegate.createQuery(this.queryString);
                    break;
                }
                case NAMED: {
                    this.queryDelegate = this.entityManagerDelegate.createNamedQuery(this.queryString);
                    break;
                }
                case NATIVE: {
                    this.queryDelegate = this.queryResultClass != null ? this.entityManagerDelegate.createNativeQuery(this.queryString, this.queryResultClass) : (this.queryResultSetMapping != null ? this.entityManagerDelegate.createNativeQuery(this.queryString, this.queryResultSetMapping) : this.entityManagerDelegate.createNativeQuery(this.queryString));
                }
            }
            for (SetterData setterData : this.setterInvocations) {
                setterData.apply(this.queryDelegate);
            }
        }
        return this.queryDelegate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QueryType {
        EJBQL,
        NAMED,
        NATIVE;

    }

    private static class SetterData {
        SetterType type;
        int int1;
        String string1;
        Object object1;
        Date date;
        Calendar calendar;
        TemporalType temporalType;
        FlushModeType flushMode;

        private SetterData() {
        }

        static SetterData createMaxResults(int maxResults) {
            SetterData data = new SetterData();
            data.type = SetterType.MAX_RESULTS;
            data.int1 = maxResults;
            return data;
        }

        static SetterData createFirstResult(int firstResult) {
            SetterData data = new SetterData();
            data.type = SetterType.FIRST_RESULT;
            data.int1 = firstResult;
            return data;
        }

        static SetterData createHint(String hintName, Object value) {
            SetterData data = new SetterData();
            data.type = SetterType.HINT;
            data.string1 = hintName;
            data.object1 = value;
            return data;
        }

        static SetterData createParameter(String name, Object value) {
            SetterData data = new SetterData();
            data.type = SetterType.PARAM_NAME_OBJECT;
            data.string1 = name;
            data.object1 = value;
            return data;
        }

        static SetterData createParameter(String name, Date value, TemporalType temporalType) {
            SetterData data = new SetterData();
            data.type = SetterType.PARAM_NAME_DATE_TEMPORAL;
            data.string1 = name;
            data.date = value;
            data.temporalType = temporalType;
            return data;
        }

        static SetterData createParameter(String name, Calendar value, TemporalType temporalType) {
            SetterData data = new SetterData();
            data.type = SetterType.PARAM_NAME_CAL_TEMPORAL;
            data.string1 = name;
            data.calendar = value;
            data.temporalType = temporalType;
            return data;
        }

        static SetterData createParameter(int position, Object value) {
            SetterData data = new SetterData();
            data.type = SetterType.PARAM_POSITION_OBJECT;
            data.int1 = position;
            data.object1 = value;
            return data;
        }

        static SetterData createParameter(int position, Date value, TemporalType temporalType) {
            SetterData data = new SetterData();
            data.type = SetterType.PARAM_POSITION_DATE_TEMPORAL;
            data.int1 = position;
            data.date = value;
            data.temporalType = temporalType;
            return data;
        }

        static SetterData createParameter(int position, Calendar value, TemporalType temporalType) {
            SetterData data = new SetterData();
            data.type = SetterType.PARAM_POSITION_CAL_TEMPORAL;
            data.int1 = position;
            data.calendar = value;
            data.temporalType = temporalType;
            return data;
        }

        static SetterData createFlushMode(FlushModeType flushMode) {
            SetterData data = new SetterData();
            data.type = SetterType.FLUSH_MODE;
            data.flushMode = flushMode;
            return data;
        }

        void apply(Query query) {
            switch (this.type) {
                case MAX_RESULTS: {
                    query.setMaxResults(this.int1);
                    break;
                }
                case FIRST_RESULT: {
                    query.setFirstResult(this.int1);
                    break;
                }
                case HINT: {
                    query.setHint(this.string1, this.object1);
                    break;
                }
                case PARAM_NAME_OBJECT: {
                    query.setParameter(this.string1, this.object1);
                    break;
                }
                case PARAM_NAME_DATE_TEMPORAL: {
                    query.setParameter(this.string1, this.date, this.temporalType);
                    break;
                }
                case PARAM_NAME_CAL_TEMPORAL: {
                    query.setParameter(this.string1, this.calendar, this.temporalType);
                    break;
                }
                case PARAM_POSITION_OBJECT: {
                    query.setParameter(this.int1, this.object1);
                    break;
                }
                case PARAM_POSITION_DATE_TEMPORAL: {
                    query.setParameter(this.int1, this.date, this.temporalType);
                    break;
                }
                case PARAM_POSITION_CAL_TEMPORAL: {
                    query.setParameter(this.int1, this.calendar, this.temporalType);
                    break;
                }
                case FLUSH_MODE: {
                    query.setFlushMode(this.flushMode);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SetterType {
        MAX_RESULTS,
        FIRST_RESULT,
        HINT,
        PARAM_NAME_OBJECT,
        PARAM_NAME_DATE_TEMPORAL,
        PARAM_NAME_CAL_TEMPORAL,
        PARAM_POSITION_OBJECT,
        PARAM_POSITION_DATE_TEMPORAL,
        PARAM_POSITION_CAL_TEMPORAL,
        FLUSH_MODE;

    }
}

