/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

public class ResultSetDataModel
extends DataModel {
    private int index = -1;
    private ResultSetMetaData metadata = null;
    private ResultSet resultSet = null;
    private boolean updated = false;

    public ResultSetDataModel() {
        this(null);
    }

    public ResultSetDataModel(ResultSet resultSet) {
        this.setWrappedData(resultSet);
    }

    public boolean isRowAvailable() {
        if (this.resultSet == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        try {
            return this.resultSet.absolute(this.index + 1);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    public int getRowCount() {
        return -1;
    }

    public Object getRowData() {
        if (this.resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        try {
            this.getMetaData();
            return new ResultSetMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        if (this.updated && this.resultSet != null) {
            try {
                if (!this.resultSet.rowDeleted()) {
                    this.resultSet.updateRow();
                }
                this.updated = false;
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.resultSet == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.resultSet;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.metadata = null;
            this.resultSet = null;
            this.setRowIndex(-1);
        } else {
            this.metadata = null;
            this.resultSet = (ResultSet)data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }

    private ResultSetMetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = this.resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        return this.metadata;
    }

    private void updated() {
        this.updated = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetEntries
    extends AbstractSet<Map.Entry<String, Object>> {
        private ResultSetMap map;

        public ResultSetEntries(ResultSetMap map) {
            this.map = map;
        }

        @Override
        public boolean add(Map.Entry<String, Object> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new ResultSetEntriesIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetEntriesIterator
    implements Iterator<Map.Entry<String, Object>> {
        private ResultSetMap map = null;
        private Iterator<String> keys = null;

        public ResultSetEntriesIterator(ResultSetMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            String key = this.keys.next();
            return new ResultSetEntry(this.map, key);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetEntry
    implements Map.Entry<String, Object> {
        private ResultSetMap map;
        private String key;

        public ResultSetEntry(ResultSetMap map, String key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            Object v = this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.map.get(this.key);
        }

        @Override
        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public Object setValue(Object value) {
            Object previous = this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetKeys
    extends AbstractSet<String> {
        private ResultSetMap map;

        public ResultSetKeys(ResultSetMap map) {
            this.map = map;
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new ResultSetKeysIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetKeysIterator
    implements Iterator<String> {
        private Iterator<String> keys = null;

        public ResultSetKeysIterator(ResultSetMap map) {
            this.keys = map.realKeys();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public String next() {
            return this.keys.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultSetMap
    extends TreeMap<String, Object> {
        private int index;

        public ResultSetMap(Comparator<String> comparator) throws SQLException {
            super(comparator);
            this.index = ResultSetDataModel.this.index;
            ResultSetDataModel.this.resultSet.absolute(this.index + 1);
            int n = ResultSetDataModel.this.metadata.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                super.put(ResultSetDataModel.this.metadata.getColumnName(i), ResultSetDataModel.this.metadata.getColumnName(i));
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            for (Map.Entry<String, Object> entry : this.entrySet()) {
                Object contained = entry.getValue();
                if (!(value == null ? contained == null : value.equals(contained))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new ResultSetEntries(this);
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                return null;
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(this.index + 1);
                return ResultSetDataModel.this.resultSet.getObject((String)this.realKey(key));
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }

        @Override
        public Set<String> keySet() {
            return new ResultSetKeys(this);
        }

        @Override
        public Object put(String key, Object value) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(this.index + 1);
                Object previous = ResultSetDataModel.this.resultSet.getObject((String)this.realKey(key));
                if (previous == null && value == null) {
                    return previous;
                }
                if (previous != null && value != null && previous.equals(value)) {
                    return previous;
                }
                ResultSetDataModel.this.resultSet.updateObject((String)this.realKey(key), value);
                ResultSetDataModel.this.updated();
                return previous;
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            return new ResultSetValues(this);
        }

        Object realKey(Object key) {
            return super.get(key);
        }

        Iterator<String> realKeys() {
            return super.keySet().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetValues
    extends AbstractCollection<Object> {
        private ResultSetMap map;

        public ResultSetValues(ResultSetMap map) {
            this.map = map;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Iterator<Object> iterator() {
            return new ResultSetValuesIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultSetValuesIterator
    implements Iterator<Object> {
        private ResultSetMap map;
        private Iterator<String> keys;

        public ResultSetValuesIterator(ResultSetMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Object next() {
            return this.map.get(this.keys.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

