/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeHandle;

public class Probe
implements ProbeHandle {
    private int id;
    private String moduleName;
    private String probeName;
    private String appName;
    private String providerName;
    private String[] probeParamNames;
    private Class[] paramTypes;
    private List<ProbeClientInvoker> invokerList = new ArrayList<ProbeClientInvoker>(2);
    private String providerJavaMethodName;
    private AtomicBoolean enabled = new AtomicBoolean(false);
    private String probeStr;

    public Probe(int id, String moduleName, String providerName, String appName, String probeName, String[] probeParamNames, Class[] paramTypes) {
        this.id = id;
        this.moduleName = moduleName;
        this.providerName = providerName;
        this.appName = appName == null ? "" : appName;
        this.probeName = probeName;
        this.probeParamNames = probeParamNames;
        this.paramTypes = paramTypes;
        this.probeStr = moduleName + ":" + providerName + ":" + this.appName + ":" + probeName;
    }

    public synchronized void addInvoker(ProbeClientInvoker invoker) {
        this.invokerList.add(invoker);
        this.enabled.set(true);
    }

    public synchronized void removeInvoker(ProbeClientInvoker invoker) {
        this.invokerList.remove(invoker);
        this.enabled.set(this.invokerList.size() > 0);
    }

    public void fireProbe(Object[] params) {
        for (ProbeClientInvoker invoker : this.invokerList) {
            invoker.invoke(params);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public int getId() {
        return this.id;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getProbeName() {
        return this.probeName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String[] getProbeParamNames() {
        return this.probeParamNames;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String getProviderJavaMethodName() {
        return this.providerJavaMethodName;
    }

    public void setProviderJavaMethodName(String providerJavaMethodName) {
        this.providerJavaMethodName = providerJavaMethodName;
    }

    public String getProbeStr() {
        return this.probeStr;
    }

    public String toString() {
        StringBuilder sbldr = new StringBuilder(this.moduleName + ":" + this.providerName + ":" + this.appName + ":" + this.probeName);
        sbldr.append(" ").append(this.providerJavaMethodName).append("(");
        String delim = "";
        for (Class c : this.paramTypes) {
            sbldr.append(delim).append(c.getName());
            delim = ", ";
        }
        sbldr.append(")");
        return sbldr.toString();
    }
}

