/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.collections.CollectionUtils;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GFLauncher {
    private GFLauncherInfo info;
    private Map<String, String> asenvProps;
    private JavaConfig javaConfig;
    private JvmOptions jvmOptions;
    private Profiler profiler;
    private Map<String, String> sysPropsFromXml;
    private String javaExe;
    private String classpath;
    private List<String> debugOptions;
    private List<String> commandLine;
    private long startTime;
    private String logFilename;
    private LaunchType mode = LaunchType.normal;
    private static final String JAVA_NATIVE_SYSPROP_NAME = "java.library.path";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final LocalStringsImpl strings = new LocalStringsImpl(GFLauncher.class);
    private boolean setupCalledByClients = false;

    public final GFLauncherInfo getInfo() {
        return this.info;
    }

    public final synchronized void launch() throws GFLauncherException {
        try {
            this.startTime = System.currentTimeMillis();
            if (!this.setupCalledByClients) {
                this.setup();
            }
            this.internalLaunch();
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException(strings.get("unknownError", new Object[]{t.getMessage()}), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public final synchronized void setup() throws GFLauncherException, MiniXmlParserException {
        ASenvPropertyReader pr = this.isFakeLaunch() ? new ASenvPropertyReader(this.info.getInstallDir()) : new ASenvPropertyReader();
        this.asenvProps = pr.getProps();
        this.info.setup();
        this.setupLogLevels();
        MiniXmlParser parser = new MiniXmlParser(this.getInfo().getConfigFile(), this.getInfo().getInstanceName());
        String domainName = parser.getDomainName();
        if (GFLauncherUtils.ok((String)domainName)) {
            this.info.setDomainName(domainName);
        }
        this.info.setAdminPorts(parser.getAdminPorts());
        this.javaConfig = new JavaConfig(parser.getJavaConfig());
        this.setupProfilerAndJvmOptions(parser);
        this.sysPropsFromXml = parser.getSystemProperties();
        this.asenvProps.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getPath());
        this.debugOptions = this.getDebug();
        this.logFilename = parser.getLogFilename();
        this.resolveAllTokens();
        GFLauncherLogger.addLogFileHandler(this.logFilename);
        this.setJavaExecutable();
        this.setClasspath();
        this.setCommandLine();
        this.logCommandLine();
        this.setupCalledByClients = true;
    }

    abstract void internalLaunch() throws GFLauncherException;

    void setMode(LaunchType mode) {
        this.mode = mode;
    }

    LaunchType getMode() {
        return this.mode;
    }

    boolean isFakeLaunch() {
        return this.mode == LaunchType.fake;
    }

    abstract List<File> getMainClasspath() throws GFLauncherException;

    abstract String getMainClass() throws GFLauncherException;

    GFLauncher(GFLauncherInfo info) {
        this.info = info;
    }

    final Map<String, String> getEnvProps() {
        return this.asenvProps;
    }

    final List<String> getCommandLine() {
        return this.commandLine;
    }

    final long getStartTime() {
        return this.startTime;
    }

    void launchInstance() throws GFLauncherException, MiniXmlParserException {
        Process process;
        if (this.isFakeLaunch()) {
            return;
        }
        List<String> cmds = this.getCommandLine();
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.directory(this.getInfo().getConfigDir());
        try {
            process = pb.start();
            if (this.getInfo().isVerbose()) {
                ProcessStreamDrainer.redirect((String)this.getInfo().getDomainName(), (Process)process);
            } else {
                ProcessStreamDrainer.drain((String)this.getInfo().getDomainName(), (Process)process);
            }
        }
        catch (IOException e) {
            throw new GFLauncherException("jvmfailure", (Throwable)e, e);
        }
        long endTime = System.currentTimeMillis();
        GFLauncherLogger.info("launchTime", endTime - this.getStartTime());
        if (this.getInfo().isVerbose()) {
            this.wait(process);
        }
    }

    private void wait(Process p) throws GFLauncherException {
        try {
            this.setShutdownHook(p);
            p.waitFor();
        }
        catch (InterruptedException ex) {
            throw new GFLauncherException("verboseInterruption", (Throwable)ex, ex);
        }
    }

    private void setShutdownHook(final Process p) {
        final String msg = strings.get("serverStopped", new Object[]{this.info.getType()});
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println(msg);
                p.destroy();
            }
        });
    }

    private void setCommandLine() throws GFLauncherException {
        this.commandLine = new ArrayList<String>();
        this.commandLine.add(this.javaExe);
        this.commandLine.add("-cp");
        this.commandLine.add(this.classpath);
        this.commandLine.addAll(this.debugOptions);
        this.commandLine.addAll(this.jvmOptions.toStringArray());
        this.commandLine.addAll(this.getNativePathCommandLine());
        this.commandLine.add(this.getMainClass());
        this.commandLine.addAll(this.getInfo().getArgsAsList());
    }

    private void resolveAllTokens() {
        HashMap<String, String> all = new HashMap<String, String>();
        Map<String, String> envProps = System.getenv();
        Map sysProps = CollectionUtils.propertiesToStringMap((Properties)System.getProperties());
        all.putAll(envProps);
        all.putAll(this.asenvProps);
        all.putAll(sysProps);
        all.putAll(this.sysPropsFromXml);
        all.putAll(this.jvmOptions.getCombinedMap());
        all.putAll(this.profiler.getConfig());
        TokenResolver resolver = new TokenResolver(all);
        resolver.resolve(this.jvmOptions.xProps);
        resolver.resolve(this.jvmOptions.xxProps);
        resolver.resolve(this.jvmOptions.plainProps);
        resolver.resolve(this.jvmOptions.sysProps);
        resolver.resolve(this.javaConfig.getMap());
        resolver.resolve(this.profiler.getConfig());
        resolver.resolve(this.debugOptions);
        this.logFilename = resolver.resolve(this.logFilename);
    }

    private void setJavaExecutable() throws GFLauncherException {
        if (this.setJavaExecutableIfValid(this.javaConfig.getJavaHome())) {
            return;
        }
        if (!this.setJavaExecutableIfValid(this.asenvProps.get("com.sun.aas.javaRoot"))) {
            throw new GFLauncherException("nojvm");
        }
    }

    private void setClasspath() throws GFLauncherException {
        List<File> mainCP = this.getMainClasspath();
        List<File> envCP = this.javaConfig.getEnvClasspath();
        List<File> sysCP = this.javaConfig.getSystemClasspath();
        List<File> prefixCP = this.javaConfig.getPrefixClasspath();
        List<File> suffixCP = this.javaConfig.getSuffixClasspath();
        List<File> profilerCP = this.profiler.getClasspath();
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(prefixCP);
        all.addAll(profilerCP);
        all.addAll(mainCP);
        all.addAll(sysCP);
        all.addAll(envCP);
        all.addAll(suffixCP);
        this.classpath = GFLauncherUtils.fileListToPathString(all);
    }

    private boolean setJavaExecutableIfValid(String filename) {
        if (!GFLauncherUtils.ok((String)filename)) {
            return false;
        }
        File f = new File(filename);
        if (!f.isDirectory()) {
            return false;
        }
        f = GFLauncherUtils.isWindows() ? new File(f, "bin/java.exe") : new File(f, "bin/java");
        if (f.exists()) {
            this.javaExe = SmartFile.sanitize((File)f).getPath();
            return true;
        }
        return false;
    }

    private List<String> getDebug() {
        if (this.info.isDebug() || this.javaConfig.isDebugEnabled()) {
            return this.javaConfig.getDebugOptions();
        }
        return Collections.emptyList();
    }

    private void setupProfilerAndJvmOptions(MiniXmlParser parser) throws MiniXmlParserException, GFLauncherException {
        this.profiler = new Profiler(parser.getProfilerConfig(), parser.getProfilerJvmOptions(), parser.getProfilerSystemProperties());
        List rawJvmOptions = parser.getJvmOptions();
        rawJvmOptions.addAll(this.getSpecialSystemProperties());
        if (this.profiler.isEnabled()) {
            rawJvmOptions.addAll(this.profiler.getJvmOptions());
        }
        this.jvmOptions = new JvmOptions(rawJvmOptions);
    }

    private List<String> getSpecialSystemProperties() throws GFLauncherException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.aas.installRoot", this.getInfo().getInstallDir().getAbsolutePath());
        props.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getAbsolutePath());
        return this.propsToJvmOptions(props);
    }

    private List<String> getNativePathCommandLine() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.profiler.isEnabled()) {
            return list;
        }
        List<File> profilerNativeFiles = this.profiler.getNativePath();
        if (profilerNativeFiles.size() <= 0) {
            return list;
        }
        List nativeFiles = GFLauncherUtils.stringToFiles((String)System.getProperty(JAVA_NATIVE_SYSPROP_NAME));
        nativeFiles.addAll(profilerNativeFiles);
        String nativeCommand = "-Djava.library.path=";
        nativeCommand = nativeCommand + GFLauncherUtils.fileListToPathString((List)nativeFiles);
        list.add(nativeCommand);
        return list;
    }

    private void logCommandLine() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.commandLine) {
            sb.append(NEWLINE);
            sb.append(s);
        }
        if (!this.isFakeLaunch()) {
            GFLauncherLogger.info("commandline", sb.toString());
        }
    }

    private List<String> propsToJvmOptions(Map<String, String> map) {
        ArrayList<String> ss = new ArrayList<String>();
        Set<String> set = map.keySet();
        for (String name : set) {
            String value = map.get(name);
            String jvm = "-D" + name;
            if (value != null) {
                jvm = jvm + "=" + value;
            }
            ss.add(jvm);
        }
        return ss;
    }

    private void setupLogLevels() {
        if (this.info.isVerbose()) {
            GFLauncherLogger.setConsoleLevel(Level.INFO);
        } else {
            GFLauncherLogger.setConsoleLevel(Level.WARNING);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LaunchType {
        normal,
        debug,
        trace,
        fake;

    }
}

