/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.corba.se.impl.orbutil.threadpool.ThreadPoolManagerImpl;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class ConnectorsUtil {
    public static boolean belongsToSystemRA(String raName) {
        boolean result = false;
        for (String systemRarName : ConnectorConstants.systemRarNames) {
            if (!systemRarName.equals(raName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getSystemModuleLocation(String moduleName) {
        String j2eeModuleDirName = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + moduleName;
        return j2eeModuleDirName;
    }

    public static String getLocation(String moduleName) {
        return null;
    }

    public static String getPMJndiName(String jndiName) {
        return jndiName + "__pm";
    }

    public static String getValidSuffix(String name) {
        if (name != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!name.endsWith(validSuffix)) continue;
                return validSuffix;
            }
        }
        return null;
    }

    public static boolean isValidJndiSuffix(String suffix) {
        if (suffix != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!validSuffix.equals(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static String deriveJndiName(String name, Hashtable env) {
        String suffix = (String)env.get("com.sun.enterprise.connectors.jndisuffix");
        if (ConnectorsUtil.isValidJndiSuffix(suffix)) {
            return name + suffix;
        }
        return name;
    }

    public static boolean isValidEventType(Object instance) {
        return instance instanceof JdbcConnectionPool || instance instanceof JdbcResource || instance instanceof ConnectorConnectionPool || instance instanceof ConnectorResource;
    }

    public static ThreadPool getThreadPool(String threadPoolId) throws NoSuchThreadPoolException, ConnectorRuntimeException {
        ThreadPoolManager tpm = ConnectorsUtil.getThreadPoolManager();
        if (threadPoolId != null) {
            return tpm.getThreadPool(threadPoolId);
        }
        return tpm.getDefaultThreadPool();
    }

    private static ThreadPoolManager getThreadPoolManager() throws ConnectorRuntimeException {
        try {
            Constructor defaultConstructor = ThreadPoolManagerImpl.class.getConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return (ThreadPoolManager)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Constructor threadGroupParamConstructor = ThreadPoolManagerImpl.class.getConstructor(ThreadGroup.class);
            threadGroupParamConstructor.setAccessible(true);
            Object tg = null;
            return (ThreadPoolManager)threadGroupParamConstructor.newInstance(tg);
        }
        catch (Exception e) {
            throw new ConnectorRuntimeException("unable to provide thread pool manager");
        }
    }
}

