/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.jruby.HttpHeaderParser;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;
import java.io.OutputStream;

class RailsOutputStream
extends OutputStream {
    private final GrizzlyOutputStream gos;
    private final GrizzlyResponse grizzlyResponse;
    private boolean headerParsed = false;

    public RailsOutputStream(GrizzlyResponse grizzlyResponse) throws IOException {
        this.grizzlyResponse = grizzlyResponse;
        this.grizzlyResponse.reset();
        this.gos = grizzlyResponse.getOutputStream();
    }

    public void write(int b) throws IOException {
        this.gos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.gos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.headerParsed && (b[0] >= 65 && b[0] <= 90 || b[0] >= 97 && b[0] <= 122)) {
            HttpHeaderParser parser = new HttpHeaderParser(this.grizzlyResponse);
            int pos = parser.parseHeaders(b, off, len);
            if (this.grizzlyResponse.getStatus() != 304) {
                if (pos <= len) {
                    this.gos.write(b, pos, len - pos);
                } else {
                    this.gos.write(b, off, len);
                }
            }
            this.headerParsed = true;
        } else {
            this.gos.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        this.gos.flush();
    }

    public void close() throws IOException {
        this.gos.close();
    }
}

