/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.cache.JarContent;
import org.apache.felix.framework.util.JarFileX;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IContent;

class JarRevision
extends BundleRevision {
    private static final transient String BUNDLE_JAR_FILE = "bundle.jar";
    private File m_bundleFile = null;

    public JarRevision(Logger logger, File revisionRootDir, String location, boolean byReference) throws Exception {
        this(logger, revisionRootDir, location, byReference, null);
    }

    public JarRevision(Logger logger, File revisionRootDir, String location, boolean byReference, InputStream is) throws Exception {
        super(logger, revisionRootDir, location);
        this.m_bundleFile = byReference ? new File(location.substring(location.indexOf("file:") + "file:".length())) : new File(this.getRevisionRootDir(), BUNDLE_JAR_FILE);
        this.initialize(byReference, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map getManifestHeader() throws Exception {
        JarFileX jarFile = null;
        try {
            jarFile = BundleCache.getSecureAction().openJAR(this.m_bundleFile);
            if (jarFile == null) {
                throw new IOException("No JAR file found.");
            }
            Manifest mf = jarFile.getManifest();
            StringMap stringMap = new StringMap(mf.getMainAttributes(), false);
            return stringMap;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    public synchronized IContent getContent() throws Exception {
        return new JarContent(this.getLogger(), this, this.getRevisionRootDir(), this.m_bundleFile, true);
    }

    public void dispose() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean byReference, InputStream is) throws Exception {
        try {
            if (BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) {
                return;
            }
            if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
                this.getLogger().log(1, this.getClass().getName() + ": Unable to create revision directory.");
                throw new IOException("Unable to create archive directory.");
            }
            if (!byReference) {
                if (is == null) {
                    URL url = new URL(this.getLocation());
                    URLConnection conn = url.openConnection();
                    String auth = BundleCache.getSecureAction().getSystemProperty("http.proxyAuth", null);
                    if (auth != null && auth.length() > 0 && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                        String base64 = Util.base64Encode(auth);
                        conn.setRequestProperty("Proxy-Authorization", "Basic " + base64);
                    }
                    is = BundleCache.getSecureAction().getURLConnectionInputStream(conn);
                }
                BundleCache.copyStreamToFile(is, this.m_bundleFile);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

