/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class QueryHintsHandler {
    public static void verify(Map hints, String queryName, AbstractSession session) {
        if (hints == null) {
            return;
        }
        for (Map.Entry entry : hints.entrySet()) {
            String hintName = (String)entry.getKey();
            QueryHintsHandler.verify(hintName, entry.getValue(), queryName, session);
        }
    }

    public static void verify(String hintName, Object hintValue, String queryName, AbstractSession session) {
        Hint.verify(hintName, QueryHintsHandler.shouldUseDefault(hintValue), hintValue, queryName, session);
    }

    public static DatabaseQuery apply(Map hints, DatabaseQuery query) {
        if (hints == null) {
            return query;
        }
        DatabaseQuery hintQuery = query;
        for (Map.Entry entry : hints.entrySet()) {
            String hintName = (String)entry.getKey();
            hintQuery = QueryHintsHandler.apply(hintName, entry.getValue(), hintQuery);
        }
        return hintQuery;
    }

    public static DatabaseQuery apply(String hintName, Object hintValue, DatabaseQuery query) {
        return Hint.apply(hintName, QueryHintsHandler.shouldUseDefault(hintValue), hintValue, query);
    }

    protected static boolean shouldUseDefault(Object hintValue) {
        return hintValue != null && hintValue instanceof String && ((String)hintValue).length() == 0;
    }

    protected static class BatchHint
    extends Hint {
        BatchHint() {
            super("eclipselink.batch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            ExpressionBuilder expression;
            ReadAllQuery raq;
            if (query.isReadAllQuery() && !query.isReportQuery()) {
                raq = (ReadAllQuery)query;
                StringTokenizer tokenizer = new StringTokenizer((String)valueToApply, ".");
                if (tokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens((DatabaseQuery)query, (String)"eclipselink.join-fetch", (Object)valueToApply);
                }
                String previousToken = tokenizer.nextToken();
                ClassDescriptor descriptor = raq.getDescriptor();
                expression = raq.getExpressionBuilder();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ForeignReferenceMapping frMapping = null;
                    DatabaseMapping mapping = descriptor.getMappingForAttributeName(token);
                    if (mapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship((DatabaseQuery)query, (String)"eclipselink.batch", (Object)valueToApply, (String)(previousToken + "." + token));
                    }
                    if (!mapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship((DatabaseQuery)query, (String)"eclipselink.batch", (Object)valueToApply, (String)(previousToken + "." + token));
                    }
                    frMapping = (ForeignReferenceMapping)mapping;
                    descriptor = frMapping.getReferenceDescriptor();
                    expression = frMapping.isCollectionMapping() ? expression.anyOf(token) : expression.get(token);
                    previousToken = token;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-type-for-query-hint", (Object[])new Object[]{BatchHint.getQueryId(query), this.name, BatchHint.getPrintValue(valueToApply)}));
            }
            raq.addBatchReadAttribute((Expression)expression);
            return query;
        }
    }

    protected static class BindParametersHint
    extends Hint {
        BindParametersHint() {
            super("eclipselink.jdbc.bind-parameters", "PersistenceUnitDefault");
            this.valueArray = new Object[][]{{"PersistenceUnitDefault", null}, {"True", Boolean.TRUE}, {"False", Boolean.FALSE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (valueToApply == null) {
                query.ignoreBindAllParameters();
            } else {
                query.setShouldBindAllParameters(((Boolean)valueToApply).booleanValue());
            }
            return query;
        }
    }

    protected static class CacheUsageHint
    extends Hint {
        CacheUsageHint() {
            super("eclipselink.cache-usage", "UseEntityDefault");
            this.valueArray = new Object[][]{{"UseEntityDefault", -1}, {"DoNotCheckCache", 0}, {"CheckCacheByExactPrimaryKey", 1}, {"CheckCacheByPrimaryKey", 2}, {"CheckCacheThenDatabase", 3}, {"CheckCacheOnly", 4}, {"ConformResultsInUnitOfWork", 5}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectLevelReadQuery()) {
                int cacheUsage = (Integer)valueToApply;
                ((ObjectLevelReadQuery)query).setCacheUsage(cacheUsage);
                if (cacheUsage == 1 || cacheUsage == 2 || cacheUsage == 3) {
                    ReadObjectQuery newQuery = new ReadObjectQuery();
                    newQuery.copyFromQuery(query);
                    return newQuery;
                }
            }
            return query;
        }
    }

    protected static class CascadePolicyHint
    extends Hint {
        CascadePolicyHint() {
            super("eclipselink.refresh.cascade", "CascadeByMapping");
            this.valueArray = new Object[][]{{"NoCascading", 1}, {"CascadePrivateParts", 2}, {"CascadeAllParts", 3}, {"CascadeByMapping", 6}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectLevelReadQuery()) {
                query.setCascadePolicy(((Integer)valueToApply).intValue());
            }
            return query;
        }
    }

    protected static class FetchHint
    extends Hint {
        FetchHint() {
            super("eclipselink.join-fetch", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            ExpressionBuilder expression;
            ObjectLevelReadQuery olrq;
            if (query.isObjectLevelReadQuery() && !query.isReportQuery()) {
                olrq = (ObjectLevelReadQuery)query;
                StringTokenizer tokenizer = new StringTokenizer((String)valueToApply, ".");
                if (tokenizer.countTokens() < 2) {
                    throw QueryException.queryHintDidNotContainEnoughTokens((DatabaseQuery)query, (String)"eclipselink.batch", (Object)valueToApply);
                }
                String previousToken = tokenizer.nextToken();
                ClassDescriptor descriptor = olrq.getDescriptor();
                expression = olrq.getExpressionBuilder();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ForeignReferenceMapping frMapping = null;
                    DatabaseMapping mapping = descriptor.getMappingForAttributeName(token);
                    if (mapping == null) {
                        throw QueryException.queryHintNavigatedNonExistantRelationship((DatabaseQuery)query, (String)"eclipselink.batch", (Object)valueToApply, (String)(previousToken + "." + token));
                    }
                    if (!mapping.isForeignReferenceMapping()) {
                        throw QueryException.queryHintNavigatedIllegalRelationship((DatabaseQuery)query, (String)"eclipselink.batch", (Object)valueToApply, (String)(previousToken + "." + token));
                    }
                    frMapping = (ForeignReferenceMapping)mapping;
                    descriptor = frMapping.getReferenceDescriptor();
                    expression = frMapping.isCollectionMapping() ? expression.anyOf(token) : expression.get(token);
                    previousToken = token;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-type-for-query-hint", (Object[])new Object[]{FetchHint.getQueryId(query), this.name, FetchHint.getPrintValue(valueToApply)}));
            }
            olrq.addJoinedAttribute((Expression)expression);
            return query;
        }
    }

    protected static abstract class Hint {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        Object defaultValueToApply;
        boolean valueToApplyMayBeNull;

        Hint(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        abstract DatabaseQuery applyToDatabaseQuery(Object var1, DatabaseQuery var2);

        static void verify(String hintName, boolean shouldUseDefault, Object hintValue, String queryName, AbstractSession session) {
            Hint hint = (Hint)mainMap.get(hintName);
            if (hint == null) {
                if (session != null) {
                    session.log(1, "query", "unknown_query_hint", new Object[]{Hint.getPrintValue(queryName), hintName});
                }
                return;
            }
            hint.verify(hintValue, shouldUseDefault, queryName, session);
        }

        void verify(Object hintValue, boolean shouldUseDefault, String queryName, AbstractSession session) {
            if (shouldUseDefault) {
                hintValue = this.defaultValue;
            }
            if (session != null) {
                session.log(1, "query", "query_hint", new Object[]{Hint.getPrintValue(queryName), this.name, Hint.getPrintValue(hintValue)});
            }
            if (!shouldUseDefault && this.valueMap != null && !this.valueMap.containsKey(Hint.getUpperCaseString(hintValue))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-query-hint-value", (Object[])new Object[]{Hint.getPrintValue(queryName), this.name, Hint.getPrintValue(hintValue)}));
            }
        }

        static DatabaseQuery apply(String hintName, boolean shouldUseDefault, Object hintValue, DatabaseQuery query) {
            Hint hint = (Hint)mainMap.get(hintName);
            if (hint == null) {
                return query;
            }
            return hint.apply(hintValue, shouldUseDefault, query);
        }

        DatabaseQuery apply(Object hintValue, boolean shouldUseDefault, DatabaseQuery query) {
            String key;
            Object valueToApply = hintValue;
            if (shouldUseDefault) {
                valueToApply = this.defaultValueToApply;
            } else if (this.valueMap != null && (valueToApply = this.valueMap.get(key = Hint.getUpperCaseString(hintValue))) == null) {
                boolean wrongKey = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl = wrongKey = !this.valueMap.containsKey(key);
                }
                if (wrongKey) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-query-hint-value", (Object[])new Object[]{Hint.getQueryId(query), this.name, Hint.getPrintValue(hintValue)}));
                }
            }
            return this.applyToDatabaseQuery(valueToApply, query);
        }

        static String getQueryId(DatabaseQuery query) {
            String queryId = query.getName();
            if (queryId == null) {
                queryId = query.getEJBQLString();
            }
            return Hint.getPrintValue(queryId);
        }

        static String getPrintValue(Object hintValue) {
            return hintValue != null ? hintValue.toString() : "null";
        }

        static String getUpperCaseString(Object hintValue) {
            return hintValue != null ? hintValue.toString().toUpperCase() : null;
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] valueArray2 = (Object[][])this.valueArray;
                    for (int i = 0; i < valueArray2.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(valueArray2[i][0]), valueArray2[i][1]);
                        if (valueArray2[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Hint.getUpperCaseString(this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = this.valueMap.get(this.defaultValue.toUpperCase());
            }
        }

        static void addHint(Hint hint) {
            hint.initialize();
            mainMap.put(hint.name, hint);
        }

        static {
            Hint.addHint(new BindParametersHint());
            Hint.addHint(new CacheUsageHint());
            Hint.addHint(new QueryTypeHint());
            Hint.addHint(new PessimisticLockHint());
            Hint.addHint(new RefreshHint());
            Hint.addHint(new CascadePolicyHint());
            Hint.addHint(new BatchHint());
            Hint.addHint(new FetchHint());
            Hint.addHint(new ReturnSharedHint());
            Hint.addHint(new JDBCTimeoutHint());
            Hint.addHint(new JDBCFetchSizeHint());
            Hint.addHint(new JDBCMaxRowsHint());
            Hint.addHint(new ResultCollectionTypeHint());
            Hint.addHint(new RedirectorHint());
        }
    }

    protected static class JDBCFetchSizeHint
    extends Hint {
        JDBCFetchSizeHint() {
            super("eclipselink.jdbc.fetch-size", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isReadQuery()) {
                try {
                    ((ReadQuery)query).setFetchSize(Integer.parseInt(valueToApply.toString()));
                }
                catch (NumberFormatException e) {
                    throw QueryException.queryHintContainedInvalidIntegerValue((String)"eclipselink.jdbc.fetch-size", (Object)valueToApply, (Exception)e);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-type-for-query-hint", (Object[])new Object[]{JDBCFetchSizeHint.getQueryId(query), this.name, JDBCFetchSizeHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class JDBCMaxRowsHint
    extends Hint {
        JDBCMaxRowsHint() {
            super("eclipselink.jdbc.max-rows", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isReadQuery()) {
                try {
                    ((ReadQuery)query).setMaxRows(Integer.parseInt(valueToApply.toString()));
                }
                catch (NumberFormatException e) {
                    throw QueryException.queryHintContainedInvalidIntegerValue((String)"eclipselink.jdbc.max-rows", (Object)valueToApply, (Exception)e);
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-type-for-query-hint", (Object[])new Object[]{JDBCMaxRowsHint.getQueryId(query), this.name, JDBCMaxRowsHint.getPrintValue(valueToApply)}));
            }
            return query;
        }
    }

    protected static class JDBCTimeoutHint
    extends Hint {
        JDBCTimeoutHint() {
            super("eclipselink.jdbc.timeout", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            try {
                query.setQueryTimeout(Integer.parseInt(valueToApply.toString()));
            }
            catch (NumberFormatException e) {
                throw QueryException.queryHintContainedInvalidIntegerValue((String)"eclipselink.jdbc.timeout", (Object)valueToApply, (Exception)e);
            }
            return query;
        }
    }

    protected static class PessimisticLockHint
    extends Hint {
        PessimisticLockHint() {
            super("eclipselink.pessimistic-lock", "NoLock");
            this.valueArray = new Object[][]{{"NoLock", (short)0}, {"Lock", (short)1}, {"LockNoWait", (short)2}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectBuildingQuery()) {
                ((ObjectBuildingQuery)query).setLockMode(((Short)valueToApply).shortValue());
            }
            return query;
        }
    }

    protected static class QueryTypeHint
    extends Hint {
        QueryTypeHint() {
            super("eclipselink.query-type", "Auto");
            this.valueArray = new Object[][]{{"Auto", "Auto"}, {"ReadAll", "ReadAll"}, {"ReadObject", "ReadObject"}, {"Report", "Report"}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectLevelReadQuery()) {
                if (valueToApply == "ReadAll") {
                    ReadAllQuery newQuery = new ReadAllQuery();
                    newQuery.copyFromQuery(query);
                    return newQuery;
                }
                if (valueToApply == "ReadObject") {
                    ReadObjectQuery newQuery = new ReadObjectQuery();
                    newQuery.copyFromQuery(query);
                    return newQuery;
                }
                if (valueToApply == "Report") {
                    ReportQuery newQuery = new ReportQuery();
                    newQuery.copyFromQuery(query);
                    return newQuery;
                }
            }
            return query;
        }
    }

    protected static class RedirectorHint
    extends Hint {
        RedirectorHint() {
            super("eclipselink.query.redirector", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            try {
                query.setRedirector((QueryRedirector)valueToApply);
            }
            catch (ClassCastException ex) {
                throw QueryException.unableToSetRedirectorOnQueryFromHint((DatabaseQuery)query, (String)"eclipselink.query.redirector", (String)valueToApply.getClass().getName(), (Exception)ex);
            }
            return query;
        }
    }

    protected static class RefreshHint
    extends Hint {
        RefreshHint() {
            super("eclipselink.refresh", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (query.isObjectBuildingQuery()) {
                ((ObjectBuildingQuery)query).setShouldRefreshIdentityMapResult(((Boolean)valueToApply).booleanValue());
            }
            return query;
        }
    }

    protected static class ResultCollectionTypeHint
    extends Hint {
        ResultCollectionTypeHint() {
            super("eclipselink.result-collection-type", "");
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            Class collectionClass;
            if (query.isReadAllQuery()) {
                collectionClass = null;
                if (valueToApply instanceof String) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                collectionClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName((String)valueToApply));
                            }
                            catch (PrivilegedActionException exception) {
                                throw QueryException.classNotFoundWhileUsingQueryHint((DatabaseQuery)query, (Object)valueToApply, (Exception)exception.getException());
                            }
                        }
                        collectionClass = PrivilegedAccessHelper.getClassForName((String)((String)valueToApply));
                    }
                    catch (ClassNotFoundException exc) {
                        throw QueryException.classNotFoundWhileUsingQueryHint((DatabaseQuery)query, (Object)valueToApply, (Exception)exc);
                    }
                } else {
                    collectionClass = (Class)valueToApply;
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-type-for-query-hint", (Object[])new Object[]{ResultCollectionTypeHint.getQueryId(query), this.name, ResultCollectionTypeHint.getPrintValue(valueToApply)}));
            }
            ((ReadAllQuery)query).useCollectionClass(collectionClass);
            return query;
        }
    }

    protected static class ReturnSharedHint
    extends Hint {
        ReturnSharedHint() {
            super("eclipselink.read-only", "False");
            this.valueArray = new Object[][]{{"False", Boolean.FALSE}, {"True", Boolean.TRUE}};
        }

        DatabaseQuery applyToDatabaseQuery(Object valueToApply, DatabaseQuery query) {
            if (!query.isObjectLevelReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"ejb30-wrong-type-for-query-hint", (Object[])new Object[]{ReturnSharedHint.getQueryId(query), this.name, ReturnSharedHint.getPrintValue(valueToApply)}));
            }
            ((ObjectLevelReadQuery)query).setIsReadOnly(((Boolean)valueToApply).booleanValue());
            return query;
        }
    }
}

