/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import org.glassfish.deployapi.ProgressObjectImpl;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.RemoteDeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.client.TargetOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentFacility
implements DeploymentFacility,
TargetOwner {
    private static final String DEFAULT_SERVER_NAME = "server";
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoteDeploymentFacility.class);
    private boolean connected;
    private TargetImpl domain;
    private ServerConnectionIdentifier targetDAS;

    protected abstract DFCommandRunner getDFCommandRunner(String var1, Map<String, Object> var2, String[] var3) throws CommandException;

    protected DFProgressObject changeState(Target[] targets, String moduleID, String commandName, String successStatusKey, String successStatusDefaultMessage, String failureStatusKey, String failureStatusDefaultMessage) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, null, new String[]{moduleID});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString(successStatusKey, successStatusDefaultMessage, new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    protected abstract boolean doConnect();

    @Override
    public boolean connect(ServerConnectionIdentifier targetDAS) {
        this.connected = true;
        this.targetDAS = targetDAS;
        this.domain = new TargetImpl(this, "domain", localStrings.getLocalString("enterprise.deployment.client.administrative_domain", "administrative-domain"));
        return this.doConnect();
    }

    protected abstract boolean doDisconnect();

    @Override
    public boolean disconnect() {
        this.connected = false;
        this.domain = null;
        this.targetDAS = null;
        return this.doDisconnect();
    }

    @Override
    public DFProgressObject createAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported in v3 prelude");
    }

    @Override
    public Target createTarget(String name) {
        return new TargetImpl(this, name, "");
    }

    @Override
    public Target[] createTargets(String[] targets) {
        Target[] result = new TargetImpl[targets.length];
        int i = 0;
        for (String name : targets) {
            result[i++] = new TargetImpl(this, name, "");
        }
        return result;
    }

    @Override
    public DFProgressObject deleteAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported in v3 prelude");
    }

    @Override
    public DFProgressObject deploy(Target[] targets, URI source, URI deploymentPlan, Map deploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        if (source == null) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_specified", "Archive to be deployed is not specified at all."), this.domain);
            return po;
        }
        File tmpFile = new File(source);
        if (!tmpFile.exists()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_in_location", "Unable to find the archive to be deployed in specified location."), this.domain);
            return po;
        }
        if (!tmpFile.canRead()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_no_read_permission", "Archive to be deployed does not have read permission."), this.domain);
            return po;
        }
        boolean isDirectoryDeploy = tmpFile.isDirectory();
        try {
            DFCommandRunner commandRunner;
            DFDeploymentStatus ds;
            DFDeploymentStatus mainStatus;
            if (deploymentPlan != null) {
                File dp = new File(deploymentPlan);
                if (!dp.exists()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_not_in_location", "Unable to find the deployment plan in specified location."), this.domain);
                    return po;
                }
                if (!dp.canRead()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_no_read_permission", "Deployment plan does not have read permission."), this.domain);
                    return po;
                }
                deploymentOptions.put("deploymentplan", dp.getAbsolutePath());
            }
            if ((mainStatus = (ds = (commandRunner = this.getDFCommandRunner("deploy", deploymentOptions, new String[]{tmpFile.getAbsolutePath()})).run()).getMainStatus()).getStatus() != DFDeploymentStatus.Status.FAILURE) {
                String moduleID = mainStatus.getProperty("name");
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application", "Deployment of application {0}", new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0}", new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0} ", new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    @Override
    public DFProgressObject disable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "disable", "enterprise.deployment.client.disable_application", "Application {0} disabled successfully", "enterprise.deployment.client.disable_application_failed", "Attempt to disable application {0} failed");
    }

    @Override
    public String downloadFile(File location, String moduleID, String moduleURI) throws IOException {
        throw new UnsupportedOperationException("Not supported in v3 prelude");
    }

    @Override
    public DFProgressObject enable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "enable", "enterprise.deployment.client.enable_application", "Application {0} enabled successfully", "enterprise.deployment.client.enable_application_failed", "Attempt to enable application {0} failed");
    }

    private void ensureConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.client.disconnected_state", "Not connected to the Domain Admin Server"));
        }
    }

    @Override
    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets) throws IOException {
        throw new UnsupportedOperationException("Not supported in v3 prelude");
    }

    private Target[] prepareTargets(Target[] targets) {
        if (targets == null || targets.length == 0) {
            targets = new Target[]{this.targetForDefaultServer()};
        }
        return targets;
    }

    private Target targetForDefaultServer() {
        TargetImpl t = new TargetImpl(this, DEFAULT_SERVER_NAME, localStrings.getLocalString("enterprise.deployment.client.default_server_description", "default server"));
        return t;
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID) {
        return this.undeploy(targets, moduleID, null);
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID, Map undeploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner("undeploy", undeploymentOptions, new String[]{moduleID});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application", "Undeployment of application {0}", new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    @Override
    public DFDeploymentStatus waitFor(DFProgressObject po) {
        return po.waitFor();
    }

    @Override
    public String getWebURL(TargetModuleID tmid) {
        throw new UnsupportedOperationException("Not supported for v3 prelude");
    }

    protected ServerConnectionIdentifier getTargetDAS() {
        return this.targetDAS;
    }

    public static interface DFCommandRunner {
        public DFDeploymentStatus run() throws CommandException;
    }
}

