/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EmbeddedIdAccessor
extends EmbeddedAccessor {
    protected HashMap<String, DatabaseField> m_idFields = new HashMap();

    public EmbeddedIdAccessor() {
        super("<embedded-id>");
    }

    public EmbeddedIdAccessor(Annotation embeddedId, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(embeddedId, accessibleObject, classAccessor);
    }

    public void process() {
        if (this.getOwningDescriptor().hasEmbeddedIdAttribute()) {
            throw ValidationException.multipleEmbeddedIdAnnotationsFound((Class)this.getJavaClass(), (String)this.getAttributeName(), (String)this.getOwningDescriptor().getEmbeddedIdAttributeName());
        }
        if (this.getOwningDescriptor().hasPrimaryKeyFields()) {
            throw ValidationException.embeddedIdAndIdAnnotationFound((Class)this.getJavaClass(), (String)this.getAttributeName(), (String)this.getOwningDescriptor().getIdAttributeName());
        }
        super.process();
        this.getOwningDescriptor().setPKClass(this.getReferenceClass());
        this.getOwningDescriptor().setEmbeddedIdAttributeName(this.getAttributeName());
        if (this.getReferenceDescriptor().getMappings().isEmpty()) {
            EmbeddedAccessor.AccessType accessType = this.getReferenceDescriptor().usesPropertyAccess() ? EmbeddedAccessor.AccessType.PROPERTY : EmbeddedAccessor.AccessType.FIELD;
            throw ValidationException.embeddedIdHasNoAttributes((Class)this.getDescriptor().getJavaClass(), (Class)this.getReferenceDescriptor().getJavaClass(), (String)accessType.name());
        }
        for (DatabaseMapping mapping : this.getReferenceDescriptor().getMappings()) {
            if (mapping.isDirectToFieldMapping()) {
                if (this.m_idFields.containsKey(mapping.getAttributeName())) continue;
                this.m_idFields.put(mapping.getAttributeName(), mapping.getField());
                continue;
            }
            throw ValidationException.invalidMappingForEmbeddedId((String)this.getAttributeName(), (Class)this.getJavaClass(), (String)mapping.getAttributeName(), (Class)this.getReferenceDescriptor().getJavaClass());
        }
        for (DatabaseField field : this.m_idFields.values()) {
            if (this.getOwningDescriptor().getPrimaryKeyFieldNames().contains(field.getName())) continue;
            DatabaseField clone = (DatabaseField)field.clone();
            if (clone.getTableName().equals("")) {
                clone.setTable(this.getOwningDescriptor().getPrimaryTable());
            }
            this.getOwningDescriptor().addPrimaryKeyField(clone);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping mapping, AttributeOverrideMetadata attributeOverride) {
        super.processAttributeOverride(mapping, attributeOverride);
        this.m_idFields.put(attributeOverride.getName(), attributeOverride.getColumn().getDatabaseField());
    }
}

