/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ResponseUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ErrorReportValve;

class ApplicationDispatcherForward {
    private static Logger log = Logger.getLogger(ApplicationDispatcherForward.class.getName());
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    ApplicationDispatcherForward() {
    }

    static void commit(HttpServletRequest request, HttpServletResponse response, Context context, Wrapper wrapper) throws IOException, ServletException {
        boolean matchFound;
        ResponseFacade responseFacade = ApplicationDispatcherForward.getResponseFacade((ServletResponse)response);
        int statusCode = responseFacade.getStatus();
        Object exception = request.getAttribute("javax.servlet.error.exception");
        String errorReportValveClass = ((StandardHost)context.getParent()).getErrorReportValveClass();
        if (errorReportValveClass != null && statusCode >= 400 && exception == null && !(matchFound = ApplicationDispatcherForward.status(request, response, responseFacade, context, wrapper, statusCode))) {
            ApplicationDispatcherForward.serveDefaultErrorPage(request, response, responseFacade, statusCode);
        }
        if (statusCode < 400 || exception == null && errorReportValveClass != null) {
            try {
                PrintWriter writer = response.getWriter();
                writer.flush();
                writer.close();
            }
            catch (IllegalStateException e) {
                try {
                    ServletOutputStream stream = response.getOutputStream();
                    stream.flush();
                    stream.close();
                }
                catch (IllegalStateException f) {
                }
                catch (IOException f) {}
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static boolean status(HttpServletRequest request, HttpServletResponse response, ResponseFacade responseFacade, Context context, Wrapper wrapper, int statusCode) {
        if (!responseFacade.isError()) {
            return false;
        }
        boolean matchFound = false;
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage != null) {
            matchFound = true;
            String requestPath = (String)request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
            if (requestPath == null || !requestPath.equals(errorPage.getLocation())) {
                String message = RequestUtil.filter(responseFacade.getMessage());
                if (message == null) {
                    message = "";
                }
                ApplicationDispatcherForward.prepareRequestForDispatch(request, wrapper, errorPage.getLocation(), statusCode, message);
                ApplicationDispatcherForward.custom(request, response, responseFacade, errorPage, context);
            }
        } else {
            errorPage = ((StandardHost)context.getParent()).findErrorPage(statusCode);
            if (errorPage != null) {
                matchFound = true;
                try {
                    ApplicationDispatcherForward.serveErrorPage(response, errorPage, statusCode);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Exception processing " + errorPage, e);
                }
            }
        }
        return matchFound;
    }

    private static void custom(HttpServletRequest request, HttpServletResponse response, ResponseFacade responseFacade, ErrorPage errorPage, Context context) {
        try {
            if (response.isCommitted()) {
                ApplicationDispatcherForward.resetResponse(responseFacade);
            }
            ServletContext servletContext = context.getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IllegalStateException ise) {
            log.log(Level.WARNING, "Exception processing " + errorPage, ise);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Exception processing " + errorPage, t);
        }
    }

    private static void prepareRequestForDispatch(HttpServletRequest request, Wrapper errorServlet, String errorPageLocation, int errorCode, String errorMessage) {
        request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)1);
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        if (errorServlet != null) {
            request.setAttribute("javax.servlet.error.servlet_name", (Object)errorServlet.getName());
        }
        request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)errorPageLocation);
        request.setAttribute("javax.servlet.error.status_code", (Object)errorCode);
        request.setAttribute("javax.servlet.error.message", (Object)errorMessage);
    }

    private static void serveErrorPage(HttpServletResponse response, ErrorPage errorPage, int statusCode) throws Exception {
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        FileReader reader = null;
        BufferedInputStream istream = null;
        IOException ioe = null;
        String message = errorPage.getReason();
        if (message != null && !response.isCommitted()) {
            response.reset();
            response.setStatus(statusCode, message);
        }
        try {
            ostream = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            writer = response.getWriter();
        }
        if (writer != null) {
            reader = new FileReader(errorPage.getLocation());
            ioe = ResponseUtil.copy(reader, writer);
            try {
                reader.close();
            }
            catch (Throwable t) {}
        } else {
            istream = new BufferedInputStream(new FileInputStream(errorPage.getLocation()));
            ioe = ResponseUtil.copy(istream, ostream);
            try {
                istream.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static void serveDefaultErrorPage(HttpServletRequest request, HttpServletResponse response, ResponseFacade responseFacade, int statusCode) throws IOException, ServletException {
        if (response.isCommitted() || statusCode < 400 || responseFacade.getContentCount() > 0 || Boolean.TRUE.equals(request.getAttribute("org.glassfish.jsp.error_handled"))) {
            return;
        }
        String message = RequestUtil.filter(responseFacade.getMessage());
        if (message == null) {
            message = "";
        }
        String report = null;
        try {
            report = sm.getString("http." + statusCode, message);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (report == null) {
            return;
        }
        String responseContents = ErrorReportValve.makeErrorPage(statusCode, message, null, null, report, response);
        response.setLocale(sm.getResourceBundleLocale(response.getLocale()));
        try {
            response.setContentType("text/html");
            response.getWriter().write(responseContents);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Exception sending default error page", t);
        }
    }

    private static ResponseFacade getResponseFacade(ServletResponse response) {
        while (response instanceof ServletResponseWrapper) {
            response = ((ServletResponseWrapper)response).getResponse();
        }
        return (ResponseFacade)response;
    }

    private static void resetResponse(ResponseFacade responseFacade) {
        responseFacade.setSuspended(false);
        responseFacade.setAppCommitted(false);
    }
}

