/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.ldap;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.felix.framework.util.ldap.AttributeNotFoundException;
import org.apache.felix.framework.util.ldap.EvaluationException;
import org.apache.felix.framework.util.ldap.LdapLexer;
import org.apache.felix.framework.util.ldap.Mapper;
import org.apache.felix.framework.util.ldap.Operator;
import org.apache.felix.framework.util.ldap.ParseException;

public class Parser {
    public static final int EOF = -1;
    public static final char LPAREN = '(';
    public static final char RPAREN = ')';
    public static final char STAR = '*';
    public static final int SIMPLE = 0;
    public static final int PRESENT = 1;
    public static final int SUBSTRING = 2;
    public static final int NOOP = 0;
    public static final int EQUAL = 0;
    public static final int GREATER_EQUAL = 1;
    public static final int LESS_EQUAL = 2;
    public static final int APPROX = 3;
    public static final int APPROX_CRITERIA = 10;
    private static boolean m_hasBigDecimal = false;
    private static final Class[] STRING_CLASS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Parser.class$("java.lang.String")) : class$java$lang$String};
    private LdapLexer lexer = null;
    private List program;
    static boolean debug;
    PrintStream dbgout = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Comparable;

    public Parser() {
        this.reset();
    }

    public Parser(LdapLexer l) {
        this.reset(l);
    }

    public void reset() {
        this.lexer = null;
        if (this.program == null) {
            this.program = new ArrayList();
        }
        this.program.clear();
    }

    public void reset(LdapLexer l) {
        this.reset();
        this.lexer = l;
    }

    public Object[] getProgram() {
        return this.program.toArray(new Object[this.program.size()]);
    }

    public boolean start() throws ParseException, IOException {
        boolean ok = this.filter();
        if (!ok) {
            return ok;
        }
        int ch = this.lexer.get();
        if (ch != -1) {
            throw new ParseException("expected <EOF>; found '" + (char)ch + "'");
        }
        return ok;
    }

    boolean filter() throws ParseException, IOException {
        this.debug("filter");
        if (this.lexer.peeknw() != 40) {
            return false;
        }
        this.lexer.get();
        if (!this.filtercomp()) {
            throw new ParseException("expected filtercomp");
        }
        if (this.lexer.getnw() != 41) {
            throw new ParseException("expected )");
        }
        return true;
    }

    boolean filtercomp() throws ParseException, IOException {
        this.debug("filtercomp");
        int c = this.lexer.peeknw();
        switch (c) {
            case 38: 
            case 124: {
                this.lexer.get();
                int cnt = this.filterlist();
                if (cnt == 0) {
                    return this.item(c == 38 ? "&" : "|");
                }
                this.program.add(c == 38 ? new AndOperator(cnt) : new OrOperator(cnt));
                return true;
            }
            case 33: {
                this.lexer.get();
                if (!this.filter()) {
                    return this.item("!");
                }
                this.program.add(new NotOperator());
                return true;
            }
            case -1: 
            case 40: 
            case 41: 
            case 60: 
            case 61: 
            case 62: 
            case 126: {
                return false;
            }
        }
        return this.item("");
    }

    int filterlist() throws ParseException, IOException {
        this.debug("filterlist");
        int cnt = 0;
        if (this.filter()) {
            do {
                ++cnt;
            } while (this.filter());
        }
        return cnt;
    }

    boolean item(String start) throws ParseException, IOException {
        this.debug("item");
        StringBuffer attr = new StringBuffer(start);
        if (!this.attribute(attr)) {
            return false;
        }
        this.lexer.skipwhitespace();
        int op = this.equalop();
        if (op == 0) {
            String oplist = "=|~=|>=|<=";
            throw new ParseException("expected " + oplist);
        }
        ArrayList pieces = new ArrayList();
        int kind = this.substring(pieces);
        if (op != 61 && kind != 0) {
            throw new ParseException("expected value|substring|*");
        }
        block0 : switch (kind) {
            case 0: {
                if (op == 61 && "objectClass".equalsIgnoreCase(attr.toString())) {
                    this.program.add(new ObjectClassOperator((String)pieces.get(0)));
                    return true;
                }
                this.program.add(new PushOperator(attr.toString()));
                this.program.add(new ConstOperator(pieces.get(0)));
                switch (op) {
                    case 60: {
                        this.program.add(new LessEqualOperator());
                        break block0;
                    }
                    case 62: {
                        this.program.add(new GreaterEqualOperator());
                        break block0;
                    }
                    case 126: {
                        this.program.add(new ApproxOperator());
                        break block0;
                    }
                }
                this.program.add(new EqualOperator());
                break;
            }
            case 1: {
                this.program.add(new PresentOperator(attr.toString()));
                break;
            }
            case 2: {
                this.generateSubStringCode(attr.toString(), pieces);
                break;
            }
            default: {
                throw new ParseException("expected value|substring|*");
            }
        }
        return true;
    }

    void generateSubStringCode(String attr, ArrayList pieces) {
        this.program.add(new PushOperator(attr.toString()));
        String[] list = pieces.toArray(new String[pieces.size()]);
        this.program.add(new SubStringOperator(list));
    }

    boolean attribute(StringBuffer buf) throws ParseException, IOException {
        int i;
        this.debug("attribute");
        this.lexer.skipwhitespace();
        int c = this.lexer.peek();
        switch (c) {
            case -1: 
            case 40: 
            case 41: 
            case 60: 
            case 61: 
            case 62: 
            case 126: {
                return false;
            }
        }
        boolean parsing = true;
        while (parsing) {
            buf.append((char)this.lexer.get());
            c = this.lexer.peek();
            switch (c) {
                case -1: 
                case 40: 
                case 41: 
                case 60: 
                case 61: 
                case 62: 
                case 126: {
                    parsing = false;
                }
            }
        }
        for (i = buf.length() - 1; i > 0 && Character.isWhitespace(buf.charAt(i)); --i) {
        }
        buf.setLength(i + 1);
        return true;
    }

    int equalop() throws ParseException, IOException {
        this.debug("equalop");
        this.lexer.skipwhitespace();
        int op = this.lexer.peek();
        switch (op) {
            case 61: {
                this.lexer.get();
                break;
            }
            case 60: 
            case 62: 
            case 126: {
                int c = this.lexer.get();
                c = this.lexer.get();
                if (c == 61) break;
                throw new ParseException("expected ~=|>=|<=");
            }
            default: {
                op = 0;
            }
        }
        return op;
    }

    int substring(ArrayList pieces) throws ParseException, IOException {
        this.debug("substring");
        pieces.clear();
        StringBuffer ss = new StringBuffer();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        block6: while (true) {
            int c = this.lexer.peek();
            switch (c) {
                case 41: {
                    if (wasStar) {
                        rightstar = true;
                    } else {
                        pieces.add(ss.toString());
                    }
                    ss.setLength(0);
                    break block6;
                }
                case 92: {
                    wasStar = false;
                    this.lexer.get();
                    c = this.lexer.get();
                    if (c == -1) {
                        throw new ParseException("unexpected EOF");
                    }
                    ss.append((char)c);
                    continue block6;
                }
                case -1: 
                case 40: {
                    if (pieces.size() > 0) {
                        throw new ParseException("expected ')'");
                    }
                    throw new ParseException("expected value|substring");
                }
                case 42: {
                    if (wasStar) {
                        throw new ParseException("unexpected '**'");
                    }
                    this.lexer.get();
                    if (ss.length() > 0) {
                        pieces.add(ss.toString());
                    }
                    ss.setLength(0);
                    if (pieces.size() == 0) {
                        leftstar = true;
                    }
                    ss.setLength(0);
                    wasStar = true;
                    continue block6;
                }
                default: {
                    wasStar = false;
                    ss.append((char)this.lexer.get());
                    continue block6;
                }
            }
            break;
        }
        if (pieces.size() == 0) {
            return 1;
        }
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
            return 2;
        }
        return 0;
    }

    public void setDebug(PrintStream out) {
        debug = true;
        this.dbgout = out;
    }

    void debug(String proc) {
        if (!debug || this.dbgout == null) {
            return;
        }
        this.dbgout.println("parsing " + proc + ":" + this.lexer.charno());
        this.dbgout.flush();
    }

    public static boolean compare(Object lhs, String rhs, int operator) throws EvaluationException {
        if (lhs instanceof String) {
            switch (operator) {
                case 0: {
                    return ((String)lhs).compareTo(rhs) == 0;
                }
                case 1: {
                    return ((String)lhs).compareTo(rhs) >= 0;
                }
                case 2: {
                    return ((String)lhs).compareTo(rhs) <= 0;
                }
                case 3: {
                    return Parser.compareToApprox((String)lhs, rhs);
                }
            }
            throw new EvaluationException("Unknown comparison operator..." + operator);
        }
        if (lhs instanceof Comparable) {
            Comparable<Character> rhsComparable = null;
            try {
                rhsComparable = lhs instanceof Character ? new Character(rhs.charAt(0)) : (Comparable)lhs.getClass().getConstructor(STRING_CLASS).newInstance(rhs);
            }
            catch (Exception ex) {
                throw new EvaluationException("Could not instantiate class " + lhs.getClass().getName() + " with constructor String parameter " + rhs + " " + ex);
            }
            Comparable lhsComparable = (Comparable)lhs;
            switch (operator) {
                case 0: {
                    return lhsComparable.compareTo(rhsComparable) == 0;
                }
                case 1: {
                    return lhsComparable.compareTo(rhsComparable) >= 0;
                }
                case 2: {
                    return lhsComparable.compareTo(rhsComparable) <= 0;
                }
                case 3: {
                    return Parser.compareToApprox(lhsComparable, rhsComparable);
                }
            }
            throw new EvaluationException("Unknown comparison operator..." + operator);
        }
        Class<?> lhsClass = lhs.getClass();
        if (lhsClass.isArray()) {
            if (lhsClass.getComponentType().isPrimitive()) {
                lhs = Parser.convertPrimitiveArray(lhs);
            }
            Object[] array = lhs;
            for (int i = 0; i < array.length; ++i) {
                if (!Parser.compare(array[i], rhs, operator)) continue;
                return true;
            }
        } else if (lhs instanceof Collection) {
            Iterator iter = ((Collection)lhs).iterator();
            while (iter.hasNext()) {
                if (!Parser.compare(iter.next(), rhs, operator)) continue;
                return true;
            }
        } else {
            if (lhsClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Parser.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return Parser.compareBoolean(lhs, rhs, operator);
            }
            if (!(class$java$lang$Comparable == null ? (class$java$lang$Comparable = Parser.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(lhsClass)) {
                try {
                    Object rhsObject = lhsClass.getConstructor(STRING_CLASS).newInstance(rhs);
                    return lhs.equals(rhsObject);
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        return false;
    }

    private static void appendEscaped(StringBuffer buf, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '(' || c == ')' || c == '*' || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
        }
    }

    private static Object[] convertPrimitiveArray(Object array) {
        block9: {
            Class<?> clazz;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        clazz = array.getClass().getComponentType();
                                        if (clazz != Boolean.TYPE) break block8;
                                        boolean[] src = (boolean[])array;
                                        array = new Boolean[src.length];
                                        for (int i = 0; i < src.length; ++i) {
                                            ((Object[])array)[i] = src[i] ? Boolean.TRUE : Boolean.FALSE;
                                        }
                                        break block9;
                                    }
                                    if (clazz != Character.TYPE) break block10;
                                    char[] src = (char[])array;
                                    array = new Character[src.length];
                                    for (int i = 0; i < src.length; ++i) {
                                        ((Object[])array)[i] = new Character(src[i]);
                                    }
                                    break block9;
                                }
                                if (clazz != Byte.TYPE) break block11;
                                byte[] src = (byte[])array;
                                array = new Byte[src.length];
                                for (int i = 0; i < src.length; ++i) {
                                    ((Object[])array)[i] = new Byte(src[i]);
                                }
                                break block9;
                            }
                            if (clazz != Short.TYPE) break block12;
                            byte[] src = (byte[])array;
                            array = new Byte[src.length];
                            for (int i = 0; i < src.length; ++i) {
                                ((Object[])array)[i] = new Byte(src[i]);
                            }
                            break block9;
                        }
                        if (clazz != Integer.TYPE) break block13;
                        int[] src = (int[])array;
                        array = new Integer[src.length];
                        for (int i = 0; i < src.length; ++i) {
                            ((Object[])array)[i] = new Integer(src[i]);
                        }
                        break block9;
                    }
                    if (clazz != Long.TYPE) break block14;
                    long[] src = (long[])array;
                    array = new Long[src.length];
                    for (int i = 0; i < src.length; ++i) {
                        ((Object[])array)[i] = new Long(src[i]);
                    }
                    break block9;
                }
                if (clazz != Float.TYPE) break block15;
                float[] src = (float[])array;
                array = new Float[src.length];
                for (int i = 0; i < src.length; ++i) {
                    ((Object[])array)[i] = new Float(src[i]);
                }
                break block9;
            }
            if (clazz != Double.TYPE) break block9;
            double[] src = (double[])array;
            array = new Double[src.length];
            for (int i = 0; i < src.length; ++i) {
                ((Object[])array)[i] = new Double(src[i]);
            }
        }
        return array;
    }

    private static boolean compareBoolean(Object lhs, String rhs, int operator) throws EvaluationException {
        Boolean rhsBoolean = new Boolean(rhs);
        if (lhs.getClass().isArray()) {
            Object[] objs = (Object[])lhs;
            block6: for (int i = 0; i < objs.length; ++i) {
                switch (operator) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!objs[i].equals(rhsBoolean)) continue block6;
                        return true;
                    }
                    default: {
                        throw new EvaluationException("Unknown comparison operator: " + operator);
                    }
                }
            }
            return false;
        }
        switch (operator) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return lhs.equals(rhsBoolean);
            }
        }
        throw new EvaluationException("Unknown comparison operator..." + operator);
    }

    private static boolean compareToApprox(Object obj1, Object obj2) throws EvaluationException {
        if (obj1 instanceof Byte) {
            byte value1 = (Byte)obj1;
            byte value2 = (Byte)obj2;
            return value2 >= value1 - Math.abs(value1) * 10 / 100 && value2 <= value1 + Math.abs(value1) * 10 / 100;
        }
        if (obj1 instanceof Character) {
            char value1 = ((Character)obj1).charValue();
            char value2 = ((Character)obj2).charValue();
            return value2 >= value1 - Math.abs(value1) * 10 / 100 && value2 <= value1 + Math.abs(value1) * 10 / 100;
        }
        if (obj1 instanceof Double) {
            double value1 = (Double)obj1;
            double value2 = (Double)obj2;
            return value2 >= value1 - Math.abs(value1) * 10.0 / 100.0 && value2 <= value1 + Math.abs(value1) * 10.0 / 100.0;
        }
        if (obj1 instanceof Float) {
            float value1 = ((Float)obj1).floatValue();
            float value2 = ((Float)obj2).floatValue();
            return value2 >= value1 - Math.abs(value1) * 10.0f / 100.0f && value2 <= value1 + Math.abs(value1) * 10.0f / 100.0f;
        }
        if (obj1 instanceof Integer) {
            int value1 = (Integer)obj1;
            int value2 = (Integer)obj2;
            return value2 >= value1 - Math.abs(value1) * 10 / 100 && value2 <= value1 + Math.abs(value1) * 10 / 100;
        }
        if (obj1 instanceof Long) {
            long value1 = (Long)obj1;
            long value2 = (Long)obj2;
            return value2 >= value1 - Math.abs(value1) * 10L / 100L && value2 <= value1 + Math.abs(value1) * 10L / 100L;
        }
        if (obj1 instanceof Short) {
            short value1 = (Short)obj1;
            short value2 = (Short)obj2;
            return value2 >= value1 - Math.abs(value1) * 10 / 100 && value2 <= value1 + Math.abs(value1) * 10 / 100;
        }
        if (obj1 instanceof String) {
            int size;
            int distance = Parser.getDistance(obj1.toString().toLowerCase(), obj2.toString().toLowerCase());
            return distance <= (size = ((String)obj1).length()) * 10 / 100;
        }
        if (obj1 instanceof BigInteger) {
            BigInteger value1 = (BigInteger)obj1;
            BigInteger value2 = (BigInteger)obj2;
            BigInteger delta = value1.abs().multiply(BigInteger.valueOf(10L).divide(BigInteger.valueOf(100L)));
            BigInteger low = value1.subtract(delta);
            BigInteger high = value1.add(delta);
            return value2.compareTo(low) >= 0 && value2.compareTo(high) <= 0;
        }
        if (m_hasBigDecimal && obj1 instanceof BigDecimal) {
            BigDecimal value1 = (BigDecimal)obj1;
            BigDecimal value2 = (BigDecimal)obj2;
            BigDecimal delta = value1.abs().multiply(BigDecimal.valueOf(10L).divide(BigDecimal.valueOf(100L), 5));
            BigDecimal low = value1.subtract(delta);
            BigDecimal high = value1.add(delta);
            return value2.compareTo(low) >= 0 && value2.compareTo(high) <= 0;
        }
        throw new EvaluationException("Approximate operator not supported for type " + obj1.getClass().getName());
    }

    private static int getDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = Parser.Minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int Minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    private static void fewOperands(String op) throws EvaluationException {
        throw new EvaluationException(op + ": too few operands");
    }

    private static void unsupportedType(String opStr, Class clazz) throws EvaluationException {
        throw new EvaluationException(opStr + ": unsupported type " + clazz.getName(), clazz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName("java.math.BigDecimal");
            m_hasBigDecimal = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        debug = false;
    }

    private static interface OperatorConstants {
        public static final int SSINIT = 0;
        public static final int SSFINAL = 1;
        public static final int SSMIDDLE = 2;
        public static final int SSANY = 3;
    }

    private static final class SubStringOperator
    extends Operator
    implements OperatorConstants {
        String[] pieces;

        public SubStringOperator(String[] pieces) {
            this.pieces = pieces;
        }

        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            Object op;
            if (operands.empty()) {
                Parser.fewOperands("SUBSTRING");
            }
            if ((op = operands.pop()) instanceof String) {
                operands.push(this.check((String)op));
            } else if (op instanceof String[]) {
                String[] ops = (String[])op;
                boolean result = false;
                for (int i = 0; !result && i < ops.length; ++i) {
                    if (this.check(ops[i]) != Boolean.TRUE) continue;
                    result = true;
                }
                operands.push(result ? Boolean.TRUE : Boolean.FALSE);
            } else {
                Parser.unsupportedType("SUBSTRING", op.getClass());
            }
        }

        private Boolean check(String s) {
            Boolean result = Boolean.FALSE;
            int len = this.pieces.length;
            int index = 0;
            for (int i = 0; i < len; ++i) {
                String piece = this.pieces[i];
                if (i == len - 1) {
                    if (s.endsWith(piece)) {
                        result = Boolean.TRUE;
                        break;
                    }
                    result = Boolean.FALSE;
                    break;
                }
                if (i == 0) {
                    if (!s.startsWith(piece)) {
                        result = Boolean.FALSE;
                        break;
                    }
                } else if ((index = s.indexOf(piece, index)) < 0) {
                    result = Boolean.FALSE;
                    break;
                }
                index += piece.length();
            }
            return result;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("substring(");
            for (int i = 0; i < this.pieces.length; ++i) {
                String piece = this.pieces[i];
                if (i > 0) {
                    b.append("*");
                }
                b.append(this.escape(piece));
            }
            b.append(")");
            return b.toString();
        }

        public String escape(String s) {
            int len = s.length();
            StringBuffer buf = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == ')' || c == '*') {
                    buf.append('\\');
                }
                buf.append(c);
            }
            return buf.toString();
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[1];
            this.children[0] = (Operator)operands.pop();
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(");
            this.children[0].toStringInfix(b);
            b.append("=");
            for (int i = 0; i < this.pieces.length; ++i) {
                String piece = this.pieces[i];
                if (i > 0) {
                    b.append("*");
                }
                Parser.appendEscaped(b, piece);
            }
            b.append(")");
        }
    }

    private static final class ConstOperator
    extends Operator {
        Object val;

        public ConstOperator(Object val) {
            this.val = val;
        }

        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            operands.push(this.val);
        }

        public String toString() {
            return "const(" + this.val + ")";
        }

        public String toStringInfix() {
            return this.val.toString();
        }

        public void buildTree(Stack operands) {
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            Parser.appendEscaped(b, this.val.toString());
        }
    }

    private static final class PushOperator
    extends Operator {
        String attribute;

        public PushOperator(String attribute) {
            this.attribute = attribute;
        }

        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            Object value = mapper.lookup(this.attribute);
            if (value == null) {
                throw new AttributeNotFoundException("attribute " + this.attribute + " not found");
            }
            operands.push(value);
        }

        public String toString() {
            return "push(" + this.attribute + ")";
        }

        public String toStringInfix() {
            return this.attribute;
        }

        public void buildTree(Stack operands) {
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append(this.attribute);
        }
    }

    private static final class PresentOperator
    extends Operator {
        String attribute;

        public PresentOperator(String attribute) {
            this.attribute = attribute;
        }

        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            Object value = mapper.lookup(this.attribute);
            operands.push(value != null ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return this.attribute + "=*";
        }

        public void buildTree(Stack operands) {
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(");
            b.append(this.attribute + "=*");
            b.append(")");
        }
    }

    private static final class ApproxOperator
    extends Operator {
        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            Object lhs;
            if (operands.empty()) {
                Parser.fewOperands("~=");
            }
            String rhs = (String)operands.pop();
            if (operands.empty()) {
                Parser.fewOperands("~=");
            }
            operands.push(Parser.compare(lhs = operands.pop(), rhs, 3) ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return "~=()";
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[2];
            for (int i = 0; i < 2; ++i) {
                this.children[1 - i] = (Operator)operands.pop();
            }
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(");
            for (int i = 0; i < this.children.length; ++i) {
                Operator o = this.children[i];
                if (i > 0) {
                    b.append("~=");
                }
                o.toStringInfix(b);
            }
            b.append(")");
        }
    }

    private static final class LessEqualOperator
    extends Operator {
        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            Object lhs;
            if (operands.empty()) {
                Parser.fewOperands("<=");
            }
            String rhs = (String)operands.pop();
            if (operands.empty()) {
                Parser.fewOperands("<=");
            }
            operands.push(Parser.compare(lhs = operands.pop(), rhs, 2) ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return "<=()";
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[2];
            for (int i = 0; i < 2; ++i) {
                this.children[1 - i] = (Operator)operands.pop();
            }
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(");
            for (int i = 0; i < this.children.length; ++i) {
                Operator o = this.children[i];
                if (i > 0) {
                    b.append("<=");
                }
                o.toStringInfix(b);
            }
            b.append(")");
        }
    }

    private static final class GreaterEqualOperator
    extends Operator {
        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            Object lhs;
            if (operands.empty()) {
                Parser.fewOperands(">=");
            }
            String rhs = (String)operands.pop();
            if (operands.empty()) {
                Parser.fewOperands(">=");
            }
            operands.push(Parser.compare(lhs = operands.pop(), rhs, 1) ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return ">=()";
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[2];
            for (int i = 0; i < 2; ++i) {
                this.children[1 - i] = (Operator)operands.pop();
            }
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(");
            for (int i = 0; i < this.children.length; ++i) {
                Operator o = this.children[i];
                if (i > 0) {
                    b.append(">=");
                }
                o.toStringInfix(b);
            }
            b.append(")");
        }
    }

    private static final class EqualOperator
    extends Operator {
        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            Object lhs;
            if (operands.empty()) {
                Parser.fewOperands("=");
            }
            String rhs = (String)operands.pop();
            if (operands.empty()) {
                Parser.fewOperands("=");
            }
            operands.push(Parser.compare(lhs = operands.pop(), rhs, 0) ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return "=()";
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[2];
            for (int i = 0; i < 2; ++i) {
                Operator o;
                this.children[1 - i] = o = (Operator)operands.pop();
            }
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(");
            for (int i = 0; i < this.children.length; ++i) {
                Operator o = this.children[i];
                if (i > 0) {
                    b.append("=");
                }
                o.toStringInfix(b);
            }
            b.append(")");
        }
    }

    private static final class ObjectClassOperator
    extends Operator {
        public final String m_target;

        public ObjectClassOperator(String target) {
            this.m_target = target;
        }

        public void buildTree(Stack operands) {
            operands.push(this);
        }

        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            String[] objectClass = (String[])mapper.lookup("objectClass");
            if (objectClass != null) {
                for (int i = 0; i < objectClass.length; ++i) {
                    if (!this.m_target.equals(objectClass[i])) continue;
                    operands.push(Boolean.TRUE);
                    return;
                }
            }
            operands.push(Boolean.FALSE);
        }

        public String toString() {
            return "=()";
        }

        public void toStringInfix(StringBuffer b) {
            b.append('(').append("objectClass=").append(this.m_target).append(')');
        }
    }

    private static final class NotOperator
    extends Operator {
        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            if (operands.empty()) {
                Parser.fewOperands("NOT");
            }
            boolean result = (Boolean)operands.pop() == false;
            operands.push(result ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return "!()";
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[1];
            this.children[0] = (Operator)operands.pop();
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(!");
            for (int i = 0; i < this.children.length; ++i) {
                Operator o = this.children[i];
                o.toStringInfix(b);
            }
            b.append(")");
        }
    }

    private static final class OrOperator
    extends Operator {
        private int operandCount;

        public OrOperator(int opcnt) {
            this.operandCount = opcnt;
        }

        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            boolean result = false;
            for (int i = 0; i < this.operandCount; ++i) {
                if (operands.empty()) {
                    Parser.fewOperands("OR");
                }
                if (result) {
                    operands.pop();
                    continue;
                }
                result = (Boolean)operands.pop();
            }
            operands.push(result ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return "|(" + this.operandCount + ")";
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[this.operandCount];
            for (int i = 0; i < this.operandCount; ++i) {
                this.children[this.operandCount - 1 - i] = (Operator)operands.pop();
            }
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(|");
            for (int i = 0; i < this.children.length; ++i) {
                Operator o = this.children[i];
                o.toStringInfix(b);
            }
            b.append(")");
        }
    }

    private static final class AndOperator
    extends Operator {
        private int operandCount;

        public AndOperator(int opcnt) {
            this.operandCount = opcnt;
        }

        public void execute(Stack operands, Mapper mapper) throws EvaluationException {
            boolean result = true;
            for (int i = 0; i < this.operandCount; ++i) {
                if (operands.empty()) {
                    Parser.fewOperands("AND");
                }
                if (!result) {
                    operands.pop();
                    continue;
                }
                result = (Boolean)operands.pop();
            }
            operands.push(result ? Boolean.TRUE : Boolean.FALSE);
        }

        public String toString() {
            return "&(" + this.operandCount + ")";
        }

        public void buildTree(Stack operands) {
            this.children = new Operator[this.operandCount];
            for (int i = 0; i < this.operandCount; ++i) {
                this.children[this.operandCount - 1 - i] = (Operator)operands.pop();
            }
            operands.push(this);
        }

        public void toStringInfix(StringBuffer b) {
            b.append("(&");
            for (int i = 0; i < this.children.length; ++i) {
                Operator o = this.children[i];
                o.toStringInfix(b);
            }
            b.append(")");
        }
    }
}

