/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.FeatureAvailability;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.universal.Duration;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.dotted.PathnamesImpl;
import org.glassfish.admin.amx.internal.LoadSanityChecks;
import org.glassfish.admin.amx.j2ee.DASJ2EEDomainImpl;
import org.glassfish.admin.amx.loader.BootUtil;
import org.glassfish.admin.amx.mbean.AMXImplBase;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.mbean.BulkAccessImpl;
import org.glassfish.admin.amx.mbean.KitchenSinkImpl;
import org.glassfish.admin.amx.mbean.LoggingPropertiesMgrImpl;
import org.glassfish.admin.amx.mbean.NotificationEmitterServiceImpl;
import org.glassfish.admin.amx.mbean.NotificationServiceMgrImpl;
import org.glassfish.admin.amx.mbean.QueryMgrImpl;
import org.glassfish.admin.amx.mbean.RealmsMgrImpl;
import org.glassfish.admin.amx.mbean.RuntimeMgrImpl;
import org.glassfish.admin.amx.mbean.SampleImpl;
import org.glassfish.admin.amx.mbean.SystemStatusImpl;
import org.glassfish.admin.amx.mbean.UploadDownloadMgrImpl;
import org.glassfish.admin.amx.util.InjectedValues;
import org.glassfish.admin.amx.util.Issues;
import org.glassfish.admin.amx.util.ObjectNames;
import org.glassfish.server.ServerEnvironmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainRootImplBase
extends AMXNonConfigImplBase {
    private String mAppserverDomainName = null;
    private static final Set<String> NOT_SUPERFLUOUS = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"getDomainNotificationEmitterServiceObjectName"});
    private static final Set<String> OFFLINE_INCAPABLE_J2EE_TYPES = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"X-WebServiceMgr"});

    @Override
    public String getGroup() {
        return "utility";
    }

    public DomainRootImplBase() {
        super("X-DomainRoot", "X-DomainRoot", null, DomainRoot.class, null);
    }

    @Override
    protected String _getPathnameType() {
        return "root";
    }

    @Override
    public String _getPathnameName() {
        return null;
    }

    @Override
    public ObjectName preRegisterHook(ObjectName selfObjectName) throws Exception {
        this.mAppserverDomainName = BootUtil.getInstance().getAppserverDomainName();
        return selfObjectName;
    }

    @Override
    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
    }

    @Override
    protected final Set<String> getNotSuperfluousMethods() {
        return GSetUtil.newSet(super.getNotSuperfluousMethods(), NOT_SUPERFLUOUS);
    }

    public ObjectName getDomainNotificationEmitterServiceObjectName() {
        return this.getContainerSupport().getContaineeObjectName("X-NotificationEmitterService", "DomainNotificationEmitterService");
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    @Override
    protected final void registerChildren() {
        super.registerChildren();
        ObjectName self = this.getObjectName();
        ObjectNames objectNames = ObjectNames.getInstance(this.getJMXDomain());
        ObjectName childObjectName = null;
        AMXImplBase mbean = null;
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-LoggingPropertiesMgr", "na", false);
        mbean = new LoggingPropertiesMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-SystemStatus", "na", false);
        mbean = new SystemStatusImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-KitchenSink", "na", false);
        mbean = new KitchenSinkImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-NotificationEmitterService", "DomainNotificationEmitterService", false);
        mbean = new NotificationEmitterServiceImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-NotificationServiceMgr", "na", false);
        mbean = new NotificationServiceMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-QueryMgr", "na", false);
        mbean = new QueryMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-BulkAccess", "na", false);
        mbean = new BulkAccessImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-UploadDownloadMgr", "na", false);
        mbean = new UploadDownloadMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-Sample", "na", false);
        mbean = new SampleImpl(self);
        this.registerChild(mbean, childObjectName);
        String j2eeDomainName = this.getObjectName().getDomain();
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "J2EEDomain", j2eeDomainName, false);
        mbean = new DASJ2EEDomainImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-Pathnames", "na", false);
        mbean = new PathnamesImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-RealmsMgr", "na", false);
        mbean = new RealmsMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildContaineeObjectName(self, this.getFullType(), "X-RuntimeMgr", "na", false);
        mbean = new RuntimeMgrImpl(self);
        this.registerChild(mbean, childObjectName);
    }

    protected final void registerNotificationMgrService() {
        ObjectNames objectNames = ObjectNames.getInstance(this.getJMXDomain());
        ObjectName childObjectName = objectNames.buildContaineeObjectName(this.getObjectName(), this.getFullType(), "X-NotificationEmitterService", "DomainNotificationEmitterService", false);
        NotificationEmitterServiceImpl domainNES = new NotificationEmitterServiceImpl(this.getObjectName());
        this.registerChild(domainNES, childObjectName);
    }

    public Object loadInternal() {
        try {
            ObjectName objectName = LoadSanityChecks.load((MBeanServer)this.getMBeanServer());
            return "Loaded: " + objectName;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Failed to load SanityChecks: " + t, t);
        }
    }

    public boolean getAMXReady() {
        this.waitAMXReady();
        return true;
    }

    public void waitAMXReady() {
        FeatureAvailability.getInstance().waitForFeature("AMXReady", this.getClass().getName());
    }

    public String getDebugPort() {
        Issues.getAMXIssues().notDone("DomainRootImpl.getDebugPort");
        return "9999";
    }

    public String getApplicationServerFullVersion() {
        return Version.getFullVersion();
    }

    public String getInstanceRoot() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.instanceRoot")));
    }

    public String getDomainDir() {
        return SmartFile.sanitize((String)BootUtil.getInstance().getInstanceRoot().toString());
    }

    public String getConfigDir() {
        return this.getDomainDir() + "/" + "config";
    }

    public String getInstallDir() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.installRoot")));
    }

    public Object[] getUptimeMillis() {
        ServerEnvironmentImpl env = InjectedValues.getInstance().getServerEnvironment();
        long elapsed = System.currentTimeMillis() - env.getStartupContext().getCreationTime();
        Duration duration = new Duration(elapsed);
        return new Object[]{elapsed, duration.toString()};
    }

    public void stopDomain() {
        this.executeREST("stop-domain");
    }

    static String toString(InputStream is) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        char[] chars = new char[32768];
        InputStreamReader reader = new InputStreamReader(is);
        do {
            int len;
            if ((len = reader.read(chars, 0, chars.length)) < 1) continue;
            sbuf.append(chars, 0, len);
        } while (reader.ready());
        return sbuf.toString();
    }

    private HTTPListenerConfig getAdminHttpListener() {
        ConfigConfig config = (ConfigConfig)this.getSelf(DomainRoot.class).getDomainConfig().getConfigsConfig().getConfigConfigMap().get("server-config");
        return (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get("admin-listener");
    }

    private int getRESTPort() {
        return this.getAdminHttpListener().resolveInteger("Port");
    }

    private String get_asadmin() {
        return this.getAdminHttpListener().resolveAttribute("DefaultVirtualServer");
    }

    public String getRESTBaseURL() {
        String scheme = this.getAdminHttpListener().resolveBoolean("SecurityEnabled") != false ? "https" : "http";
        String host = "localhost";
        return scheme + "://" + "localhost" + ":" + this.getRESTPort() + "/" + this.get_asadmin() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeREST(String cmd) {
        String result = null;
        HttpURLConnection conn = null;
        try {
            String url = this.getRESTBaseURL() + cmd;
            URL invoke = new URL(url);
            conn = (HttpURLConnection)invoke.openConnection();
            InputStream is = conn.getInputStream();
            result = DomainRootImplBase.toString(is);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = ExceptionUtil.toString((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }
}

