/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.admingui.handlers;

import com.sun.appserv.management.config.AuthRealmConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigElement;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealmsHandlers {
    private static List skipRealmPropsList = new ArrayList();
    private static List realmClassList;

    public static void getRealmsList(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map realmsMap = sConfig.getAuthRealmConfigMap();
        Iterator iter = realmsMap.values().iterator();
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                ConfigElement configE = (ConfigElement)iter.next();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = configE.getName();
                oneRow.put("name", name);
                oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)name, (List)selectedList) : false);
                String classname = ((AuthRealmConfig)configE).getClassname();
                oneRow.put("classname", classname == null ? " " : classname);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteSecurityConfig(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        String type = (String)handlerCtx.getInputValue("type");
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        for (Map oneRow : selectedRows) {
            String name = (String)oneRow.get("name");
            try {
                if (type.equals("realms")) {
                    sConfig.removeAuthRealmConfig(name);
                    continue;
                }
                sConfig.removeAuditModuleConfig(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Cannot delete " + name);
            }
        }
    }

    public static void getRealmAttrForCreate(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
        handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
        HashMap<String, Boolean> attrMap = new HashMap<String, Boolean>();
        attrMap.put("predefinedClassname", Boolean.TRUE);
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("properties", new HashMap());
    }

    public static void getRealmAttrForEdit(HandlerContext handlerCtx) {
        AuthRealmConfig realm = RealmsHandlers.getAuthRealmConfig(handlerCtx, true);
        if (realm == null) {
            return;
        }
        Map origProps = realm.getPropertyConfigMap();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put("fileJaax", "fileRealm");
        attrMap.put("ldapJaax", "ldapRealm");
        attrMap.put("solarisJaax", "solarisRealm");
        attrMap.put("jdbcJaax", "jdbcRealm");
        String classname = realm.getClassname();
        if (realmClassList.contains(classname)) {
            handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
            attrMap.put("predefinedClassname", Boolean.TRUE);
            attrMap.put("classname", classname);
            Map props = AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)realm, (List)skipRealmPropsList);
            handlerCtx.setOutputValue("properties", (Object)props);
            if (classname.indexOf("FileRealm") != -1) {
                attrMap.put("file", AMXUtil.getPropValue((Map)origProps, (String)"file"));
                attrMap.put("fileJaax", AMXUtil.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("fileAsGroups", AMXUtil.getPropValue((Map)origProps, (String)"assign-groups"));
            } else if (classname.indexOf("LDAPRealm") != -1) {
                attrMap.put("ldapJaax", AMXUtil.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("ldapAsGroups", AMXUtil.getPropValue((Map)origProps, (String)"assign-groups"));
                attrMap.put("directory", AMXUtil.getPropValue((Map)origProps, (String)"directory"));
                attrMap.put("baseDn", AMXUtil.getPropValue((Map)origProps, (String)"base-dn"));
            } else if (classname.indexOf("SolarisRealm") != -1) {
                attrMap.put("solarisJaax", AMXUtil.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("solarisAsGroups", AMXUtil.getPropValue((Map)origProps, (String)"assign-groups"));
            } else if (classname.indexOf("JDBCRealm") != -1) {
                attrMap.put("jdbcJaax", AMXUtil.getPropValue((Map)origProps, (String)"jaas-context"));
                attrMap.put("jdbcAsGroups", AMXUtil.getPropValue((Map)origProps, (String)"assign-groups"));
                attrMap.put("datasourceJndi", AMXUtil.getPropValue((Map)origProps, (String)"datasource-jndi"));
                attrMap.put("userTable", AMXUtil.getPropValue((Map)origProps, (String)"user-table"));
                attrMap.put("userNameColumn", AMXUtil.getPropValue((Map)origProps, (String)"user-name-column"));
                attrMap.put("passwordColumn", AMXUtil.getPropValue((Map)origProps, (String)"password-column"));
                attrMap.put("groupTable", AMXUtil.getPropValue((Map)origProps, (String)"group-table"));
                attrMap.put("groupNameColumn", AMXUtil.getPropValue((Map)origProps, (String)"group-name-column"));
                attrMap.put("dbUser", AMXUtil.getPropValue((Map)origProps, (String)"db-user"));
                attrMap.put("dbPassword", AMXUtil.getPropValue((Map)origProps, (String)"db-password"));
                attrMap.put("digestAlgorithm", AMXUtil.getPropValue((Map)origProps, (String)"digest-algorithm"));
                attrMap.put("encoding", AMXUtil.getPropValue((Map)origProps, (String)"encoding"));
                attrMap.put("charset", AMXUtil.getPropValue((Map)origProps, (String)"charset"));
            } else if (classname.indexOf("CertificateRealm") != -1) {
                attrMap.put("certAsGroups", AMXUtil.getPropValue((Map)origProps, (String)"assign-groups"));
            }
        } else {
            handlerCtx.setOutputValue("classnameOption", (Object)"input");
            attrMap.put("predefinedClassname", Boolean.FALSE);
            attrMap.put("classnameInput", classname);
            handlerCtx.setOutputValue("properties", (Object)origProps);
        }
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
    }

    private static AuthRealmConfig getAuthRealmConfig(HandlerContext handlerCtx, boolean getRealmName) {
        String realmName = (String)handlerCtx.getInputValue("realmName");
        String configName = (String)handlerCtx.getInputValue("configName");
        if (GuiUtil.isEmpty((String)realmName) || GuiUtil.isEmpty((String)configName)) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"realm.internalError"));
            return null;
        }
        if (getRealmName) {
            handlerCtx.setOutputValue("outName", (Object)realmName);
        }
        ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
        return (AuthRealmConfig)config.getSecurityServiceConfig().getAuthRealmConfigMap().get(realmName);
    }

    public static void createRealm(HandlerContext handlerCtx) {
        String option = (String)handlerCtx.getInputValue("classnameOption");
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        Map convertedMap = AMXUtil.convertToPropertiesOptionMap((Map)newProps, null);
        String classname = "";
        try {
            if (option.equals("predefine")) {
                classname = (String)attrMap.get("classname");
                if (classname.indexOf("FileRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, convertedMap, "file", "file");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "jaas-context", "fileJaax");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "assign-groups", "fileAsGroups");
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, convertedMap, "jaas-context", "ldapJaax");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "base-dn", "baseDn");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "directory", "directory");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "assign-groups", "ldapAsGroups");
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, convertedMap, "jaas-context", "solarisJaax");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "assign-groups", "solarisAsGroups");
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, convertedMap, "jaas-context", "jdbcJaax");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "datasource-jndi", "datasourceJndi");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "user-table", "userTable");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "user-name-column", "userNameColumn");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "password-column", "passwordColumn");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "group-table", "groupTable");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "group-name-column", "groupNameColumn");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "db-user", "dbUser");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "db-password", "dbPassword");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "digest-algorithm", "digestAlgorithm");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "encoding", "encoding");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "charset", "charset");
                    RealmsHandlers.putOptional(attrMap, convertedMap, "assign-groups", "jdbcAsGroups");
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    RealmsHandlers.putOptional(attrMap, convertedMap, "assign-groups", "certAsGroups");
                }
            } else {
                classname = (String)attrMap.get("classnameInput");
            }
            String configName = (String)handlerCtx.getInputValue("configName");
            ConfigConfig config = (ConfigConfig)AMXRoot.getInstance().getConfigsConfig().getConfigConfigMap().get(configName);
            SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
            sConfig.createAuthRealmConfig((String)attrMap.get("name"), classname, convertedMap);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static void putOptional(Map<String, String> attrMap, Map convertedMap, String propName, String key) {
        String val = attrMap.get(key);
        if (!GuiUtil.isEmpty((String)val)) {
            convertedMap.put("property." + propName, val);
        }
    }

    public static void saveRealm(HandlerContext handlerCtx) {
        AuthRealmConfig realm = RealmsHandlers.getAuthRealmConfig(handlerCtx, false);
        if (realm == null) {
            return;
        }
        String option = (String)handlerCtx.getInputValue("classnameOption");
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        try {
            if (option.equals("predefine")) {
                String oldClassname;
                String classname = (String)attrMap.get("classname");
                if (!classname.equals(oldClassname = realm.getClassname())) {
                    realm.setClassname(classname);
                }
                AMXUtil.updateProperties((PropertiesAccess)realm, (Map)newProps, null);
                if (classname.indexOf("FileRealm") != -1) {
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"file", (String)((String)attrMap.get("file")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"jaas-context", (String)((String)attrMap.get("fileJaax")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"assign-groups", (String)((String)attrMap.get("fileAsGroups")));
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"jaas-context", (String)((String)attrMap.get("ldapJaax")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"assign-groups", (String)((String)attrMap.get("ldapAsGroups")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"base-dn", (String)((String)attrMap.get("baseDn")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"directory", (String)((String)attrMap.get("directory")));
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"jaas-context", (String)((String)attrMap.get("solarisJaax")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"assign-groups", (String)((String)attrMap.get("solarisAsGroups")));
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"jaas-context", (String)((String)attrMap.get("jdbcJaax")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"assign-groups", (String)((String)attrMap.get("jdbcAsGroups")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"datasource-jndi", (String)((String)attrMap.get("datasourceJndi")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"user-table", (String)((String)attrMap.get("userTable")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"user-name-column", (String)((String)attrMap.get("userNameColumn")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"password-column", (String)((String)attrMap.get("passwordColumn")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"group-table", (String)((String)attrMap.get("groupTable")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"group-name-column", (String)((String)attrMap.get("groupNameColumn")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"db-user", (String)((String)attrMap.get("dbUser")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"db-password", (String)((String)attrMap.get("dbPassword")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"digest-algorithm", (String)((String)attrMap.get("digestAlgorithm")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"encoding", (String)((String)attrMap.get("encoding")));
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"charset", (String)((String)attrMap.get("charset")));
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    AMXUtil.setPropertyValue((PropertiesAccess)realm, (String)"assign-groups", (String)((String)attrMap.get("certAsGroups")));
                }
            } else {
                AMXUtil.updateProperties((PropertiesAccess)realm, (Map)newProps, null);
                realm.setClassname((String)attrMap.get("classnameInput"));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    static {
        String[] classnames = AMXRoot.getInstance().getRealmsMgr().getPredefinedAuthRealmClassNames();
        realmClassList = new ArrayList();
        realmClassList.add("");
        for (int i = 0; i < classnames.length; ++i) {
            realmClassList.add(classnames[i]);
        }
        skipRealmPropsList.add("jaas-context");
        skipRealmPropsList.add("file");
        skipRealmPropsList.add("assign-groups");
        skipRealmPropsList.add("base-dn");
        skipRealmPropsList.add("directory");
        skipRealmPropsList.add("datasource-jndi");
        skipRealmPropsList.add("user-table");
        skipRealmPropsList.add("user-name-column");
        skipRealmPropsList.add("password-column");
        skipRealmPropsList.add("group-table");
        skipRealmPropsList.add("group-name-column");
        skipRealmPropsList.add("db-user");
        skipRealmPropsList.add("db-password");
        skipRealmPropsList.add("digest-algorithm");
        skipRealmPropsList.add("encoding");
        skipRealmPropsList.add("charset");
    }
}

