/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.flashlight.impl.core.ProbeProvider;

public class ProbeProviderRegistry {
    private static ProbeProviderRegistry _me = new ProbeProviderRegistry();
    private ConcurrentHashMap<String, ProbeProvider> providerMap = new ConcurrentHashMap();

    private ProbeProviderRegistry() {
    }

    public static ProbeProviderRegistry getInstance() {
        return _me;
    }

    public ProbeProvider getProbeProvider(String moduleName, String providerName, String appName) {
        String qname = moduleName + ":" + providerName + ":" + (appName == null ? "" : appName);
        return this.providerMap.get(qname);
    }

    public ProbeProvider registerProbeProvider(ProbeProvider provider, Class clz) {
        String appName = provider.getAppName();
        String qname = provider.getModuleName() + ":" + provider.getProviderName() + ":" + (appName == null ? "" : appName);
        ProbeProvider oldProvider = this.providerMap.get(qname);
        if (oldProvider != null) {
            throw new IllegalStateException("Provider already mapped " + qname);
        }
        this.providerMap.put(qname, provider);
        return provider;
    }
}

