/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

abstract class DMLWriteResultSet
extends NoRowsResultSetImpl {
    protected WriteCursorConstantAction constantAction;
    protected int[] baseRowReadMap;
    protected int[] streamStorableHeapColIds;
    protected ExecRow deferredSparseRow;
    protected DynamicCompiledOpenConglomInfo heapDCOCI;
    protected DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private boolean needToObjectifyStream;
    public int rowCount;

    DMLWriteResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation);
        this.constantAction = (WriteCursorConstantAction)constantAction;
        this.baseRowReadMap = this.constantAction.getBaseRowReadMap();
        this.streamStorableHeapColIds = this.constantAction.getStreamStorableHeapColIds();
        TransactionController transactionController = activation.getTransactionController();
        if (!(constantAction instanceof UpdatableVTIConstantAction)) {
            this.heapDCOCI = transactionController.getDynamicCompiledConglomInfo(this.constantAction.conglomId);
            if (this.constantAction.indexCIDS.length != 0) {
                this.indexDCOCIs = new DynamicCompiledOpenConglomInfo[this.constantAction.indexCIDS.length];
                for (int i = 0; i < this.constantAction.indexCIDS.length; ++i) {
                    this.indexDCOCIs[i] = transactionController.getDynamicCompiledConglomInfo(this.constantAction.indexCIDS[i]);
                }
            }
        }
        this.needToObjectifyStream = this.constantAction.getTriggerInfo(activation.getLanguageConnectionContext().getExecutionContext()) != null;
    }

    public final int modifiedRowCount() {
        return this.rowCount;
    }

    protected ExecRow getNextRowCore(NoPutResultSet noPutResultSet) throws StandardException {
        ExecRow execRow = noPutResultSet.getNextRowCore();
        if (this.needToObjectifyStream) {
            this.objectifyStreams(execRow);
        }
        return execRow;
    }

    private void objectifyStreams(ExecRow execRow) throws StandardException {
        if (execRow != null && this.streamStorableHeapColIds != null) {
            for (int i = 0; i < this.streamStorableHeapColIds.length; ++i) {
                int n = this.streamStorableHeapColIds[i];
                int n2 = this.baseRowReadMap == null ? n : this.baseRowReadMap[n];
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(n2 + 1);
                ((StreamStorable)((Object)dataValueDescriptor)).loadStream();
            }
        }
    }

    protected ExecRow makeDeferredSparseRow(ExecRow execRow, FormatableBitSet formatableBitSet, LanguageConnectionContext languageConnectionContext) throws StandardException {
        ExecRow execRow2;
        if (formatableBitSet == null) {
            execRow2 = execRow;
        } else {
            execRow2 = RowUtil.getEmptyValueRow(formatableBitSet.getLength() - 1, languageConnectionContext);
            int n = 1;
            for (int i = 1; i <= execRow2.nColumns(); ++i) {
                if (!formatableBitSet.isSet(i)) continue;
                execRow2.setColumn(i, execRow.getColumn(n++));
            }
        }
        return execRow2;
    }

    String getIndexNameFromCID(long l) {
        return this.constantAction.getIndexNameFromCID(l);
    }
}

