/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.util.Tuple;
import com.sun.jsftemplating.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final String FILES_FOUND = "_filesFoundThisRequest";
    private static final Class[] REALPATH_ARGS = new Class[]{String.class};
    private static final Class[] GET_RES_ARGS = new Class[]{String.class};
    private static final String[] DEFAULT_SEARCH_PATH = new String[]{"/WEB-INF/lib/"};

    public static String getRealPath(Object ctx, String relativePath) {
        String path = null;
        Method method = null;
        try {
            method = ctx.getClass().getMethod("getRealPath", REALPATH_ARGS);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        try {
            path = (String)method.invoke(ctx, relativePath);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return path;
    }

    public static URL getResource(String relPath) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        Object ctx = facesContext.getExternalContext().getContext();
        URL url = null;
        Method method = null;
        try {
            method = ctx.getClass().getMethod("getResource", GET_RES_ARGS);
        }
        catch (NoSuchMethodException ex) {
            throw new LayoutDefinitionException("Unable to find 'getResource' method in this environment!", ex);
        }
        try {
            url = (URL)method.invoke(ctx, "/" + relPath);
        }
        catch (IllegalAccessException ex) {
            throw new LayoutDefinitionException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new LayoutDefinitionException(ex);
        }
        return url;
    }

    public static URL searchForFile(String path, String defSuff) {
        ClassLoader loader;
        boolean absolutePath = false;
        String newPath = path;
        while (newPath.startsWith("/")) {
            newPath = newPath.substring(1);
            absolutePath = true;
        }
        URL url = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        HashMap<String, URL> filesFound = null;
        if (ctx != null && (filesFound = (HashMap<String, URL>)ctx.getExternalContext().getRequestMap().get(FILES_FOUND)) != null && (url = (URL)filesFound.get(newPath)) != null) {
            return url;
        }
        if (!absolutePath) {
            String absPath = FileUtil.getAbsolutePath(ctx, newPath);
            url = FileUtil.searchForFile(absPath, defSuff);
            return url;
        }
        url = FileUtil.getResource(newPath);
        if (url == null && (url = (loader = Util.getClassLoader(path)).getResource(newPath)) == null && (url = loader.getResource("/" + newPath)) == null && (url = loader.getResource("META-INF/" + newPath)) == null && defSuff != null) {
            int idx = path.lastIndexOf(46);
            if (idx != -1) {
                String ext = path.substring(idx);
                if (!ext.equalsIgnoreCase(defSuff)) {
                    return FileUtil.searchForFile(path.substring(0, idx) + defSuff, null);
                }
            } else {
                return FileUtil.searchForFile(path + defSuff, null);
            }
        }
        if (url != null && ctx != null) {
            if (filesFound == null) {
                filesFound = new HashMap<String, URL>(8);
                ctx.getExternalContext().getRequestMap().put(FILES_FOUND, filesFound);
            }
            filesFound.put(newPath, url);
        }
        return url;
    }

    public static String getAbsolutePath(FacesContext ctx, String relPath) {
        UIViewRoot viewRoot;
        String absPath = null;
        if (ctx != null && (viewRoot = ctx.getViewRoot()) != null) {
            String viewId = viewRoot.getViewId();
            if (viewId == null) {
                viewId = "/";
            } else if (!viewId.startsWith("/")) {
                viewId = "/" + viewId;
            }
            int slash = viewId.lastIndexOf(47);
            absPath = viewId.substring(0, ++slash);
            absPath = absPath + relPath;
        }
        return absPath == null ? "/" + relPath : absPath;
    }

    public static String cleanUpPath(String absPath) {
        int idx;
        while ((idx = absPath.indexOf("/./")) != -1) {
            absPath = absPath.substring(0, idx) + absPath.substring(idx + 2);
        }
        while ((idx = absPath.indexOf("/../")) != -1) {
            int prevElement = 0;
            if (idx > 0 && (prevElement = absPath.lastIndexOf(47, idx - 1)) == -1) {
                prevElement = 0;
            }
            absPath = absPath.substring(0, prevElement) + absPath.substring(idx + 3);
        }
        while ((idx = absPath.indexOf("//")) != -1) {
            absPath = absPath.substring(0, idx) + absPath.substring(idx + 1);
        }
        return absPath;
    }

    public static List<Tuple> getJarResources(FacesContext facesContext, String resourcePath, String ... searchPaths) throws IOException {
        if (searchPaths == null) {
            searchPaths = DEFAULT_SEARCH_PATH;
        }
        ArrayList<Tuple> entries = new ArrayList<Tuple>();
        ExternalContext ec = facesContext.getExternalContext();
        for (String searchPath : searchPaths) {
            Set paths = ec.getResourcePaths(searchPath);
            for (String path : paths) {
                JarFile jarFile;
                JarEntry jarEntry;
                if (!"jar".equalsIgnoreCase(path.substring(path.length() - 3)) || (jarEntry = (jarFile = new JarFile(new File(ec.getResource(path).getFile()))).getJarEntry(resourcePath)) == null) continue;
                entries.add(new Tuple(jarFile, jarEntry));
            }
        }
        return entries;
    }
}

