/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Catalog;
import com.sun.pkg.client.DependAction;
import com.sun.pkg.client.FileList;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.GroupAction;
import com.sun.pkg.client.Manifest;
import com.sun.pkg.client.SystemInfo;
import com.sun.pkg.client.UserAction;
import com.sun.pkg.client.Version;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image {
    public static final int IMG_ENTIRE = 0;
    public static final int IMG_PARTIAL = 1;
    public static final int IMG_USER = 2;
    static final String img_user_prefix = ".org.opensolaris,pkg";
    static final String img_root_prefix = "var/pkg";
    static final String os = System.getProperty("os.name").toLowerCase();
    static final String arch = System.getProperty("os.arch").toLowerCase();
    private static final String PKG_DIR = "pkg";
    private static final String INSTALLED_FILE = "installed";
    private static final String ISTATE_DIR = "state" + File.separator + "installed";
    private static final String ISTATE_DIR_TMP = "state" + File.separator + "installed.build";
    int type = 2;
    static final String typeStr = "USER";
    static Logger log = Logger.getLogger("com.sun.pkg.client", "com/sun/pkg/client/messages");
    static final String userAgent = "pkg-java/" + Image.getVersion() + " (" + os + " " + arch + "; " + System.getProperty("os.version") + " " + System.getProperty("java.version") + "; " + "USER" + ")";
    Map<String, Authority> authorities = new HashMap<String, Authority>();
    List<String> lines = new ArrayList<String>();
    Map<String, Boolean> policies = new HashMap<String, Boolean>();
    String preferred_authority_name = null;
    File cfgfile;
    File imgdir;
    File metadir;
    Map<Authority, Catalog> catalogs = new HashMap<Authority, Catalog>();
    CatalogCache catalogCache = new CatalogCache();
    Proxy proxy = SystemInfo.getProxy();

    public Image(String path) throws Exception {
        this(new File(path));
    }

    public Image(File path) throws Exception {
        this.imgdir = path;
        if (!this.imgdir.isDirectory()) {
            throw new Exception("image directory (" + path + ") doesn't exist");
        }
        this.metadir = new File(this.imgdir, img_user_prefix);
        if (!this.imgdir.isDirectory()) {
            throw new Exception("invalid USER image directory");
        }
        this.loadConfig(new File(this.metadir, "cfg_cache"));
        for (Authority a : this.authorities.values()) {
            log.log(Level.CONFIG, "softwarerepo", a.origin);
            Catalog c = new Catalog(this, a.prefix);
            this.catalogs.put(a, c);
            this.catalogCache.addCatalog(c, a);
        }
        this.catalogCache.cacheInstalledPackages();
    }

    public File getRootDirectory() {
        return this.imgdir;
    }

    File getMetaDirectory() {
        return this.metadir;
    }

    Logger getLogger() {
        return log;
    }

    HttpURLConnection getRepositoryURLConnection(String resource, String authname) throws IOException {
        URLConnection urlc;
        Authority a = this.authorities.get(authname);
        if (a == null) {
            throw new IllegalArgumentException("invalid authority name: " + authname);
        }
        URL repo = new URL(a.origin);
        URL u = new URL(repo, resource);
        URLConnection uRLConnection = urlc = this.proxy == null ? u.openConnection() : u.openConnection(this.proxy);
        if (!(urlc instanceof HttpURLConnection)) {
            throw new IOException("unrecognized repository URL type:" + a.origin);
        }
        HttpURLConnection hurlc = (HttpURLConnection)urlc;
        hurlc.setRequestProperty("User-Agent", userAgent);
        hurlc.setRequestProperty("X-IPkg-UUID", a.uuid);
        return hurlc;
    }

    HttpURLConnection getRepositoryURLConnection(String resource, Fmri f) throws IOException {
        String authname = f.getAuthority();
        if (authname == null) {
            throw new IllegalArgumentException("attempt to access a resource for an Fmri that has no authority: " + f);
        }
        return this.getRepositoryURLConnection(resource, authname);
    }

    void checkRepositoryConnection(HttpURLConnection urlc) throws IOException {
        int rc = urlc.getResponseCode();
        switch (rc) {
            case 200: {
                return;
            }
            case 504: {
                throw new IOException("" + rc + ": Connection through proxy timed out");
            }
        }
        throw new IOException("Connection failed: " + rc + ": " + urlc.getResponseMessage());
    }

    public void hideMetaDirectory() throws IOException {
        if (os.indexOf("windows") == -1) {
            return;
        }
        String[] cmd = new String[]{"ATTRIB", "+H", this.getMetaDirectory().getCanonicalPath()};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new Error("ATTRIB failed: cannot hide meta data folder");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setProxy(Proxy p) {
        this.proxy = p;
    }

    void loadConfig(File configFile) throws FileNotFoundException, IOException {
        String line;
        this.cfgfile = configFile;
        BufferedReader r = new BufferedReader(new FileReader(this.cfgfile));
        Authority curAuth = null;
        boolean inPolicy = false;
        while ((line = r.readLine()) != null) {
            String[] tokens;
            this.lines.add(line);
            if (curAuth != null && line.startsWith("[")) {
                this.authorities.put(curAuth.prefix, curAuth);
                curAuth = null;
            }
            if (inPolicy && line.startsWith("[")) {
                inPolicy = false;
            }
            if (line.startsWith("preferred-authority")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2) continue;
                this.preferred_authority_name = tokens[1].trim();
                continue;
            }
            if (line.startsWith("[authority") && line.endsWith("]")) {
                tokens = (line = line.substring(1, line.length() - 1)).split("_");
                if (tokens.length != 2) continue;
                curAuth = new Authority(tokens[1]);
                continue;
            }
            if (curAuth != null && line.startsWith("uuid")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2) continue;
                curAuth.uuid = tokens[1].trim();
                continue;
            }
            if (curAuth != null && line.startsWith("origin-for-")) {
                String plat;
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2 || !this.isThisPlatform(plat = tokens[0].trim().substring(11))) continue;
                curAuth.origin = tokens[1].trim();
                continue;
            }
            if (curAuth != null && line.startsWith("origin")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (curAuth.origin != null || tokens.length != 2) continue;
                curAuth.origin = tokens[1].trim();
                continue;
            }
            if (curAuth != null && line.startsWith("prefix")) {
                tokens = line.split("\\s*=\\s*", 2);
                if (tokens.length != 2) continue;
                curAuth.prefix = tokens[1].trim();
                continue;
            }
            if (line.startsWith("[policy]")) {
                inPolicy = true;
                continue;
            }
            if (!inPolicy || (tokens = line.split("\\s*=\\s*", 2)).length != 2) continue;
            this.policies.put(tokens[0].trim(), Boolean.parseBoolean(tokens[1].trim()));
        }
        if (curAuth != null) {
            this.authorities.put(curAuth.prefix, curAuth);
        }
        r.close();
    }

    public void saveConfig() throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(this.cfgfile));
        Authority curAuth = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            if (line.startsWith("[authority") && line.endsWith("]")) {
                String line1 = line.substring(1, line.length() - 1);
                String[] tokens = line1.split("_");
                if (tokens.length == 2) {
                    curAuth = this.authorities.get(tokens[1]);
                }
            } else if (curAuth != null && line.startsWith("uuid")) {
                line = "uuid = " + curAuth.uuid;
            } else if ((curAuth == null || !line.startsWith("origin-for-")) && curAuth != null && line.startsWith("origin")) {
                line = "origin = " + curAuth.origin;
            }
            w.write(line);
            w.newLine();
        }
        w.close();
    }

    public String getPreferredAuthorityName() {
        return this.preferred_authority_name;
    }

    public String[] getAuthorityNames() {
        return this.authorities.keySet().toArray(new String[0]);
    }

    public void setAuthority(String authname, URL origin, String uuid) {
        Authority a = this.authorities.get(authname);
        if (a == null && origin == null) {
            throw new IllegalArgumentException("Origin is required for a new authority");
        }
        if (a == null) {
            a = new Authority(authname);
            this.authorities.put(authname, a);
        }
        if (origin != null) {
            a.origin = origin.toString();
        }
        if (uuid != null) {
            a.uuid = uuid;
        }
    }

    public void refreshCatalogs() throws IOException {
        this.catalogCache = new CatalogCache();
        for (Map.Entry<Authority, Catalog> e : this.catalogs.entrySet()) {
            e.getValue().refresh();
            this.catalogCache.addCatalog(e.getValue(), e.getKey());
        }
        this.catalogCache.cacheInstalledPackages();
    }

    public List<FmriState> getInventory(String[] pkg_list, boolean all_known) {
        return this.catalogCache.getInventory(pkg_list, all_known);
    }

    boolean isInstalled(Fmri p) {
        try {
            File ifile = new File(p.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
            if (!ifile.exists()) {
                return false;
            }
            String auth = p.getAuthority();
            if (auth == null) {
                throw new IllegalArgumentException("Fmri must have authority set");
            }
            return auth.equals(this.getAuthorityForInstalledPkg((Fmri)p).prefix);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public ImagePlan makeInstallPlan(String[] pkgNames) throws IOException {
        ArrayList<Fmri> pkgs = new ArrayList<Fmri>();
        for (String p : pkgNames) {
            Fmri f = this.catalogCache.getFirst(p);
            if (f == null) {
                throw new IllegalArgumentException("no matching package for: " + p);
            }
            pkgs.add(f);
        }
        return this.makeInstallPlan(pkgs);
    }

    public ImagePlan makeInstallPlan(List<Fmri> pkgs) throws IOException {
        ImagePlan ip = new ImagePlan(false, null);
        for (Fmri pf : pkgs) {
            ip.proposeFmri(pf);
        }
        log.log(Level.FINER, "beforeeval", ip.toString());
        ip.evaluate();
        log.log(Level.FINER, "aftereval", ip.toString());
        return ip;
    }

    public void installPackages(String[] pkgNames) throws IOException {
        ImagePlan ip = this.makeInstallPlan(pkgNames);
        if (ip.nothingToDo()) {
            return;
        }
        log.log(Level.INFO, "installing", Arrays.toString(ip.getProposedFmris()));
        ip.execute();
    }

    public void installPackages(List<Fmri> pkgs) throws IOException {
        ImagePlan ip = this.makeInstallPlan(pkgs);
        if (ip.nothingToDo()) {
            return;
        }
        log.log(Level.INFO, "installing", pkgs.toString());
        ip.execute();
    }

    public void uninstallPackages(String[] pkgNames) throws IOException {
        ArrayList<Fmri> list = new ArrayList<Fmri>(pkgNames.length);
        for (int i = 0; i < pkgNames.length; ++i) {
            Fmri f = this.getVersionInstalled(new Fmri(pkgNames[i]));
            if (f == null) continue;
            list.add(f);
        }
        this.uninstallPackages(list);
    }

    public void uninstallPackages(List<Fmri> pkgs) throws IOException {
        ImagePlan ip = new ImagePlan(false, null);
        for (Fmri pf : pkgs) {
            ip.proposeFmriRemoval(pf);
        }
        log.log(Level.FINER, "beforeeval", ip.toString());
        ip.evaluate();
        log.log(Level.FINER, "aftereval", ip.toString());
        if (ip.nothingToDo()) {
            return;
        }
        log.log(Level.INFO, "uninstalling", pkgs.toString());
        ip.execute();
    }

    public Manifest getManifest(Fmri fmri) throws IOException {
        return new Manifest(this, fmri);
    }

    private boolean fmriIsSamePackage(Fmri fmri, Fmri pf) {
        return fmri.isSamePackage(pf);
    }

    private boolean fmriIsSuccessor(Fmri fmri, Fmri pf) {
        return fmri.isSuccessor(pf);
    }

    private List<Fmri> getInstalledFmrisFromCache() {
        List<FmriState> lfs = this.catalogCache.getInventory(null, false);
        ArrayList<Fmri> installed = new ArrayList<Fmri>();
        for (FmriState fs : lfs) {
            installed.add(fs.fmri);
        }
        return installed;
    }

    private List<Fmri> getInstalledFmrisFromImage() throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        ArrayList<Fmri> installedPkgs = new ArrayList<Fmri>();
        if (!istatedir.exists()) {
            this.updateInstalledPackages();
        }
        for (File f : istatedir.listFiles()) {
            String fmristr = URLDecoder.decode(f.getName(), "UTF-8");
            Fmri fmri = new Fmri(fmristr);
            installedPkgs.add(fmri);
        }
        return installedPkgs;
    }

    boolean getPolicy(String pname) {
        Boolean b = this.policies.get(pname);
        return b != null && b != false;
    }

    private Fmri getVersionInstalled(Fmri fmri) throws IOException {
        File pd = fmri.getPkgDir(new File(this.getMetaDirectory(), PKG_DIR));
        File[] pkgDirs = pd.listFiles();
        if (pkgDirs == null) {
            return null;
        }
        ArrayList<File> installedPkgs = new ArrayList<File>();
        for (File f : pkgDirs) {
            File ifile = new File(f, INSTALLED_FILE);
            if (!ifile.exists()) continue;
            installedPkgs.add(f);
        }
        if (installedPkgs.size() == 0) {
            return null;
        }
        if (installedPkgs.size() > 1) {
            throw new RuntimeException("package installed more than once: " + fmri);
        }
        Fmri ifmri = new Fmri((File)installedPkgs.get(0));
        ifmri.setAuthority(this.getAuthorityForInstalledPkg((Fmri)ifmri).prefix);
        return ifmri;
    }

    private Fmri getInstalledOlderVersion(Fmri fmri) throws IOException {
        return this.getVersionInstalled(fmri);
    }

    private boolean hasVersionInstalled(Fmri fmri) throws IOException {
        Fmri f = this.getVersionInstalled(fmri);
        return f != null && this.fmriIsSuccessor(f, fmri);
    }

    private Fmri applyOptionalDependencies(Fmri fmri) {
        return fmri;
    }

    private void updateOptionalDependency(Fmri f) {
    }

    private List<Fmri> getDependents(Fmri pfmri) {
        File thedir = new File(new File(new File(this.getMetaDirectory(), "index"), "depend"), pfmri.getName());
        if (!thedir.isDirectory()) {
            return Collections.emptyList();
        }
        for (File f : thedir.listFiles()) {
            Fmri fmri = new Fmri(f);
            if (!this.fmriIsSuccessor(pfmri, fmri)) continue;
            ArrayList<Fmri> dependents = new ArrayList<Fmri>();
            for (File d : f.listFiles()) {
                File ifile = new File(d, INSTALLED_FILE);
                if (!ifile.exists()) continue;
                try {
                    String dep = URLDecoder.decode(d.getName(), "UTF-8");
                    dependents.add(new Fmri(dep));
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(Image.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return dependents;
        }
        return Collections.emptyList();
    }

    private Authority getAuthorityForInstalledPkg(Fmri fmri) throws IOException {
        String pfx;
        String authname = null;
        File ifile = new File(fmri.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
        BufferedReader r = new BufferedReader(new FileReader(ifile));
        String line = r.readLine();
        authname = line != null && !line.equals("VERSION_1") ? line : ((line = r.readLine()).startsWith(pfx = "_PRE_") ? line.substring(pfx.length()) : line);
        r.close();
        Authority a = this.authorities.get(authname);
        if (a == null) {
            a = new Authority(authname);
            this.authorities.put(authname, a);
        }
        return a;
    }

    private void addInstallFile(Fmri fmri) throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        if (!istatedir.exists()) {
            this.updateInstalledPackages();
        }
        String authname = fmri.getAuthority();
        String prefpfx = "";
        String prefauth = this.getPreferredAuthorityName();
        if (authname == null || authname.equals(prefauth)) {
            authname = prefauth;
            prefpfx = "_PRE_";
        }
        File ifile = new File(fmri.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
        FileWriter fw = new FileWriter(ifile);
        fw.write("VERSION_1\n" + prefpfx + authname);
        fw.close();
        File isfile = new File(istatedir, fmri.getLinkFileName());
        isfile.createNewFile();
    }

    private void removeInstallFile(Fmri fmri) throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        if (!istatedir.exists()) {
            this.updateInstalledPackages();
        }
        File ifile = new File(fmri.getPkgVersionDir(new File(this.getMetaDirectory(), PKG_DIR)), INSTALLED_FILE);
        ifile.delete();
        File isfile = new File(istatedir, fmri.getLinkFileName());
        isfile.delete();
    }

    private void updateInstalledPackages() throws IOException {
        File istatedir = new File(this.getMetaDirectory(), ISTATE_DIR);
        File tmpdir = new File(this.getMetaDirectory(), ISTATE_DIR_TMP);
        if (!tmpdir.mkdirs()) {
            throw new IOException("unable to create installed packages directory");
        }
        File proot = new File(this.getMetaDirectory(), PKG_DIR);
        for (File pd : proot.listFiles()) {
            for (File vd : pd.listFiles()) {
                File path = new File(vd, INSTALLED_FILE);
                if (!path.exists()) continue;
                String fmristr = URLDecoder.decode(pd.getName() + "@" + vd.getName(), "UTF-8");
                Fmri f = new Fmri(fmristr);
                File fi = new File(tmpdir, f.getLinkFileName());
                fi.createNewFile();
            }
        }
        if (!tmpdir.renameTo(istatedir)) {
            for (File f : tmpdir.listFiles()) {
                f.delete();
            }
            tmpdir.delete();
        }
    }

    static String getVersion() {
        String version = log.getResourceBundle().getString("version");
        if (version == null) {
            version = "0";
        }
        log.log(Level.FINE, "versionmsg", version);
        return version;
    }

    boolean isThisPlatform(String plat) {
        String[][] c = new String[][]{{"sunos-i386", "sunos", "x86"}, {"sunos-sparc", "sunos", "sparc"}, {"linux-i386", "linux", ""}, {"windows-i386", "windows", ""}, {"darwin-universal", "mac os x", ""}};
        for (int i = 0; i < c.length; ++i) {
            if (!plat.equals(c[i][0]) || os.indexOf(c[i][1]) == -1 || arch.indexOf(c[i][2]) == -1) continue;
            return true;
        }
        return false;
    }

    static class Authority {
        String prefix;
        String origin;
        String uuid = "None";

        Authority(String name) {
            this.prefix = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CatalogCache {
        HashMap<String, CacheEntry> pkgs = new HashMap();

        CatalogCache() {
        }

        void cacheInstalledPackages() throws IOException {
            for (Fmri f : Image.this.getInstalledFmrisFromImage()) {
                Authority a = Image.this.getAuthorityForInstalledPkg(f);
                if (a == null) {
                    throw new RuntimeException("can't determine authority for installed package: " + f);
                }
                this.cacheFmri(f, a);
            }
        }

        void addCatalog(Catalog c, Authority a) {
            for (Fmri f : c.getFmris()) {
                this.cacheFmri(f, a);
            }
        }

        private void cacheFmri(Fmri f, Authority a) {
            String pname = f.getName();
            Version v = f.getVersion();
            CacheEntry ce = this.pkgs.get(pname);
            if (ce == null) {
                this.pkgs.put(pname, new CacheEntry(f, a));
            } else {
                SubCacheEntry sce = ce.versionInfo.get(v);
                if (sce == null) {
                    ce.versionInfo.put(v, new SubCacheEntry(f, a));
                    ce.versions.add(v);
                } else if (!sce.auths.contains(a)) {
                    sce.auths.add(a);
                }
            }
        }

        List<Fmri> multimatch(String pname, Fmri[] pkgFmris) {
            ArrayList<Fmri> matches = new ArrayList<Fmri>();
            pname = "/" + pname;
            for (Fmri f : pkgFmris) {
                if (!pname.endsWith("/" + f.getName())) continue;
                matches.add(f);
            }
            return matches;
        }

        List<FmriState> getInventory(String[] patternNames, boolean allKnown) {
            if (patternNames == null) {
                patternNames = new String[]{};
            }
            Fmri[] patternFmris = new Fmri[patternNames.length];
            for (int i = 0; i < patternNames.length; ++i) {
                patternFmris[i] = new Fmri(patternNames[i]);
            }
            ArrayList<FmriState> results = new ArrayList<FmriState>();
            String pauth = Image.this.getPreferredAuthorityName();
            for (String name : this.pkgs.keySet()) {
                List<Fmri> matches = this.multimatch(name, patternFmris);
                if (patternFmris.length > 0 && matches.size() == 0) continue;
                Version newest = this.pkgs.get((Object)name).versions.last();
                Version[] vlist = this.pkgs.get((Object)name).versions.toArray(new Version[0]);
                HashMap<Version, SubCacheEntry> vinfo = this.pkgs.get((Object)name).versionInfo;
                for (int i = vlist.length - 1; i >= 0; --i) {
                    ArrayList<Fmri> vmatches = new ArrayList<Fmri>();
                    for (Fmri m : matches) {
                        Version mv = m.getVersion();
                        if (!mv.isNull() && !vlist[i].isSuccessor(mv)) continue;
                        vmatches.add(m);
                    }
                    if (matches.size() > 0 && vmatches.size() == 0) continue;
                    List<Authority> authlist = vinfo.get((Object)vlist[i]).auths;
                    ArrayList<Fmri> amatches = new ArrayList<Fmri>();
                    for (Fmri m : vmatches) {
                        String mauth = m.getAuthority();
                        if (mauth != null && !authlist.contains(Image.this.authorities.get(mauth))) continue;
                        amatches.add(m);
                    }
                    if (vmatches.size() > 0 && amatches.size() == 0) continue;
                    List<Authority> alist = null;
                    if (amatches.size() == 0) {
                        alist = authlist;
                    } else {
                        for (Fmri m : amatches) {
                            if (m.getAuthority() != null) continue;
                            alist = authlist;
                            break;
                        }
                        if (alist == null) {
                            alist = new ArrayList<Authority>();
                            for (Authority a : authlist) {
                                for (Fmri m : amatches) {
                                    if (!a.prefix.equals(m.getAuthority())) continue;
                                    alist.add(a);
                                }
                            }
                        }
                    }
                    Fmri vfmri = vinfo.get((Object)vlist[i]).fmri;
                    for (Authority a : alist) {
                        FmriState fs = new FmriState();
                        fs.fmri = vfmri.clone();
                        fs.fmri.setAuthority(a.prefix);
                        fs.upgradable = !vlist[i].equals(newest);
                        fs.installed = Image.this.isInstalled(fs.fmri);
                        if (!allKnown && !fs.installed) continue;
                        results.add(fs);
                    }
                }
            }
            return results;
        }

        Fmri getFirst(String pattern) {
            String[] plist = new String[]{pattern};
            List<FmriState> lfs = this.getInventory(plist, true);
            String pauth = Image.this.getPreferredAuthorityName();
            Fmri firstNonPref = null;
            for (FmriState fs : lfs) {
                if (fs.fmri.getAuthority().equals(pauth)) {
                    return fs.fmri;
                }
                if (firstNonPref != null) continue;
                firstNonPref = fs.fmri;
            }
            return firstNonPref;
        }

        class CacheEntry {
            SortedSet<Version> versions = new TreeSet<Version>();
            HashMap<Version, SubCacheEntry> versionInfo = new HashMap();

            CacheEntry(Fmri f, Authority a) {
                Version v = f.getVersion();
                this.versions.add(v);
                this.versionInfo.put(v, new SubCacheEntry(f, a));
            }
        }

        class SubCacheEntry {
            Fmri fmri;
            List<Authority> auths = new ArrayList<Authority>();

            SubCacheEntry(Fmri f, Authority a) {
                this.fmri = f;
                this.auths.add(a);
            }
        }
    }

    static class Filter {
        Filter() {
        }
    }

    public static class FmriState {
        public Fmri fmri;
        public boolean installed = false;
        public boolean upgradable = false;
        public boolean frozen = false;
        public boolean incorporated = false;
        public boolean excludes = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImagePlan {
        private PlanState state;
        private boolean recursiveRemoval;
        private List<Fmri> targetFmris = new ArrayList<Fmri>();
        private List<Fmri> targetRemFmris = new ArrayList<Fmri>();
        private List<PackagePlan> pkgPlans = new ArrayList<PackagePlan>();
        private List<File> directories = null;

        ImagePlan(boolean recursiveRemoval, Filter[] filters) {
            this.state = PlanState.UNEVALUATED;
            this.recursiveRemoval = recursiveRemoval;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            if (this.state == PlanState.UNEVALUATED) {
                s.append("UNEVALUTED:\n");
                for (Fmri t : this.targetFmris) {
                    s.append("+" + t + "\n");
                }
                for (Fmri t : this.targetRemFmris) {
                    s.append("-" + t + "\n");
                }
            } else {
                for (PackagePlan pp : this.pkgPlans) {
                    s.append(pp + "\n");
                }
            }
            return s.toString();
        }

        public Fmri[] getProposedFmris() {
            return this.targetFmris.toArray(new Fmri[this.targetFmris.size()]);
        }

        boolean isProposedFmri(Fmri fmri) {
            for (Fmri pf : this.targetFmris) {
                if (!Image.this.fmriIsSamePackage(fmri, pf)) continue;
                return !Image.this.fmriIsSuccessor(fmri, pf);
            }
            return false;
        }

        boolean isProposedRemFmri(Fmri fmri) {
            for (Fmri pf : this.targetRemFmris) {
                if (!Image.this.fmriIsSamePackage(fmri, pf)) continue;
                return true;
            }
            return false;
        }

        void proposeFmri(Fmri fmri) throws IOException {
            if (Image.this.hasVersionInstalled(fmri)) {
                return;
            }
            fmri = Image.this.applyOptionalDependencies(fmri);
            for (Fmri p : this.targetFmris) {
                if (Image.this.fmriIsSuccessor(fmri, p)) {
                    this.targetFmris.remove(p);
                    break;
                }
                if (!Image.this.fmriIsSuccessor(p, fmri)) continue;
                return;
            }
            this.targetFmris.add(fmri);
        }

        boolean olderVersionProposed(Fmri fmri) {
            for (Fmri p : this.targetFmris) {
                if (!Image.this.fmriIsSuccessor(fmri, p)) continue;
                return true;
            }
            return false;
        }

        void proposeFmriRemoval(Fmri fmri) throws IOException {
            if (!Image.this.hasVersionInstalled(fmri)) {
                return;
            }
            for (Fmri p : this.targetRemFmris) {
                if (!Image.this.fmriIsSuccessor(fmri, p)) continue;
                this.targetRemFmris.remove(p);
                break;
            }
            this.targetRemFmris.add(fmri);
        }

        List<Fmri> genNewInstalledPackages() {
            if (this.state != PlanState.EVALUATED_OK) {
                throw new RuntimeException("invalid image plan state");
            }
            List fmriset = Image.this.getInstalledFmrisFromCache();
            for (PackagePlan p : this.pkgPlans) {
                p.updatePackageSet(fmriset);
            }
            return fmriset;
        }

        List<File> getDirectories() throws IOException {
            if (this.directories == null) {
                this.directories = new ArrayList<File>();
                this.directories.add(new File(Image.img_root_prefix));
                this.directories.add(new File("var/sadm/install"));
                for (Fmri fmri : this.genNewInstalledPackages()) {
                    for (Action act : Image.this.getManifest(fmri).getActions()) {
                        List<File> dl = act.getReferencedDirectories();
                        if (dl == null) continue;
                        this.directories.addAll(dl);
                    }
                }
            }
            return this.directories;
        }

        void evaluateFmri(Fmri pfmri) throws IOException {
            Manifest m = Image.this.getManifest(pfmri);
            for (Action act : m.getActions()) {
                DependAction da;
                Fmri f;
                if (!(act instanceof DependAction) || Image.this.hasVersionInstalled(f = (da = (DependAction)act).getMinFmri()) || this.isProposedFmri(f)) continue;
                boolean req = true;
                DependAction.Type type = da.getType();
                if (type == DependAction.Type.OPTIONAL && !Image.this.getPolicy("Policy-Require-Optional")) {
                    req = false;
                } else if (type == DependAction.Type.TRANSFER && Image.this.getInstalledOlderVersion(f) == null) {
                    req = false;
                } else if (type == DependAction.Type.INCORPORATE) {
                    Image.this.updateOptionalDependency(f);
                    req = Image.this.getInstalledOlderVersion(f) != null || this.olderVersionProposed(f);
                }
                if (!req) continue;
                Fmri cf = Image.this.catalogCache.getFirst(da.keyValue());
                if (cf == null) {
                    throw new IOException("Unable to resolve dependency on package:" + da.keyValue());
                }
                this.proposeFmri(cf);
                this.evaluateFmri(cf);
            }
        }

        void addPackagePlan(Fmri pfmri) throws IOException {
            Manifest m = Image.this.getManifest(pfmri);
            PackagePlan pp = new PackagePlan();
            pp.proposeDestination(pfmri, m);
            pp.evaluate();
            this.pkgPlans.add(pp);
        }

        void evaluateFmriRemoval(Fmri pfmri) throws IOException {
            List dependents = Image.this.getDependents(pfmri);
            for (Fmri d : dependents) {
                if (!this.targetRemFmris.contains(d)) continue;
                dependents.remove(d);
            }
            if (dependents.size() > 0 && !this.recursiveRemoval) {
                StringBuffer msg = new StringBuffer();
                msg.append("Cannot remove '" + pfmri + "' due to the following packages that directly " + "depend on it:\n");
                for (Fmri d : dependents) {
                    msg.append(d.toString());
                    msg.append("\n");
                }
                throw new IllegalArgumentException(msg.toString());
            }
            Manifest m = Image.this.getManifest(pfmri);
            PackagePlan pp = new PackagePlan();
            pp.proposeRemoval(pfmri, m);
            pp.evaluate();
            for (Fmri d : dependents) {
                if (this.isProposedRemFmri(d) || Image.this.hasVersionInstalled(d)) continue;
                this.targetRemFmris.add(d);
                this.evaluateFmriRemoval(d);
            }
            this.pkgPlans.add(pp);
        }

        void evaluate() throws IOException {
            String outstring = "";
            ArrayList<Fmri> targetFmrisCopy = new ArrayList<Fmri>(this.targetFmris);
            for (Fmri f : targetFmrisCopy) {
                this.evaluateFmri(f);
            }
            for (Fmri f : this.targetFmris) {
                this.addPackagePlan(f);
            }
            for (Fmri f : this.targetRemFmris) {
                this.evaluateFmriRemoval(f);
            }
            this.state = PlanState.EVALUATED_OK;
        }

        boolean nothingToDo() {
            return this.pkgPlans.size() == 0;
        }

        public void execute() throws IOException {
            if (this.nothingToDo()) {
                this.state = PlanState.EXECUTED_OK;
                return;
            }
            for (PackagePlan p : this.pkgPlans) {
                p.preexecute();
            }
            ArrayList<Action> removals = new ArrayList<Action>();
            for (PackagePlan pp : this.pkgPlans) {
                removals.addAll(pp.getRemovalActions());
            }
            Collections.sort(removals, Collections.reverseOrder());
            log.log(Level.FINE, "removalphase");
            for (Action a : removals) {
                a.remove();
            }
            ArrayList<Manifest.Difference.ActionPair> updates = new ArrayList<Manifest.Difference.ActionPair>();
            for (PackagePlan pp : this.pkgPlans) {
                updates.addAll(pp.getUpdateActions());
            }
            ArrayList<Action> installs = new ArrayList<Action>();
            for (PackagePlan pp : this.pkgPlans) {
                installs.addAll(pp.getInstallActions());
            }
            for (Action a : new ArrayList(installs)) {
                if (!(a instanceof UserAction) && !(a instanceof GroupAction)) continue;
                updates.add(new Manifest.Difference.ActionPair(null, a));
                installs.remove(a);
            }
            Collections.sort(updates, new Comparator<Manifest.Difference.ActionPair>(){

                @Override
                public int compare(Manifest.Difference.ActionPair o1, Manifest.Difference.ActionPair o2) {
                    return o1.to.compareTo(o2.to);
                }

                public boolean equals(Manifest.Difference.ActionPair o1, Manifest.Difference.ActionPair o2) {
                    return o1.to.equals(o2.to);
                }
            });
            log.log(Level.FINE, "updatephase");
            for (Manifest.Difference.ActionPair ap : updates) {
                ap.to.install(ap.from);
            }
            Collections.sort(installs);
            log.log(Level.FINE, "installphase");
            for (Action a : installs) {
                a.install(null);
            }
            for (PackagePlan p : this.pkgPlans) {
                p.postExecute();
            }
            this.state = PlanState.EXECUTED_OK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PackagePlan {
        private Fmri originFmri = null;
        private Fmri destFmri = null;
        private Manifest originManifest = Manifest.nullManifest;
        private Manifest destManifest = Manifest.nullManifest;
        private Manifest.Difference diff;
        private FileList flist;

        PackagePlan() {
        }

        public String toString() {
            return "" + this.originFmri + " -> " + this.destFmri;
        }

        void proposeDestination(Fmri pfmri, Manifest m) {
            this.destFmri = pfmri;
            this.destManifest = m;
            if (Image.this.isInstalled(pfmri)) {
                throw new IllegalArgumentException("already installed: " + pfmri);
            }
        }

        void proposeRemoval(Fmri pfmri, Manifest m) {
            this.originFmri = pfmri;
            this.originManifest = m;
            if (!Image.this.isInstalled(pfmri)) {
                throw new IllegalArgumentException("not installed: " + pfmri);
            }
        }

        void updatePackageSet(List<Fmri> fmriset) {
            if (this.originFmri != null) {
                fmriset.remove(this.originFmri);
            }
            if (this.destFmri != null) {
                fmriset.add(this.destFmri);
            }
        }

        void evaluate() throws IOException {
            Fmri f;
            if (this.originFmri == null && (f = Image.this.getInstalledOlderVersion(this.destFmri)) != null) {
                this.originFmri = f;
                this.originManifest = Image.this.getManifest(f);
            }
            if (this.destManifest != null && this.destManifest.hasDuplicates()) {
                throw new IllegalArgumentException("dest manifest has duplicates: " + this.destFmri);
            }
            this.diff = this.destManifest.getDifference(this.originManifest);
        }

        void preexecute() throws IOException {
            this.flist = new FileList(Image.this, this.destFmri);
            if (this.destFmri == null) {
                Image.this.removeInstallFile(this.originFmri);
            }
            for (Action a : this.diff.added) {
                a.preinstall(null, this.flist);
            }
            for (Action a : this.diff.removed) {
                a.preremove();
            }
            for (Manifest.Difference.ActionPair ap : this.diff.changed) {
                ap.from.preremove();
                ap.to.preinstall(ap.from, this.flist);
            }
            this.flist.download();
        }

        List<Action> getInstallActions() {
            return this.diff.added;
        }

        List<Action> getRemovalActions() {
            return this.diff.removed;
        }

        List<Manifest.Difference.ActionPair> getUpdateActions() {
            return this.diff.changed;
        }

        void postExecute() throws IOException {
            for (Action a : this.diff.added) {
                a.postinstall(null);
            }
            for (Action a : this.diff.removed) {
                a.postremove();
            }
            for (Manifest.Difference.ActionPair ap : this.diff.changed) {
                ap.from.postremove();
                ap.to.postinstall(ap.from);
            }
            if (this.originFmri != null && this.destFmri != null) {
                Image.this.removeInstallFile(this.originFmri);
            }
            if (this.destFmri != null) {
                Image.this.addInstallFile(this.destFmri);
            }
            if (this.flist != null) {
                this.flist.cleanupDownload();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PlanState {
        UNEVALUATED,
        EVALUATED_OK,
        EVALUATED_ERROR,
        EXECUTED_OK,
        EXECUTED_ERROR;

    }
}

