/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.InjectionTarget;
import org.jvnet.hk2.config.PrimitiveDataType;
import org.jvnet.hk2.config.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomDocument {
    private volatile Translator translator = Translator.NOOP;
    protected final Map<Inhabitant<? extends ConfigInjector>, ConfigModel> models = new HashMap<Inhabitant<? extends ConfigInjector>, ConfigModel>();
    final Habitat habitat;
    Dom root;
    private final Map<String, DataType> validators = new HashMap<String, DataType>();
    static final List<String> PRIMS = Collections.unmodifiableList(Arrays.asList("boolean", "char", "int", "java.lang.Boolean", "java.lang.Character", "java.lang.Integer"));

    public DomDocument(Habitat habitat) {
        this.habitat = habitat;
        for (String prim : PRIMS) {
            this.validators.put(prim, new PrimitiveDataType(prim));
        }
    }

    public Dom getRoot() {
        return this.root;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    ConfigModel buildModel(Inhabitant<? extends ConfigInjector> i) {
        ConfigModel m = this.models.get(i);
        if (m == null) {
            m = new ConfigModel(this, i, (MultiMap<String, String>)i.metadata());
        }
        return m;
    }

    public ConfigModel buildModel(Class<?> clazz) {
        return this.buildModel(clazz.getName());
    }

    public ConfigModel buildModel(String fullyQualifiedClassName) {
        Inhabitant i = this.habitat.getInhabitantByAnnotation(InjectionTarget.class, fullyQualifiedClassName);
        if (i == null) {
            throw new ComponentException("ConfigInjector for %s is not found", new Object[]{fullyQualifiedClassName});
        }
        return this.buildModel((Inhabitant<? extends ConfigInjector>)i);
    }

    public ConfigModel getModelByElementName(String elementName) {
        Inhabitant i = this.habitat.getInhabitant(ConfigInjector.class, elementName);
        if (i == null) {
            return null;
        }
        return this.buildModel((Inhabitant<? extends ConfigInjector>)i);
    }

    @Deprecated
    public ConfigModel getModel(Class c) {
        return this.buildModel(c);
    }

    public Dom make(Habitat habitat, XMLStreamReader in, Dom parent, ConfigModel model) {
        return new Dom(habitat, this, parent, model, in);
    }

    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        this.root.writeTo(null, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataType getValidator(String dataType) {
        Map<String, DataType> map = this.validators;
        synchronized (map) {
            DataType validator = this.validators.get(dataType);
            if (validator != null) {
                return validator;
            }
        }
        Collection dtfh = this.habitat.getAllByContract(DataType.class);
        Map<String, DataType> map2 = this.validators;
        synchronized (map2) {
            for (DataType dt : dtfh) {
                this.validators.put(dt.getClass().getCanonicalName(), dt);
            }
            return this.validators.get(dataType);
        }
    }
}

