/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.AlternateDocBase;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContext
implements ServletContext {
    private static final SecurityPermission GET_UNWRAPPED_CONTEXT_PERMISSION = new SecurityPermission("getUnwrappedContext");
    private Map attributes = new ConcurrentHashMap();
    private HashMap readOnlyAttributes = new HashMap();
    private StandardContext context = null;
    private static final ArrayList empty = new ArrayList();
    private ServletContext facade = new ApplicationContextFacade(this);
    private HashMap parameters = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private String basePath = null;
    private ArrayList<AlternateDocBase> alternateDocBases = null;
    private String logPrefix = null;
    private ThreadLocal<DispatchData> dispatchData = new ThreadLocal();

    public ApplicationContext(String basePath, StandardContext context) {
        this(basePath, null, context);
    }

    public ApplicationContext(String basePath, ArrayList<AlternateDocBase> alternateDocBases, StandardContext context) {
        this.context = context;
        this.basePath = basePath;
        this.alternateDocBases = alternateDocBases;
        this.logPrefix = sm.getString("applicationContext.logPrefix", context.logName());
        this.setAttribute("com.sun.faces.useMyFaces", context.isUseMyFaces());
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet(), true);
    }

    public String getContextPath() {
        return this.context.getPath();
    }

    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        Context child = null;
        try {
            int slash;
            Host host = (Host)this.context.getParent();
            String mapuri = uri;
            while ((child = (Context)host.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
                mapuri = mapuri.substring(0, slash);
            }
        }
        catch (Throwable t) {
            return null;
        }
        if (child == null) {
            return null;
        }
        if (this.context.getCrossContext()) {
            return child.getServletContext();
        }
        if (child == this.context) {
            return this.context.getServletContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInitParameter(String name) {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameterNames() {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return new Enumerator(this.parameters.keySet());
        }
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(extension);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(name);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationDispatcher(wrapper, null, null, null, null, name);
    }

    public String getRealPath(String path) {
        AlternateDocBase match;
        if (!this.context.isFilesystemBased()) {
            return null;
        }
        if (path == null) {
            return null;
        }
        File file = null;
        file = this.alternateDocBases == null || this.alternateDocBases.size() == 0 ? new File(this.basePath, path) : ((match = AlternateDocBase.findMatch(path, this.alternateDocBases)) != null ? new File(match.getBasePath(), path) : new File(this.basePath, path));
        return file.getAbsolutePath();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        String queryString = null;
        int pos = path.indexOf(63);
        if (pos >= 0) {
            queryString = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        pos = path.length();
        DispatchData dd = this.dispatchData.get();
        if (dd == null) {
            dd = new DispatchData();
            this.dispatchData.set(dd);
        }
        MessageBytes uriMB = dd.uriMB;
        uriMB.recycle();
        MappingData mappingData = dd.mappingData;
        CharChunk uriCC = uriMB.getCharChunk();
        try {
            uriCC.append(this.context.getPath(), 0, this.context.getPath().length());
            int semicolon = path.indexOf(59);
            if (pos >= 0 && semicolon > pos) {
                semicolon = -1;
            }
            uriCC.append(path, 0, semicolon > 0 ? semicolon : pos);
            this.context.getMapper().map(uriMB, mappingData);
            if (mappingData.wrapper == null) {
                return null;
            }
            if (semicolon > 0) {
                uriCC.append(path, semicolon, pos - semicolon);
            }
        }
        catch (Exception e) {
            this.log(sm.getString("applicationContext.mapping.error"), e);
            return null;
        }
        Wrapper wrapper = (Wrapper)mappingData.wrapper;
        String wrapperPath = mappingData.wrapperPath.toString();
        String pathInfo = mappingData.pathInfo.toString();
        mappingData.recycle();
        return new ApplicationDispatcher(wrapper, uriCC.toString(), wrapperPath, pathInfo, queryString, null);
    }

    public URL getResource(String path) throws MalformedURLException {
        AlternateDocBase match;
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        String libPath = "/WEB-INF/lib/";
        if (path.startsWith(libPath) && path.endsWith(".jar")) {
            File jarFile = null;
            jarFile = this.context.isFilesystemBased() ? new File(this.basePath, path) : new File(this.context.getWorkPath(), path);
            if (jarFile.exists()) {
                return jarFile.toURL();
            }
            return null;
        }
        Object resources = null;
        resources = this.alternateDocBases == null || this.alternateDocBases.size() == 0 ? this.context.getResources() : ((match = AlternateDocBase.findMatch(path, this.alternateDocBases)) != null ? match.getResources() : this.context.getResources());
        if (resources != null) {
            String fullPath = this.context.getName() + path;
            String hostName = this.context.getParent().getName();
            try {
                resources.lookup(path);
                return new URL("jndi", "", 0, ApplicationContext.getJNDIUri(hostName, fullPath), (URLStreamHandler)new DirContextURLStreamHandler((DirContext)resources));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        AlternateDocBase match;
        if ((path = this.normalize(path)) == null || !path.startsWith("/")) {
            return null;
        }
        Object resources = null;
        resources = this.alternateDocBases == null || this.alternateDocBases.size() == 0 ? this.context.getResources() : ((match = AlternateDocBase.findMatch(path, this.alternateDocBases)) != null ? match.getResources() : this.context.getResources());
        if (resources != null) {
            try {
                Object resource = resources.lookup(path);
                if (resource instanceof Resource) {
                    return ((Resource)resource).streamContent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        AlternateDocBase match;
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.resourcePaths.iae", path));
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        Object resources = null;
        resources = this.alternateDocBases == null || this.alternateDocBases.size() == 0 ? this.context.getResources() : ((match = AlternateDocBase.findMatch(path, this.alternateDocBases)) != null ? match.getResources() : this.context.getResources());
        if (resources != null) {
            return this.getResourcePathsInternal((DirContext)resources, path);
        }
        return null;
    }

    private Set getResourcePathsInternal(DirContext resources, String path) {
        ResourceSet set = new ResourceSet();
        try {
            ApplicationContext.listCollectionPaths(set, resources, path);
        }
        catch (NamingException e) {
            return null;
        }
        set.setLocked(true);
        return set;
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    public Enumeration getServletNames() {
        return new Enumerator(empty);
    }

    public Enumeration getServlets() {
        return new Enumerator(empty);
    }

    public void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(this.logPrefix + message, 3);
        }
    }

    public void log(Exception exception, String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(exception, this.context.logName() + message);
        }
    }

    public void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(this.context.logName() + message, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        Map map = this.attributes;
        synchronized (map) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            found = this.attributes.containsKey(name);
            if (!found) {
                return;
            }
            value = this.attributes.get(name);
            this.attributes.remove(name);
        }
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object[] listeners;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        Map map = this.attributes;
        synchronized (map) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            oldValue = this.attributes.get(name);
            if (oldValue != null) {
                replaced = true;
            }
            this.attributes.put(name, value);
        }
        if (name.equals("org.apache.catalina.jsp_classpath") || name.equals("com.sun.jsp.tldUriToLocationMap")) {
            this.setAttributeReadOnly(name);
        }
        if ((listeners = this.context.getApplicationEventListeners()) == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    public void addServlet(String servletName, String description, String className, Map<String, String> initParameters, int loadOnStartup) {
        this.context.addServlet(servletName, description, className, initParameters, loadOnStartup);
    }

    public void addServletMapping(String servletName, String[] urlPatterns) {
        this.context.addServletMapping(servletName, urlPatterns);
    }

    public void addFilter(String filterName, String description, String className, Map<String, String> initParameters) {
        this.context.addFilter(filterName, description, className, initParameters);
    }

    public StandardContext getUnwrappedContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_UNWRAPPED_CONTEXT_PERMISSION);
        }
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAttributes() {
        ArrayList list = new ArrayList();
        Map map = this.attributes;
        synchronized (map) {
            Iterator iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        for (String key : list) {
            this.removeAttribute(key);
        }
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributeReadOnly(String name) {
        Map map = this.attributes;
        synchronized (map) {
            if (this.attributes.containsKey(name)) {
                this.readOnlyAttributes.put(name, name);
            }
        }
    }

    private String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    private void mergeParameters() {
        if (this.parameters != null) {
            return;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        String[] names = this.context.findParameters();
        for (int i = 0; i < names.length; ++i) {
            results.put(names[i], this.context.findParameter(names[i]));
        }
        ApplicationParameter[] params = this.context.findApplicationParameters();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getOverride()) {
                if (results.get(params[i].getName()) != null) continue;
                results.put(params[i].getName(), params[i].getValue());
                continue;
            }
            results.put(params[i].getName(), params[i].getValue());
        }
        this.parameters = results;
    }

    private static void listPaths(Set set, DirContext resources, String path) throws NamingException {
        NamingEnumeration<Binding> childPaths = resources.listBindings(path);
        while (childPaths.hasMoreElements()) {
            Binding binding = (Binding)childPaths.nextElement();
            String name = binding.getName();
            String childPath = path + "/" + name;
            set.add(childPath);
            Object object = binding.getObject();
            if (!(object instanceof DirContext)) continue;
            ApplicationContext.listPaths(set, resources, childPath);
        }
    }

    private static void listCollectionPaths(Set set, DirContext resources, String path) throws NamingException {
        NamingEnumeration<Binding> childPaths = resources.listBindings(path);
        while (childPaths.hasMoreElements()) {
            Binding binding = (Binding)childPaths.nextElement();
            String name = binding.getName();
            StringBuffer childPath = new StringBuffer(path);
            if (!"/".equals(path) && !path.endsWith("/")) {
                childPath.append("/");
            }
            childPath.append(name);
            Object object = binding.getObject();
            if (object instanceof DirContext) {
                childPath.append("/");
            }
            set.add(childPath.toString());
        }
    }

    private static String getJNDIUri(String hostName, String path) {
        if (!path.startsWith("/")) {
            return "/" + hostName + "/" + path;
        }
        return "/" + hostName + path;
    }

    private static final class DispatchData {
        public MessageBytes uriMB = MessageBytes.newInstance();
        public MappingData mappingData;

        public DispatchData() {
            CharChunk uriCC = this.uriMB.getCharChunk();
            uriCC.setLimit(-1);
            this.mappingData = new MappingData();
        }
    }
}

