/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.CMPLifeCycleListener;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.UpdateObjectQuery;

public class CMPPolicy
implements Serializable {
    public static boolean OPTIMIZE_PESSIMISTIC_CMP = false;
    protected Boolean forceUpdate = null;
    protected Boolean updateAllFields = null;
    protected PessimisticLockingPolicy pessimisticLockingPolicy;
    protected CMPLifeCycleListener lifeCycleListener;
    protected Class mappedClass;
    protected ClassDescriptor descriptor;
    protected int modificationDeferralLevel = 2;
    public static final int NONE = 0;
    public static final int UPDATE_MODIFICATIONS = 1;
    public static final int ALL_MODIFICATIONS = 2;
    protected int nonDeferredCreateTime = 0;
    public static final int UNDEFINED = 0;
    public static final int AFTER_EJBCREATE = 1;
    public static final int AFTER_EJBPOSTCREATE = 2;

    public void postInsert(Object bean, AbstractSession session) {
        if (this.getLifeCycleListener() != null) {
            this.getLifeCycleListener().postInsert(bean, session);
        }
    }

    public void invokeEJBLoad(Object bean, AbstractSession session) {
        if (this.getLifeCycleListener() != null) {
            this.getLifeCycleListener().invokeEJBLoad(bean, session);
        }
    }

    public void invokeEJBStore(Object bean, AbstractSession session) {
        if (this.getLifeCycleListener() != null) {
            this.getLifeCycleListener().invokeEJBStore(bean, session);
        }
    }

    public CMPLifeCycleListener getLifeCycleListener() {
        return this.lifeCycleListener;
    }

    public void setLifeCycleListener(CMPLifeCycleListener lifeCycleListener) {
        this.lifeCycleListener = lifeCycleListener;
    }

    public int getNonDeferredCreateTime() {
        return this.nonDeferredCreateTime;
    }

    public PessimisticLockingPolicy getPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy;
    }

    public void setDeferModificationsUntilCommit(int deferralLevel) {
        this.modificationDeferralLevel = deferralLevel;
    }

    public void setMappedClass(Class newMappedClass) {
        this.mappedClass = newMappedClass;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public void setNonDeferredCreateTime(int createTime) {
        this.nonDeferredCreateTime = createTime;
    }

    public void setPessimisticLockingPolicy(PessimisticLockingPolicy policy) {
        this.pessimisticLockingPolicy = policy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy != null;
    }

    public int getDeferModificationsUntilCommit() {
        return this.modificationDeferralLevel;
    }

    public boolean getForceUpdate() {
        return Boolean.TRUE.equals(this.forceUpdate);
    }

    public void setForceUpdate(boolean shouldForceUpdate) {
        this.forceUpdate = shouldForceUpdate;
    }

    public boolean getUpdateAllFields() {
        return Boolean.TRUE.equals(this.updateAllFields);
    }

    public void setUpdateAllFields(boolean shouldUpdatAllFields) {
        this.updateAllFields = shouldUpdatAllFields;
    }

    public Boolean internalGetForceUpdate() {
        return this.forceUpdate;
    }

    public Boolean internalGetUpdateAllFields() {
        return this.updateAllFields;
    }

    public void internalSetForceUpdate(Boolean newForceUpdateValue) {
        this.forceUpdate = newForceUpdateValue;
    }

    public void internalSetUpdateAllFields(Boolean newUpdateAllFieldsValue) {
        this.updateAllFields = newUpdateAllFieldsValue;
    }

    public void initialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        if (this.getUpdateAllFields() && !descriptor.getQueryManager().hasUpdateQuery()) {
            descriptor.getQueryManager().setUpdateQuery(new UpdateObjectQuery());
        }
        if (this.getForceUpdate() && !this.getUpdateAllFields()) {
            throw DescriptorException.updateAllFieldsNotSet(descriptor);
        }
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor owningDescriptor) {
        this.descriptor = owningDescriptor;
    }

    public boolean isCMP3Policy() {
        return false;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createPrimaryKeyInstance(Vector key) {
        Object keyInstance = this.getPKClassInstance();
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(this.getPKClass());
        for (int index = 0; index < pkElementArray.length; ++index) {
            KeyElementAccessor accessor = pkElementArray[index];
            Object fieldValue = key.get(index);
            accessor.setValue(keyInstance, fieldValue);
        }
        return keyInstance;
    }

    public Object createPrimaryKeyInstance(Object key, AbstractSession session) {
        Object keyInstance = this.getPKClassInstance();
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(this.getPKClass());
        for (int index = 0; index < pkElementArray.length; ++index) {
            KeyElementAccessor accessor = pkElementArray[index];
            DatabaseMapping mapping = builder.getMappingForAttributeName(accessor.getAttributeName());
            while (mapping.isAggregateObjectMapping()) {
                if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(pkElementArray[index].getAttributeName())) != null) continue;
                mapping = builder.getMappingForField(accessor.getDatabaseField());
            }
            Object fieldValue = mapping.getRealAttributeValueFromObject(key, session);
            accessor.setValue(keyInstance, fieldValue);
        }
        return keyInstance;
    }

    public Object getPKClassInstance() {
        throw new RuntimeException("Should not get here.");
    }

    public Class getPKClass() {
        throw new RuntimeException("Should not get here.");
    }

    public Vector createPkVectorFromKey(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    public Object createBeanUsingKey(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    protected KeyElementAccessor[] getKeyClassFields(Class clazz) {
        throw new RuntimeException("Should not get here.");
    }

    protected static interface KeyElementAccessor {
        public String getAttributeName();

        public DatabaseField getDatabaseField();

        public Object getValue(Object var1);

        public void setValue(Object var1, Object var2);
    }

    protected class KeyIsElementAccessor
    implements KeyElementAccessor,
    Serializable {
        protected String attributeName;
        protected DatabaseField databaseField;

        public KeyIsElementAccessor(String attributeName, DatabaseField databaseField) {
            this.attributeName = attributeName;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            return object;
        }

        public void setValue(Object object, Object value) {
        }
    }
}

