/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.jdbc.admin.cli.JDBCResourceManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-jdbc-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jdbc.resource")
public class DeleteJdbcResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJdbcResource.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="jdbc_resource_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    JdbcResource[] jdbcResources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        try {
            JDBCResourceManager jdbcResMgr = new JDBCResourceManager();
            ResourceStatus rs = jdbcResMgr.delete(this.resources, this.jdbcResources, this.jndiName, targetServer);
            if (rs.getStatus() == 0) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                report.setMessage(rs.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                if (rs.getException() != null) {
                    report.setFailureCause(rs.getException());
                }
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("delete.jdbc.resource.fail", "{0} delete failed ", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

