/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.internal;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Extra;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.SystemStatus;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.monitor.Monitoring;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admin.amx.internal.SanityChecksMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SanityChecks
implements SanityChecksMBean {
    private final MBeanServerConnection mMBeanServer;
    private final DomainRoot mDomainRoot;
    private final QueryMgr mQueryMgr;
    public static final String SUCCESS = "OK";

    private static void debug(String s) {
        System.out.println(s);
    }

    private SanityChecks(MBeanServerConnection server) throws IOException {
        try {
            assert (false);
            throw new IllegalStateException("Assertions must be enabled");
        }
        catch (AssertionError assertionError) {
            this.mMBeanServer = server;
            this.mDomainRoot = ProxyFactory.getInstance(server).getDomainRoot();
            this.mQueryMgr = this.mDomainRoot.getQueryMgr();
            return;
        }
    }

    public static SanityChecks newInstance(MBeanServerConnection server) {
        try {
            server.getDomains();
            return new SanityChecks(server);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SanityChecks newInstance(MBeanServer server) {
        return SanityChecks.newInstance((MBeanServerConnection)server);
    }

    public DomainRoot getDomainRoot() {
        return this.mDomainRoot;
    }

    public QueryMgr getQueryMgr() {
        return this.mQueryMgr;
    }

    @Override
    public Map<String, Object> runAllTests() {
        Method[] candidates = SanityChecksMBean.class.getMethods();
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<Method> tests = new ArrayList<Method>();
        for (Method method : candidates) {
            String methodName = method.getName();
            if (!methodName.startsWith("test")) continue;
            tests.add(method);
        }
        ArrayList<TestRunner> threads = new ArrayList<TestRunner>();
        for (Method test : tests) {
            TestRunner runner = new TestRunner(this, test);
            threads.add(runner);
            runner.start();
        }
        for (TestRunner runner : threads) {
            try {
                runner.join();
                results.put(runner.getTestName(), runner.mResult);
            }
            catch (InterruptedException e) {
                results.put(runner.getTestName(), e);
            }
        }
        threads.clear();
        return results;
    }

    public Set<AMX> getAllAMX() {
        return this.mQueryMgr.queryAllSet();
    }

    public <T> Set<T> getAllAMX(Class<T> intf) {
        return this.getAllAMX(this.getAllAMX(), intf);
    }

    public <T> Set<T> getAllAMX(Set<AMX> all, Class<T> intf) {
        HashSet<T> result = new HashSet<T>();
        for (AMX amx : all) {
            if (!intf.isAssignableFrom(amx.getClass())) continue;
            result.add(intf.cast(amx));
        }
        return result;
    }

    private <T extends AMX> String successFor(Set<T> amx) {
        return "OK: " + amx.size() + " MBeans";
    }

    @Override
    public String testBasics() {
        ArrayList<String> problems = new ArrayList<String>();
        Set<AMX> all = this.getAllAMX();
        assert (all.size() > 20);
        for (AMX amx : all) {
            this._checkTypeAndInterfaces(amx);
            Extra extra = Util.getExtra(amx);
            ObjectName objectName = extra.getObjectName();
            String[] attrNames = extra.getAttributeNames();
            Map<String, Object> attrsMap = extra.getAllAttributes();
            Set<String> missing = GSetUtil.newStringSet(attrNames);
            missing.removeAll(attrsMap.keySet());
            if (missing.size() != 0) {
                String missingStr = CollectionUtil.toString(missing, ", ");
                String msg = "WARNING: could not retrieve attributes: {" + missingStr + "} for MBean " + JMXUtil.toString(objectName);
                SanityChecks.debug(msg);
                problems.add(msg);
                continue;
            }
            String msg = attrsMap.keySet().size() + " attrs fetched ok: " + JMXUtil.toString(Util.getExtra(amx).getObjectName());
        }
        assert (problems.size() == 0) : CollectionUtil.toString(problems, "\n");
        return this.successFor(all);
    }

    private void _checkTypeAndInterfaces(AMX amx) {
        ObjectName objectName = Util.getExtra(amx).getObjectName();
        if (amx instanceof AMXConfig) {
            assert (amx.getJ2EEType().startsWith("X-")) : "j2eeType prefix 'X-' required for " + objectName;
            assert (amx.getJ2EEType().endsWith("Config")) : "j2eeType suffix 'Config' required for " + objectName;
        }
        if (amx instanceof NamedConfigElement) {
            assert (!(amx instanceof Singleton)) : "NamedConfigElement must not be Singleton: " + amx.getJ2EEType();
            assert (!(amx instanceof Utility)) : "NamedConfigElement must not be Utility: " + amx.getJ2EEType();
            assert (!(amx instanceof Monitoring)) : "NamedConfigElement must not be Monitoring: " + amx.getJ2EEType();
        }
    }

    @Override
    public String testParentChild() {
        Set<AMX> all = this.getAllAMX();
        for (AMX amx : all) {
            this._checkParentChild(amx);
        }
        return this.successFor(all);
    }

    private void _checkParentChild(AMX amx) {
        if (!(amx instanceof DomainRoot)) {
            Container c = amx.getContainer();
            Set s = c.getContaineeSet(amx.getJ2EEType());
            assert (s.contains(amx));
            Map m = c.getContaineeMap(amx.getJ2EEType());
            assert (m.containsKey(amx.getName()));
        }
    }

    @Override
    public String testContainer() {
        Set<Container> all = this.getAllAMX(Container.class);
        for (Container amx : all) {
            this._checkContainer(amx);
        }
        return this.successFor(all);
    }

    private void _checkContainer(Container c) {
        Set<String> j2eeTypes = c.getContaineeJ2EETypes();
        Map containeeMap = c.getMultiContaineeMap(j2eeTypes);
        assert (containeeMap.keySet().size() <= j2eeTypes.size());
        Map m1 = c.getMultiContaineeMap(j2eeTypes);
        Map m2 = c.getMultiContaineeMap(null);
        assert (((Object)m1.keySet()).equals(m2.keySet()));
        Set s1 = c.getContaineeSet(j2eeTypes);
        for (String j2eeType : j2eeTypes) {
            Set byType = c.getContaineeSet(j2eeType);
            for (AMX amx : byType) {
                Object a = c.getContainee(j2eeType, amx.getName());
                assert (a == amx);
            }
        }
    }

    @Override
    public String testDefaultValues() {
        Set<AMXConfig> all = this.getAllAMX(AMXConfig.class);
        for (AMXConfig amx : all) {
            this._checkDefaultValues(amx);
        }
        return this.successFor(all);
    }

    private void _checkDefaultValues(AMXConfig amxConfig) {
        String objectName = JMXUtil.toString(Util.getExtra(amxConfig).getObjectName());
        Map<String, String> defaultValuesXML = amxConfig.getDefaultValues(false);
        for (String attrName : defaultValuesXML.keySet()) {
            assert (defaultValuesXML.get(attrName) != null) : "null value for attribute " + attrName + " in " + objectName;
            String value = amxConfig.getDefaultValue(attrName);
            assert (value != null) : "null value for XML attribute fetched singly: " + attrName + " in " + objectName;
        }
        Map<String, String> defaultValuesAMX = amxConfig.getDefaultValues(true);
        assert (defaultValuesXML.size() == defaultValuesAMX.size());
        for (String attrName : defaultValuesAMX.keySet()) {
            assert (defaultValuesAMX.get(attrName) != null) : "null value for attribute " + attrName + " in " + objectName;
            String value = amxConfig.getDefaultValue(attrName);
            assert (value != null) : "null value for AMX attribute fetched singly: " + attrName + " in " + objectName;
        }
    }

    @Override
    public String testAttributeResolver() {
        Set<AMXConfig> all = this.getAllAMX(AMXConfig.class);
        for (AMXConfig amx : all) {
            this._checkAttributeResolver(amx);
        }
        return this.successFor(all);
    }

    private void _checkAttributeResolver(AMXConfig amxConfig) {
        String resolvedValue;
        String[] attrNames;
        for (String attrName : attrNames = Util.getExtra(amxConfig).getAttributeNames()) {
            resolvedValue = amxConfig.resolveAttribute(attrName);
            if (resolvedValue != null) assert (resolvedValue.indexOf("${") < 0) : "Attribute " + attrName + " did not resolve: " + resolvedValue;
        }
        AttributeList attrsList = amxConfig.resolveAttributes(attrNames);
        for (Object o : attrsList) {
            Attribute a = (Attribute)o;
            resolvedValue = "" + a.getValue();
            if (resolvedValue != null) assert (resolvedValue.indexOf("${") < 0) : "Attribute " + a.getName() + " did not resolve: " + resolvedValue;
        }
    }

    @Override
    public String testSystemStatus() {
        SystemStatus ss = this.getDomainRoot().getSystemStatus();
        List<Object[]> restarts = ss.getRestartRequiredChanges();
        Set pools = this.getQueryMgr().queryJ2EETypeSet("X-JDBCConnectionPoolConfig");
        for (JDBCConnectionPoolConfig pool : pools) {
            Map<String, Object> result = ss.pingJDBCConnectionPool(pool.getName());
        }
        return this.successFor(pools);
    }

    private final class TestRunner
    extends Thread {
        private final SanityChecks mTarget;
        private final Method mTest;
        volatile Object mResult = null;

        TestRunner(SanityChecks target, Method test) {
            this.mTarget = target;
            this.mTest = test;
        }

        public String getTestName() {
            return this.mTest.getName();
        }

        public void run() {
            try {
                String result = (String)this.mTest.invoke((Object)this.mTarget, new Object[0]);
                this.mResult = result;
            }
            catch (Throwable t) {
                this.mResult = t;
            }
        }
    }
}

