/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.admin;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="ping-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="ping.connection.pool")
public class PingJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PingJdbcConnectionPool.class);
    @Param(name="pool_name", primary=true)
    String poolName;
    @Inject
    private ConnectorRuntime connRuntime;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean status = false;
        try {
            status = this.connRuntime.pingConnectionPool(this.poolName);
            if (status) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(localStrings.getLocalString("ping.connection.pool.fail", "Ping JDBC Connection Pool for {0} Failed", new Object[]{this.poolName}));
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("ping.connection.pool.fail", "Ping JDBC Connection Pool for {0} Failed", new Object[]{this.poolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

